/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.hc.core5.testing.classic;

import org.apache.hc.core5.http.URIScheme;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;

class ClassicIntegrationTests {

    @Nested
    @DisplayName("Core transport")
    class CoreTransport extends ClassicHttp1CoreTransportTest {

        public CoreTransport() {
            super(URIScheme.HTTP);
        }

    }

    @Nested
    @DisplayName("Core transport (TLS)")
    class CoreTransportTls extends ClassicHttp1CoreTransportTest {

        public CoreTransportTls() {
            super(URIScheme.HTTPS);
        }

    }

    @Nested
    @DisplayName("Authentication")
    class Authentication extends ClassicAuthenticationTest {

        public Authentication() {
            super(false);
        }

    }

    @Nested
    @DisplayName("Authentication (immediate response)")
    class AuthenticationImmediateResponse extends ClassicAuthenticationTest {

        public AuthenticationImmediateResponse() {
            super(true);
        }

    }

    @Nested
    @DisplayName("Out-of-order response monitoring")
    class MonitoringResponseOutOfOrderStrategy extends MonitoringResponseOutOfOrderStrategyIntegrationTest {

        public MonitoringResponseOutOfOrderStrategy() {
            super(URIScheme.HTTP);
        }

    }

    @Nested
    @DisplayName("Out-of-order response monitoring (TLS)")
    class MonitoringResponseOutOfOrderStrategyTls extends MonitoringResponseOutOfOrderStrategyIntegrationTest {

        public MonitoringResponseOutOfOrderStrategyTls() {
            super(URIScheme.HTTPS);
        }

    }

    @Nested
    @DisplayName("Server filters")
    class HttpFilters extends ClassicServerBootstrapFilterTest {

        public HttpFilters() {
            super(URIScheme.HTTP);
        }

    }

}
