/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreV2;
import org.apache.ignite.lang.IgniteOutClosure;

public class FileVersionCheckingFactory {
    public static final String LATEST_VERSION_OVERRIDE_PROPERTY = "file.page.store.latest.version.override";
    public static final int LATEST_VERSION = 2;
    private final FileIOFactory fileIOFactory;
    private final FileIOFactory fileIOFactoryStoreV1;
    private final IntSupplier pageSize;

    public FileVersionCheckingFactory(FileIOFactory fileIOFactory, FileIOFactory fileIOFactoryStoreV1, IntSupplier pageSize) {
        this.fileIOFactory = fileIOFactory;
        this.fileIOFactoryStoreV1 = fileIOFactoryStoreV1;
        this.pageSize = pageSize;
    }

    public PageStore createPageStore(byte type, File file, LongConsumer allocatedTracker) throws IgniteCheckedException {
        return this.createPageStore(type, file::toPath, allocatedTracker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PageStore createPageStore(byte type, IgniteOutClosure<Path> pathProvider, LongConsumer allocatedTracker) throws IgniteCheckedException {
        Path filePath = pathProvider.apply();
        if (!Files.exists(filePath, new LinkOption[0])) {
            return this.createPageStore(type, pathProvider, this.pageSize.getAsInt(), this.latestVersion(), allocatedTracker);
        }
        try (FileIO fileIO = this.fileIOFactoryStoreV1.create(filePath.toFile());){
            int minHdr = 17;
            if (fileIO.size() < (long)minHdr) {
                FilePageStore filePageStore2 = this.createPageStore(type, pathProvider, this.pageSize.getAsInt(), this.latestVersion(), allocatedTracker);
                return filePageStore2;
            }
            ByteBuffer hdr = ByteBuffer.allocate(minHdr).order(ByteOrder.nativeOrder());
            fileIO.readFully(hdr);
            hdr.rewind();
            hdr.getLong();
            int ver = hdr.getInt();
            FilePageStore filePageStore = this.createPageStore(type, pathProvider, this.pageSize.getAsInt(), ver, allocatedTracker);
            return filePageStore;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Error while creating file page store [file=" + filePath.toAbsolutePath() + "]:", e);
        }
    }

    public int latestVersion() {
        int latestVer = 2;
        try {
            latestVer = Integer.parseInt(System.getProperty(LATEST_VERSION_OVERRIDE_PROPERTY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return latestVer;
    }

    private FilePageStore createPageStore(byte type, IgniteOutClosure<Path> pathProvider, int pageSize, int ver, LongConsumer allocatedTracker) {
        switch (ver) {
            case 1: {
                return new FilePageStore(type, pathProvider, this.fileIOFactoryStoreV1, pageSize, allocatedTracker);
            }
            case 2: {
                return new FilePageStoreV2(type, pathProvider, this.fileIOFactory, pageSize, allocatedTracker);
            }
        }
        throw new IllegalArgumentException("Unknown version of file page store: " + ver + " for file [" + pathProvider.apply().toAbsolutePath() + "]");
    }

    public int headerSize(int ver) {
        switch (ver) {
            case 1: {
                return 17;
            }
            case 2: {
                return this.pageSize.getAsInt();
            }
        }
        throw new IllegalArgumentException("Unknown version of file page store.");
    }
}

