/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;

public class GridHandleTable {
    private final int initCap;
    private final float loadFactor;
    private int size;
    private int threshold;
    private int[] spine;
    private int[] next;
    private Object[] objs;

    public GridHandleTable(int initCap, float loadFactor) {
        this.initCap = initCap;
        this.loadFactor = loadFactor;
        this.init(initCap, initCap);
    }

    private void init(int spineLen, int size) {
        this.spine = new int[spineLen];
        this.next = new int[size];
        this.objs = new Object[size];
        Arrays.fill(this.spine, -1);
        this.threshold = (int)((float)spineLen * this.loadFactor);
    }

    public int putIfAbsent(Object obj) {
        int idx = this.hash(obj) % this.spine.length;
        if (this.size > 0) {
            int i = this.spine[idx];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
        }
        if (this.size >= this.next.length) {
            this.growEntries();
        }
        if (this.size >= this.threshold) {
            this.growSpine();
            idx = this.hash(obj) % this.spine.length;
        }
        this.insert(obj, this.size, idx);
        ++this.size;
        return -1;
    }

    public void clear() {
        if (this.size < this.objs.length && this.shrink()) {
            this.size = 0;
            return;
        }
        Arrays.fill(this.spine, -1);
        Arrays.fill(this.objs, 0, this.size, null);
        this.size = 0;
    }

    public Object[] objects() {
        return this.objs;
    }

    private void insert(Object obj, int handle, int idx) {
        this.objs[handle] = obj;
        this.next[handle] = this.spine[idx];
        this.spine[idx] = handle;
    }

    private void growSpine() {
        int size = (this.spine.length << 1) + 1;
        this.spine = new int[size];
        this.threshold = (int)((float)this.spine.length * this.loadFactor);
        Arrays.fill(this.spine, -1);
        for (int i = 0; i < this.size; ++i) {
            Object obj = this.objs[i];
            int idx = this.hash(obj) % this.spine.length;
            this.insert(this.objs[i], i, idx);
        }
    }

    private void growEntries() {
        int newLen = (this.next.length << 1) + 1;
        int[] newNext = new int[newLen];
        System.arraycopy(this.next, 0, newNext, 0, this.size);
        this.next = newNext;
        Object[] newObjs = new Object[newLen];
        System.arraycopy(this.objs, 0, newObjs, 0, this.size);
        this.objs = newObjs;
    }

    private boolean shrink() {
        int newSize = Math.max((this.objs.length - 1) / 2, this.initCap);
        if (newSize >= this.size && newSize < this.objs.length) {
            int prevSpine;
            int prevThreshold;
            int newSpine = this.spine.length;
            if (this.spine.length > this.initCap && newSize < (prevThreshold = (int)((float)(prevSpine = (this.spine.length - 1) / 2) * this.loadFactor))) {
                newSpine = prevSpine;
            }
            this.init(newSpine, newSize);
            return true;
        }
        return false;
    }

    private int hash(Object obj) {
        return System.identityHashCode(obj) & Integer.MAX_VALUE;
    }
}

