/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandInvoker;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.util.typedef.F;

public class CommandMBean<A extends IgniteDataTransferObject, R>
implements DynamicMBean {
    public static final String INVOKE = "invoke";
    public static final String LAST_RES_METHOD = "lastResult";
    private final IgniteEx ignite;
    private final IgniteLogger log;
    private final Command<A, ?> cmd;
    private R res;

    public CommandMBean(IgniteEx ignite, Command<A, R> cmd) {
        this.ignite = ignite;
        this.cmd = cmd;
        this.log = ignite.log().getLogger(CommandMBean.class.getName() + "#" + cmd.getClass().getSimpleName());
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("getAttribute");
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("setAttribute");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (params.length == 3 && (params[0].equals(INVOKE) || params[0].equals(LAST_RES_METHOD)) && params[1] instanceof Object[]) {
            return this.invoke((String)params[0], (Object[])params[1], (String[])params[2]);
        }
        if (LAST_RES_METHOD.equals(actionName)) {
            return this.res;
        }
        if (!INVOKE.equals(actionName)) {
            throw new UnsupportedOperationException(actionName);
        }
        try {
            StringBuilder resStr = new StringBuilder();
            Consumer<String> printer = str -> resStr.append((String)str).append('\n');
            CommandInvoker<A> invoker = new CommandInvoker<A>(this.cmd, new ParamsToArgument(params).argument(), this.ignite);
            if (invoker.prepare(printer)) {
                this.res = invoker.invoke(printer, false);
            }
            return resStr.toString();
        }
        catch (Exception e) {
            this.log.error("Invoke error:", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList args = new ArrayList();
        BiConsumer<ArgumentGroup, Field> fldCnsmr = (argGrp, fld) -> {
            Object descStr = "";
            if (argGrp != null && argGrp.optional() || fld.getAnnotation(Argument.class).optional()) {
                descStr = (String)descStr + "Optional. ";
            }
            if (!fld.isAnnotationPresent(EnumDescription.class)) {
                descStr = (String)descStr + fld.getAnnotation(Argument.class).description();
            } else {
                EnumDescription enumDesc = fld.getAnnotation(EnumDescription.class);
                String[] names = enumDesc.names();
                String[] descriptions = enumDesc.descriptions();
                StringBuilder bldr = new StringBuilder();
                for (int i = 0; i < names.length; ++i) {
                    if (i != 0) {
                        bldr.append('\n');
                    }
                    bldr.append(names[i]).append(" - ").append(descriptions[i]);
                }
                descStr = (String)descStr + bldr.toString();
            }
            args.add(new MBeanParameterInfo(fld.getName(), String.class.getName(), (String)descStr));
        };
        CommandUtils.visitCommandParams(this.cmd.argClass(), fld -> fldCnsmr.accept((ArgumentGroup)null, (Field)fld), fld -> fldCnsmr.accept((ArgumentGroup)null, (Field)fld), (grp, flds) -> flds.forEach(fld -> fldCnsmr.accept((ArgumentGroup)grp, (Field)fld)));
        return new MBeanInfo(CommandMBean.class.getName(), this.cmd.getClass().getSimpleName(), null, null, new MBeanOperationInfo[]{new MBeanOperationInfo(INVOKE, this.cmd.description(), args.toArray(new MBeanParameterInfo[0]), String.class.getName(), 1)}, null);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException("getAttributes");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setAttributes");
    }

    private class ParamsToArgument
    implements Function<Field, Object> {
        private int cntr;
        private final Object[] vals;

        private ParamsToArgument(Object[] vals) {
            this.vals = vals;
        }

        public A argument() {
            return CommandUtils.argument(CommandMBean.this.cmd.argClass(), (fld, pos) -> this.apply((Field)fld), this);
        }

        @Override
        public Object apply(Field field) {
            String val = (String)this.vals[this.cntr];
            ++this.cntr;
            return !F.isEmpty(val) ? CommandUtils.parseVal(val, field.getType()) : null;
        }
    }
}

