/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableDropColumnCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.DropColumnsEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CollectionUtils;

public class AlterTableDropColumnCommand
extends AbstractTableCommand {
    private final Set<String> columns;

    public static AlterTableDropColumnCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableDropColumnCommand(String tableName, String schemaName, boolean ifTableExists, Set<String> columns) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists);
        AlterTableDropColumnCommand.validate(columns);
        this.columns = CollectionUtils.copyOrNull(columns);
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(schema, this.tableName);
        Set indexedColumns = AlterTableDropColumnCommand.aliveIndexesForTable(catalog, table.id()).flatMap(AlterTableDropColumnCommand::indexColumnNames).collect(Collectors.toSet());
        this.columns.stream().sorted().forEach(columnName -> {
            if (table.column((String)columnName) == null) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column with name '{}' not found in table '{}.{}'", (Object[])new Object[]{columnName, this.schemaName, this.tableName}));
            }
            if (table.isPrimaryKeyColumn((String)columnName)) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Deleting column `{}` belonging to primary key is not allowed", (Object[])new Object[]{columnName}));
            }
            if (indexedColumns.contains(columnName)) {
                List indexesNames = AlterTableDropColumnCommand.aliveIndexesForTable(catalog, table.id()).filter(index -> AlterTableDropColumnCommand.indexColumnNames(index).anyMatch(columnName::equals)).map(CatalogObjectDescriptor::name).collect(Collectors.toList());
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Deleting column '{}' used by index(es) {}, it is not allowed", (Object[])new Object[]{columnName, indexesNames}));
            }
        });
        return List.of(new DropColumnsEntry(table.id(), this.columns));
    }

    private static Stream<CatalogIndexDescriptor> aliveIndexesForTable(Catalog catalog, int tableId) {
        return catalog.indexes(tableId).stream().filter(index -> index.status().isAlive());
    }

    private static Stream<String> indexColumnNames(CatalogIndexDescriptor index) {
        switch (index.indexType()) {
            case HASH: {
                return ((CatalogHashIndexDescriptor)index).columns().stream();
            }
            case SORTED: {
                return ((CatalogSortedIndexDescriptor)index).columns().stream().map(CatalogIndexColumnDescriptor::name);
            }
        }
        throw new AssertionError((Object)index.indexType().toString());
    }

    private static void validate(Set<String> columns) {
        if (CollectionUtils.nullOrEmpty(columns)) {
            throw new CatalogValidationException("Columns not specified");
        }
        for (String name : columns) {
            CatalogParamsValidationUtils.validateIdentifier(name, "Name of the column");
        }
    }

    private static class Builder
    implements AlterTableDropColumnCommandBuilder {
        private Set<String> columns;
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableDropColumnCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableDropColumnCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableDropColumnCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public AlterTableDropColumnCommandBuilder columns(Set<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableDropColumnCommand(this.tableName, this.schemaName, this.ifTableExists, this.columns);
        }
    }
}

