/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityCentralizedFunction;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentV2;
import org.apache.ignite.internal.processors.affinity.GridAffinityFunctionContextImpl;
import org.apache.ignite.internal.processors.affinity.HistoryAffinityAssignment;
import org.apache.ignite.internal.processors.affinity.HistoryAffinityAssignmentImpl;
import org.apache.ignite.internal.processors.affinity.HistoryAffinityAssignmentShallowCopy;
import org.apache.ignite.internal.processors.affinity.IdealAffinityAssignment;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridAffinityAssignmentCache {
    public static final int DFLT_AFFINITY_HISTORY_SIZE = 25;
    public static final float DFLT_PART_DISTRIBUTION_WARN_THRESHOLD = 50.0f;
    final int maxNonShallowHistSize = IgniteSystemProperties.getInteger("IGNITE_AFFINITY_HISTORY_SIZE", 25);
    final int maxTotalHistSize = this.maxNonShallowHistSize * 10;
    private static final int MIN_NON_SHALLOW_HIST_SIZE = 2;
    private final float partDistribution = IgniteSystemProperties.getFloat("IGNITE_PART_DISTRIBUTION_WARN_THRESHOLD", 50.0f);
    private final String cacheOrGrpName;
    private final int grpId;
    private final int backups;
    private final AffinityFunction aff;
    private final IgnitePredicate<ClusterNode> nodeFilter;
    private final int partsCnt;
    private final ConcurrentNavigableMap<AffinityTopologyVersion, HistoryAffinityAssignment> affCache;
    private volatile IdealAffinityAssignment idealAssignment;
    private volatile IdealAffinityAssignment baselineAssignment;
    private BaselineTopology baselineTopology;
    private final AtomicReference<GridAffinityAssignmentV2> head;
    private final ConcurrentMap<AffinityTopologyVersion, AffinityReadyFuture> readyFuts = new ConcurrentSkipListMap<AffinityTopologyVersion, AffinityReadyFuture>();
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private volatile IgniteCheckedException stopErr;
    private volatile int nonShallowHistSize;
    private final Object similarAffKey;

    private GridAffinityAssignmentCache(GridKernalContext ctx, String cacheOrGrpName, int grpId, AffinityFunction aff, IgnitePredicate<ClusterNode> nodeFilter, int backups) {
        assert (ctx != null);
        assert (aff != null);
        assert (nodeFilter != null);
        assert (grpId != 0);
        this.ctx = ctx;
        this.aff = aff;
        this.nodeFilter = nodeFilter;
        this.cacheOrGrpName = cacheOrGrpName;
        this.grpId = grpId;
        this.backups = backups;
        this.log = ctx.log(GridAffinityAssignmentCache.class);
        this.partsCnt = aff.partitions();
        this.affCache = new ConcurrentSkipListMap<AffinityTopologyVersion, HistoryAffinityAssignment>();
        this.head = new AtomicReference<GridAffinityAssignmentV2>(new GridAffinityAssignmentV2(AffinityTopologyVersion.NONE));
        this.similarAffKey = ctx.affinity().similaryAffinityKey(aff, nodeFilter, backups, this.partsCnt);
        assert (this.similarAffKey != null);
    }

    public static GridAffinityAssignmentCache create(GridKernalContext ctx, AffinityFunction aff, CacheConfiguration<?, ?> ccfg) {
        return new GridAffinityAssignmentCache(ctx, CU.cacheOrGroupName(ccfg), CU.cacheGroupId(ccfg), aff, ccfg.getNodeFilter(), ccfg.getBackups());
    }

    public Object similarAffinityKey() {
        return this.similarAffKey;
    }

    public String cacheOrGroupName() {
        return this.cacheOrGrpName;
    }

    public int groupId() {
        return this.grpId;
    }

    public void initialize(AffinityTopologyVersion topVer, List<List<ClusterNode>> affAssignment) {
        assert (topVer.compareTo(this.lastVersion()) >= 0) : "[topVer = " + topVer + ", last=" + this.lastVersion() + "]";
        assert (this.idealAssignment != null);
        GridAffinityAssignmentV2 assignment = new GridAffinityAssignmentV2(topVer, affAssignment, this.idealAssignment.assignment());
        HistoryAffinityAssignmentImpl newHistEntry = new HistoryAffinityAssignmentImpl(assignment, this.backups);
        HistoryAffinityAssignment existing = this.affCache.put(topVer, newHistEntry);
        this.head.set(assignment);
        for (Map.Entry entry : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry.getKey()).compareTo(topVer) > 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future (initialized affinity) [locNodeId=" + this.ctx.localNodeId() + ", futVer=" + entry.getKey() + ", topVer=" + topVer + "]");
            }
            ((AffinityReadyFuture)entry.getValue()).onDone(topVer);
        }
        this.onHistoryAdded(existing, newHistEntry);
        if (this.log.isTraceEnabled()) {
            this.log.trace("New affinity assignment [grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", aff=" + GridAffinityAssignmentCache.fold(affAssignment) + "]");
        }
    }

    public void idealAssignment(AffinityTopologyVersion topVer, List<List<ClusterNode>> assignment) {
        this.idealAssignment = IdealAffinityAssignment.create(topVer, assignment);
    }

    @Nullable
    public List<List<ClusterNode>> idealAssignmentRaw() {
        return this.idealAssignment != null ? this.idealAssignment.assignment() : null;
    }

    @Nullable
    public IdealAffinityAssignment idealAssignment() {
        return this.idealAssignment;
    }

    public boolean centralizedAffinityFunction() {
        return U.hasAnnotation(this.aff, AffinityCentralizedFunction.class);
    }

    public void cancelFutures(IgniteCheckedException err) {
        this.stopErr = err;
        for (AffinityReadyFuture fut : this.readyFuts.values()) {
            fut.onDone(err);
        }
    }

    public void onReconnected() {
        this.idealAssignment = null;
        this.affCache.clear();
        this.nonShallowHistSize = 0;
        this.head.set(new GridAffinityAssignmentV2(AffinityTopologyVersion.NONE));
        this.stopErr = null;
    }

    public IdealAffinityAssignment calculate(AffinityTopologyVersion topVer, @Nullable ExchangeDiscoveryEvents events, @Nullable DiscoCache discoCache) {
        IdealAffinityAssignment assignment;
        IdealAffinityAssignment prevAssignment;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Calculating ideal affinity [topVer=" + topVer + ", locNodeId=" + this.ctx.localNodeId() + ", discoEvts=" + events + "]");
        }
        if ((prevAssignment = this.idealAssignment) != null && prevAssignment.topologyVersion().equals(topVer)) {
            return prevAssignment;
        }
        ArrayList<ClusterNode> sorted = new ArrayList<ClusterNode>(discoCache.cacheGroupAffinityNodes(this.groupId()));
        sorted.sort(NodeOrderComparator.getInstance());
        boolean hasBaseline = false;
        boolean changedBaseline = false;
        BaselineTopology blt = null;
        if (discoCache != null) {
            blt = discoCache.state().baselineTopology();
            boolean bl = hasBaseline = blt != null;
            boolean bl2 = !hasBaseline ? this.baselineTopology != null : (changedBaseline = !blt.equals(this.baselineTopology));
        }
        if (prevAssignment != null && events != null) {
            boolean skipCalculation = true;
            for (DiscoveryEvent evt : events.events()) {
                boolean affNode = CU.affinityNode(evt.eventNode(), this.nodeFilter);
                if (!affNode && evt.type() != 18) continue;
                skipCalculation = false;
                break;
            }
            if (hasBaseline && changedBaseline) {
                this.recalculateBaselineAssignment(topVer, events, prevAssignment, sorted, blt);
                assignment = IdealAffinityAssignment.create(topVer, sorted, this.baselineAssignmentWithoutOfflineNodes(discoCache));
            } else if (skipCalculation) {
                assignment = prevAssignment;
            } else if (hasBaseline) {
                if (this.baselineAssignment == null) {
                    this.recalculateBaselineAssignment(topVer, events, prevAssignment, sorted, blt);
                }
                assignment = IdealAffinityAssignment.create(topVer, sorted, this.baselineAssignmentWithoutOfflineNodes(discoCache));
            } else {
                List<List<ClusterNode>> calculated = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(sorted, prevAssignment.assignment(), events.lastEvent(), topVer, this.backups));
                assignment = IdealAffinityAssignment.create(topVer, sorted, calculated);
            }
        } else if (hasBaseline) {
            this.recalculateBaselineAssignment(topVer, events, prevAssignment, sorted, blt);
            assignment = IdealAffinityAssignment.createWithPreservedPrimaries(topVer, this.baselineAssignmentWithoutOfflineNodes(discoCache), this.baselineAssignment);
        } else {
            List<List<ClusterNode>> calculated = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(sorted, prevAssignment != null ? prevAssignment.assignment() : null, events != null ? events.lastEvent() : null, topVer, this.backups));
            assignment = IdealAffinityAssignment.create(topVer, sorted, calculated);
        }
        assert (assignment != null);
        this.idealAssignment = assignment;
        if (this.ctx.cache().cacheMode(this.cacheOrGrpName) == CacheMode.PARTITIONED && !this.ctx.clientNode()) {
            this.printDistributionIfThresholdExceeded(assignment.assignment(), sorted.size());
        }
        if (hasBaseline) {
            this.baselineTopology = blt;
            assert (this.baselineAssignment != null);
        } else {
            this.baselineTopology = null;
            this.baselineAssignment = null;
        }
        return assignment;
    }

    private void recalculateBaselineAssignment(AffinityTopologyVersion topVer, ExchangeDiscoveryEvents events, IdealAffinityAssignment prevAssignment, List<ClusterNode> sorted, BaselineTopology blt) {
        List<ClusterNode> baselineAffNodes = blt.createBaselineView(sorted, this.nodeFilter);
        List<List<ClusterNode>> calculated = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(baselineAffNodes, prevAssignment != null ? prevAssignment.assignment() : null, events != null ? events.lastEvent() : null, topVer, this.backups));
        this.baselineAssignment = IdealAffinityAssignment.create(topVer, baselineAffNodes, calculated);
    }

    private List<List<ClusterNode>> baselineAssignmentWithoutOfflineNodes(DiscoCache disco) {
        HashMap<Object, ClusterNode> alives = new HashMap<Object, ClusterNode>();
        for (ClusterNode node : disco.serverNodes()) {
            alives.put(node.consistentId(), node);
        }
        List<List<ClusterNode>> assignment = this.baselineAssignment.assignment();
        ArrayList<List<ClusterNode>> result = new ArrayList<List<ClusterNode>>(assignment.size());
        for (int p = 0; p < assignment.size(); ++p) {
            List<ClusterNode> baselineMapping = assignment.get(p);
            List curMapping = null;
            for (ClusterNode node : baselineMapping) {
                ClusterNode aliveNode = (ClusterNode)alives.get(node.consistentId());
                if (aliveNode == null) continue;
                if (curMapping == null) {
                    curMapping = new ArrayList();
                }
                curMapping.add(aliveNode);
            }
            result.add(p, curMapping != null ? curMapping : Collections.emptyList());
        }
        return result;
    }

    private void printDistributionIfThresholdExceeded(List<List<ClusterNode>> assignments, int nodes) {
        int locPrimaryCnt = 0;
        int locBackupCnt = 0;
        for (List<ClusterNode> assignment : assignments) {
            for (int i = 0; i < assignment.size(); ++i) {
                ClusterNode node = assignment.get(i);
                if (!node.isLocal()) continue;
                if (i == 0) {
                    ++locPrimaryCnt;
                    continue;
                }
                ++locBackupCnt;
            }
        }
        float expCnt = (float)this.partsCnt / (float)nodes;
        float deltaPrimary = Math.abs(1.0f - (float)locPrimaryCnt / expCnt) * 100.0f;
        float deltaBackup = Math.abs(1.0f - (float)locBackupCnt / (expCnt * (float)this.backups)) * 100.0f;
        if ((deltaPrimary > this.partDistribution || deltaBackup > this.partDistribution) && this.log.isInfoEnabled()) {
            this.log.info(String.format("Local node affinity assignment distribution is not ideal [cache=%s, expectedPrimary=%.2f, actualPrimary=%d, expectedBackups=%.2f, actualBackups=%d, warningThreshold=%.2f%%]", this.cacheOrGrpName, Float.valueOf(expCnt), locPrimaryCnt, Float.valueOf(expCnt * (float)this.backups), locBackupCnt, Float.valueOf(this.partDistribution)));
        }
    }

    public void clientEventTopologyChange(DiscoveryEvent evt, AffinityTopologyVersion topVer) {
        assert (topVer.compareTo(this.lastVersion()) >= 0) : "[topVer = " + topVer + ", last=" + this.lastVersion() + "]";
        GridAffinityAssignmentV2 aff = this.head.get();
        assert (evt.type() == 18 || aff.primaryPartitions(evt.eventNode().id()).isEmpty()) : evt;
        assert (evt.type() == 18 || aff.backupPartitions(evt.eventNode().id()).isEmpty()) : evt;
        GridAffinityAssignmentV2 assignmentCpy = new GridAffinityAssignmentV2(topVer, aff);
        AffinityTopologyVersion prevVer = topVer.minorTopologyVersion() == 0 ? new AffinityTopologyVersion(topVer.topologyVersion() - 1L, Integer.MAX_VALUE) : new AffinityTopologyVersion(topVer.topologyVersion(), topVer.minorTopologyVersion() - 1);
        Map.Entry prevHistEntry = this.affCache.floorEntry(prevVer);
        HistoryAffinityAssignment newHistEntry = prevHistEntry == null ? new HistoryAffinityAssignmentImpl(assignmentCpy, this.backups) : new HistoryAffinityAssignmentShallowCopy(((HistoryAffinityAssignment)prevHistEntry.getValue()).origin(), topVer);
        HistoryAffinityAssignment existing = this.affCache.put(topVer, newHistEntry);
        this.head.set(assignmentCpy);
        for (Map.Entry entry : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry.getKey()).compareTo(topVer) > 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future (use previous affinity) [locNodeId=" + this.ctx.localNodeId() + ", futVer=" + entry.getKey() + ", topVer=" + topVer + "]");
            }
            ((AffinityReadyFuture)entry.getValue()).onDone(topVer);
        }
        this.onHistoryAdded(existing, newHistEntry);
    }

    public AffinityTopologyVersion lastVersion() {
        return this.head.get().topologyVersion();
    }

    public AffinityAssignment lastReadyAffinity() {
        return this.head.get();
    }

    public List<List<ClusterNode>> assignments(AffinityTopologyVersion topVer) {
        AffinityAssignment aff = this.cachedAffinity(topVer);
        return aff.assignment();
    }

    public List<List<ClusterNode>> readyAssignments(AffinityTopologyVersion topVer) {
        AffinityAssignment aff = this.readyAffinity(topVer);
        assert (aff != null) : "No ready affinity [grp=" + this.cacheOrGrpName + ", ver=" + topVer + "]";
        return aff.assignment();
    }

    @Nullable
    public IgniteInternalFuture<AffinityTopologyVersion> readyFuture(AffinityTopologyVersion topVer) {
        GridAffinityAssignmentV2 aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Returning finished future for readyFuture [head=" + aff.topologyVersion() + ", topVer=" + topVer + "]");
            }
            return null;
        }
        GridFutureAdapter fut = F.addIfAbsent(this.readyFuts, topVer, new AffinityReadyFuture(topVer));
        aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future right away [head=" + aff.topologyVersion() + ", topVer=" + topVer + "]");
            }
            fut.onDone(aff.topologyVersion());
        } else if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    public int partitions() {
        return this.partsCnt;
    }

    public List<ClusterNode> nodes(int part, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).get(part);
    }

    public Set<Integer> partitionPrimariesDifferentToIdeal(AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).partitionPrimariesDifferentToIdeal();
    }

    public Set<Integer> primaryPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).primaryPartitions(nodeId);
    }

    public Set<Integer> backupPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).backupPartitions(nodeId);
    }

    public boolean dumpDebugInfo() {
        if (!this.readyFuts.isEmpty()) {
            U.warn(this.log, "First 3 pending affinity ready futures [grp=" + this.cacheOrGrpName + ", total=" + this.readyFuts.size() + ", lastVer=" + this.lastVersion() + "]:");
            int cnt = 0;
            for (AffinityReadyFuture fut : this.readyFuts.values()) {
                U.warn(this.log, ">>> " + fut);
                if (++cnt != 3) continue;
                break;
            }
            return true;
        }
        return false;
    }

    public AffinityAssignment readyAffinity(AffinityTopologyVersion topVer) {
        AffinityAssignment cache = this.head.get();
        if (!cache.topologyVersion().equals(topVer) && (cache = (AffinityAssignment)this.affCache.get(topVer)) == null) {
            throw new IllegalStateException("Affinity for topology version is not initialized [locNode=" + this.ctx.discovery().localNode().id() + ", grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", head=" + this.head.get().topologyVersion() + ", history=" + (NavigableSet)this.affCache.keySet() + ", maxNonShallowHistorySize=" + this.maxNonShallowHistSize + "]");
        }
        return cache;
    }

    public AffinityAssignment cachedAffinity(AffinityTopologyVersion topVer) {
        AffinityTopologyVersion lastAffChangeTopVer = this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(topVer);
        return this.cachedAffinity(topVer, lastAffChangeTopVer);
    }

    public AffinityAssignment cachedAffinity(AffinityTopologyVersion topVer, AffinityTopologyVersion lastAffChangeTopVer) {
        if (topVer.equals(AffinityTopologyVersion.NONE)) {
            topVer = lastAffChangeTopVer = this.lastVersion();
        } else {
            if (lastAffChangeTopVer.equals(AffinityTopologyVersion.NONE)) {
                lastAffChangeTopVer = topVer;
            }
            this.awaitTopologyVersion(lastAffChangeTopVer);
        }
        assert (topVer.topologyVersion() >= 0L) : topVer;
        AffinityAssignment cache = this.head.get();
        if (cache.topologyVersion().compareTo(lastAffChangeTopVer) < 0 || cache.topologyVersion().compareTo(topVer) > 0) {
            Map.Entry e = this.affCache.ceilingEntry(lastAffChangeTopVer);
            if (e != null) {
                cache = (AffinityAssignment)e.getValue();
            }
            if (cache == null) {
                throw new IllegalStateException("Getting affinity for topology version earlier than affinity is calculated [locNode=" + this.ctx.discovery().localNode() + ", grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", lastAffChangeTopVer=" + lastAffChangeTopVer + ", head=" + this.head.get().topologyVersion() + ", history=" + (NavigableSet)this.affCache.keySet() + ", maxNonShallowHistorySize=" + this.maxNonShallowHistSize + "]");
            }
            if (cache.topologyVersion().compareTo(topVer) > 0) {
                throw new IllegalStateException("Getting affinity for too old topology version that is already out of history (try to increase 'IGNITE_AFFINITY_HISTORY_SIZE' system property) [locNode=" + this.ctx.discovery().localNode() + ", grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", lastAffChangeTopVer=" + lastAffChangeTopVer + ", head=" + this.head.get().topologyVersion() + ", history=" + (NavigableSet)this.affCache.keySet() + ", maxNonShallowHistorySize=" + this.maxNonShallowHistSize + "]");
            }
        }
        assert (cache.topologyVersion().compareTo(lastAffChangeTopVer) >= 0 && cache.topologyVersion().compareTo(topVer) <= 0) : "Invalid cached affinity: [cache=" + cache + ", topVer=" + topVer + ", lastAffChangedTopVer=" + lastAffChangeTopVer + "]";
        return cache;
    }

    public boolean primaryChanged(int part, AffinityTopologyVersion startVer, AffinityTopologyVersion endVer) {
        AffinityAssignment aff = (AffinityAssignment)this.affCache.get(startVer);
        if (aff == null) {
            return false;
        }
        List<ClusterNode> nodes = aff.get(part);
        if (nodes.isEmpty()) {
            return true;
        }
        ClusterNode primary = nodes.get(0);
        for (AffinityAssignment assignment : this.affCache.tailMap((Object)startVer, false).values()) {
            List<ClusterNode> nodes0 = assignment.assignment().get(part);
            if (nodes0.isEmpty()) {
                return true;
            }
            if (!nodes0.get(0).equals(primary)) {
                return true;
            }
            if (!assignment.topologyVersion().equals(endVer)) continue;
            return false;
        }
        return true;
    }

    public void init(GridAffinityAssignmentCache aff) {
        assert (aff.lastVersion().compareTo(this.lastVersion()) >= 0);
        assert (aff.idealAssignmentRaw() != null);
        this.idealAssignment(aff.lastVersion(), aff.idealAssignmentRaw());
        AffinityAssignment assign = aff.cachedAffinity(aff.lastVersion());
        this.initialize(aff.lastVersion(), assign.assignment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitTopologyVersion(AffinityTopologyVersion topVer) {
        block7: {
            GridAffinityAssignmentV2 aff = this.head.get();
            if (aff.topologyVersion().compareTo(topVer) >= 0) {
                return;
            }
            try {
                IgniteInternalFuture<AffinityTopologyVersion> fut;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Will wait for topology version [locNodeId=" + this.ctx.localNodeId() + ", topVer=" + topVer + "]");
                }
                if ((fut = this.readyFuture(topVer)) == null) break block7;
                Thread curTh = Thread.currentThread();
                String threadName = curTh.getName();
                try {
                    curTh.setName(threadName + " (waiting " + topVer + ")");
                    fut.get();
                }
                finally {
                    curTh.setName(threadName);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to wait for affinity ready future for topology version: " + topVer, e);
            }
        }
    }

    private synchronized void onHistoryAdded(HistoryAffinityAssignment replaced, HistoryAffinityAssignment added) {
        int totalSize;
        if (replaced == null) {
            if (added.isFullSizeInstance()) {
                ++this.nonShallowHistSize;
            }
        } else if (replaced.isFullSizeInstance() != added.isFullSizeInstance()) {
            this.nonShallowHistSize += added.isFullSizeInstance() ? 1 : -1;
        }
        if (!this.shouldContinueCleanup(this.nonShallowHistSize, totalSize = this.affCache.size())) {
            return;
        }
        AffinityTopologyVersion lastAffChangeTopVer = this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(this.head.get().topologyVersion());
        AffinityAssignment aff0 = null;
        Iterator it = this.affCache.values().iterator();
        while (it.hasNext() && this.shouldContinueCleanup(this.nonShallowHistSize, totalSize)) {
            aff0 = (HistoryAffinityAssignment)it.next();
            if (aff0.topologyVersion().equals(lastAffChangeTopVer)) continue;
            if (aff0.isFullSizeInstance()) {
                if (this.nonShallowHistSize <= 2) continue;
                --this.nonShallowHistSize;
            }
            --totalSize;
            it.remove();
        }
        assert (aff0 != null);
        this.ctx.affinity().removeCachedAffinity(aff0.topologyVersion());
        assert (it.hasNext()) : "All elements have been removed from affinity cache during cleanup";
    }

    private boolean shouldContinueCleanup(int nonShallowSize, int totalSize) {
        return nonShallowSize > this.maxNonShallowHistSize || totalSize > this.maxTotalHistSize;
    }

    public NavigableSet<AffinityTopologyVersion> cachedVersions() {
        return this.affCache.keySet();
    }

    private static String fold(List<List<ClusterNode>> affAssignment) {
        SB sb = new SB();
        for (int p = 0; p < affAssignment.size(); ++p) {
            sb.a("Part [");
            sb.a("id=" + p + ", ");
            SB partOwners = new SB();
            List<ClusterNode> affOwners = affAssignment.get(p);
            for (ClusterNode node : affOwners) {
                partOwners.a(node.consistentId());
                partOwners.a(' ');
            }
            sb.a("owners=[");
            sb.a(partOwners);
            sb.a(']');
            sb.a("] ");
        }
        return sb.toString();
    }

    private class AffinityReadyFuture
    extends GridFutureAdapter<AffinityTopologyVersion> {
        private AffinityTopologyVersion reqTopVer;

        private AffinityReadyFuture(AffinityTopologyVersion reqTopVer) {
            this.reqTopVer = reqTopVer;
        }

        @Override
        public boolean onDone(AffinityTopologyVersion res, @Nullable Throwable err) {
            assert (res != null || err != null);
            boolean done = super.onDone(res, err);
            if (done) {
                GridAffinityAssignmentCache.this.readyFuts.remove(this.reqTopVer, this);
            }
            return done;
        }

        @Override
        public String toString() {
            return S.toString(AffinityReadyFuture.class, this);
        }
    }
}

