/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.io.IOException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcBinaryTypeGetResult
extends JdbcResult {
    private long reqId;
    private BinaryMetadata meta;

    JdbcBinaryTypeGetResult() {
        super((byte)21);
    }

    public JdbcBinaryTypeGetResult(long reqId, BinaryMetadata meta) {
        super((byte)21);
        this.reqId = reqId;
        this.meta = meta;
    }

    public BinaryMetadata meta() {
        return this.meta;
    }

    public long reqId() {
        return this.reqId;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeLong(this.reqId);
        try {
            this.meta.writeTo(writer);
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.reqId = reader.readLong();
        this.meta = new BinaryMetadata();
        try {
            this.meta.readFrom(reader);
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcBinaryTypeGetResult.class, this);
    }
}

