/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformContinuousQueryFilter;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformContinuousQueryRemoteFilter
implements PlatformContinuousQueryFilter,
Externalizable {
    private static final long serialVersionUID = 0L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Object filter;
    @IgniteInstanceResource
    private transient Ignite grid;
    private volatile transient long ptr;
    private transient boolean closed;

    public PlatformContinuousQueryRemoteFilter() {
    }

    public PlatformContinuousQueryRemoteFilter(Object filter) {
        assert (filter != null);
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(CacheEntryEvent evt) throws CacheEntryListenerException {
        long ptr0 = this.ptr;
        if (ptr0 == 0L) {
            this.deploy();
        }
        this.lock.readLock().lock();
        try {
            if (this.closed) {
                throw new CacheEntryListenerException("Failed to evaluate the filter because it has been closed.");
            }
            PlatformContext platformCtx = PlatformUtils.platformContext(this.grid);
            boolean bl = PlatformUtils.evaluateContinuousQueryEvent(platformCtx, this.ptr, evt);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy() {
        this.lock.writeLock().lock();
        try {
            if (this.closed) {
                throw new CacheEntryListenerException("Failed to deploy the filter because it has been closed.");
            }
            PlatformContext ctx = PlatformUtils.platformContext(this.grid);
            try (PlatformMemory mem = ctx.memory().allocate();){
                PlatformOutputStream out = mem.output();
                BinaryRawWriterEx writer = ctx.writer(out);
                writer.writeObject(this.filter);
                out.synchronize();
                this.ptr = ctx.gateway().continuousQueryFilterCreate(mem.pointer());
            }
            catch (Exception e) {
                this.close();
                throw new CacheEntryListenerException("Failed to deploy the filter.", (Throwable)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void onQueryUnregister() {
        this.lock.writeLock().lock();
        try {
            this.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void close() {
        block7: {
            if (!this.closed) {
                try {
                    if (this.ptr == 0L) break block7;
                    try {
                        PlatformUtils.platformContext(this.grid).gateway().continuousQueryFilterRelease(this.ptr);
                    }
                    finally {
                        this.ptr = 0L;
                    }
                }
                finally {
                    this.closed = true;
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.filter);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.filter = in.readObject();
        assert (this.filter != null);
    }

    public String toString() {
        return S.toString(PlatformContinuousQueryRemoteFilter.class, this);
    }
}

