/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import java.util.Objects;
import org.apache.ignite3.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite3.internal.catalog.sql.Name;
import org.apache.ignite3.internal.catalog.sql.QueryContext;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.table.QualifiedName;

class DropTableImpl
extends AbstractCatalogQuery<Name> {
    private Name tableName;
    private boolean ifExists;

    DropTableImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.tableName;
    }

    DropTableImpl name(QualifiedName name) {
        Objects.requireNonNull(name, "Table name must not be null");
        this.tableName = Name.qualified(name);
        return this;
    }

    DropTableImpl ifExists() {
        this.ifExists = true;
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("DROP TABLE ");
        if (this.ifExists) {
            ctx.sql("IF EXISTS ");
        }
        ctx.visit(this.tableName);
        ctx.sql(";");
    }
}

