/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.InternalSqlRowSingleLong;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite3.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite3.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.PlanId;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.ExplainUtils;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.Cloner;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IteratorToDataCursorAdapter;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class KeyValueModifyPlan
implements ExplainablePlan,
ExecutablePlan {
    private final PlanId id;
    private final int catalogVersion;
    private final IgniteKeyValueModify modifyNode;
    private final ResultSetMetadata meta;
    private final ParameterMetadata parameterMetadata;
    @Nullable
    private final PartitionAwarenessMetadata partitionAwarenessMetadata;
    @Nullable
    private final PartitionPruningMetadata partitionPruningMetadata;
    private volatile Performable<?> operation;

    KeyValueModifyPlan(PlanId id, int catalogVersion, IgniteKeyValueModify modifyNode, ResultSetMetadata meta, ParameterMetadata parameterMetadata, @Nullable PartitionAwarenessMetadata partitionAwarenessMetadata, @Nullable PartitionPruningMetadata partitionPruningMetadata) {
        this.id = id;
        this.catalogVersion = catalogVersion;
        this.modifyNode = modifyNode;
        this.meta = meta;
        this.parameterMetadata = parameterMetadata;
        this.partitionAwarenessMetadata = partitionAwarenessMetadata;
        this.partitionPruningMetadata = partitionPruningMetadata;
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public SqlQueryType type() {
        return SqlQueryType.DML;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.partitionAwarenessMetadata;
    }

    @Override
    @Nullable
    public PartitionPruningMetadata partitionPruningMetadata() {
        return this.partitionPruningMetadata;
    }

    @Override
    public int numSources() {
        return 1;
    }

    private IgniteTable table() {
        IgniteTable table = (IgniteTable)this.modifyNode.getTable().unwrap(IgniteTable.class);
        assert (table != null) : this.modifyNode.getTable();
        return table;
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.modifyNode, Commons.cluster());
        return ExplainUtils.toString(clonedRoot);
    }

    private <RowT> Performable<RowT> operation(ExecutionContext<RowT> ctx, ExecutableTableRegistry tableRegistry) {
        Performable operation = (InsertExecution<RowT>)Commons.cast(this.operation);
        if (operation != null) {
            return operation;
        }
        IgniteTable sqlTable = this.table();
        ExecutableTable execTable = tableRegistry.getTable(this.catalogVersion, sqlTable.id());
        List<RexNode> expressions = this.modifyNode.expressions();
        SqlRowProvider<RowT> rowSupplier = ctx.expressionFactory().rowSource(expressions);
        UpdatableTable table = execTable.updatableTable();
        switch (this.modifyNode.operation()) {
            case INSERT: {
                operation = new InsertExecution<RowT>(table, rowSupplier);
                break;
            }
            case DELETE: {
                operation = new DeleteExecution<RowT>(table, rowSupplier);
                break;
            }
            default: {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unsupported operation " + this.modifyNode.operation());
            }
        }
        this.operation = operation;
        return operation;
    }

    @Override
    public <RowT> AsyncDataCursor<InternalSqlRow> execute(ExecutionContext<RowT> ctx, InternalTransaction tx, ExecutableTableRegistry tableRegistry) {
        Performable<RowT> operation = this.operation(ctx, tableRegistry);
        CompletableFuture result = operation.perform(ctx, tx);
        return new IteratorToDataCursorAdapter<InternalSqlRow>(result, Runnable::run);
    }

    @Override
    public IgniteKeyValueModify getRel() {
        return this.modifyNode;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    private static abstract class Performable<RowT> {
        private Performable() {
        }

        abstract CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> var1, @Nullable InternalTransaction var2);
    }

    private static class InsertExecution<RowT>
    extends Performable<RowT> {
        private final UpdatableTable table;
        private final SqlRowProvider<RowT> rowSupplier;

        private InsertExecution(UpdatableTable table, SqlRowProvider<RowT> rowSupplier) {
            this.table = table;
            this.rowSupplier = rowSupplier;
        }

        @Override
        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            return this.table.insert(tx, ctx, this.rowSupplier.get(ctx)).thenApply(none -> List.of(new InternalSqlRowSingleLong(1L)).iterator());
        }
    }

    private static class DeleteExecution<RowT>
    extends Performable<RowT> {
        private final UpdatableTable table;
        private final SqlRowProvider<RowT> rowSupplier;

        private DeleteExecution(UpdatableTable table, SqlRowProvider<RowT> rowSupplier) {
            this.table = table;
            this.rowSupplier = rowSupplier;
        }

        @Override
        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            return this.table.delete(tx, ctx, this.rowSupplier.get(ctx)).thenApply(deleted -> List.of(new InternalSqlRowSingleLong(deleted != false ? 1L : 0L)).iterator());
        }
    }
}

