/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.PutItemOutcome;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.document.internal.IteratorSupport;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.AWSServiceThrottledException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.RolePolicies;
import org.apache.hadoop.fs.s3a.auth.delegation.AWSPolicyProvider;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DescendantsIterator;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBClientFactory;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStoreTableManager;
import org.apache.hadoop.fs.s3a.s3guard.ITtlTimeProvider;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.MetastoreInstrumentation;
import org.apache.hadoop.fs.s3a.s3guard.MetastoreInstrumentationImpl;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadataDynamoDBTranslation;
import org.apache.hadoop.fs.s3a.s3guard.PathOrderComparators;
import org.apache.hadoop.fs.s3a.s3guard.ProgressiveRenameTracker;
import org.apache.hadoop.fs.s3a.s3guard.RenameTracker;
import org.apache.hadoop.fs.s3a.s3guard.RetryingCollection;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardDataAccessRetryPolicy;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DynamoDBMetadataStore
implements MetadataStore,
AWSPolicyProvider {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBMetadataStore.class);
    public static final String OPERATIONS_LOG_NAME = "org.apache.hadoop.fs.s3a.s3guard.Operations";
    public static final Logger OPERATIONS_LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.fs.s3a.s3guard.Operations");
    public static final String VERSION_MARKER_ITEM_NAME = "../VERSION";
    public static final String VERSION_MARKER_TAG_NAME = "s3guard_version";
    public static final int VERSION = 100;
    @VisibleForTesting
    static final String BILLING_MODE = "billing-mode";
    @VisibleForTesting
    static final String BILLING_MODE_PER_REQUEST = "per-request";
    @VisibleForTesting
    static final String BILLING_MODE_PROVISIONED = "provisioned";
    @VisibleForTesting
    static final String DESCRIPTION = "S3Guard metadata store in DynamoDB";
    @VisibleForTesting
    static final String READ_CAPACITY = "read-capacity";
    @VisibleForTesting
    static final String WRITE_CAPACITY = "write-capacity";
    @VisibleForTesting
    static final String STATUS = "status";
    @VisibleForTesting
    static final String TABLE = "table";
    @VisibleForTesting
    static final String HINT_DDB_IOPS_TOO_LOW = " This may be because the write threshold of DynamoDB is set too low.";
    @VisibleForTesting
    static final String THROTTLING = "Throttling";
    public static final String E_ON_DEMAND_NO_SET_CAPACITY = "Neither ReadCapacityUnits nor WriteCapacityUnits can be specified when BillingMode is PAY_PER_REQUEST";
    @VisibleForTesting
    static final String E_INCONSISTENT_UPDATE = "Duplicate and inconsistent entry in update operation";
    private static final ValueMap DELETE_TRACKING_VALUE_MAP = new ValueMap().withBoolean(":false", false);
    private static final int S3GUARD_DDB_SUBMITTED_TASK_LIMIT = 50;
    private AmazonDynamoDB amazonDynamoDB;
    private DynamoDB dynamoDB;
    private AWSCredentialProviderList credentials;
    private String region;
    private Table table;
    private String tableName;
    private Configuration conf;
    private String username;
    private RetryPolicy batchWriteRetryPolicy;
    private MetastoreInstrumentation instrumentation = new MetastoreInstrumentationImpl();
    private S3AFileSystem owner;
    private Invoker invoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.NO_OP);
    private Invoker readOp;
    private Invoker writeOp;
    private Invoker scanOp;
    private final AtomicLong readThrottleEvents = new AtomicLong(0L);
    private final AtomicLong writeThrottleEvents = new AtomicLong(0L);
    private final AtomicLong scanThrottleEvents = new AtomicLong(0L);
    private final AtomicLong batchWriteCapacityExceededEvents = new AtomicLong(0L);
    private static final int THROTTLE_EVENT_LOG_LIMIT = 100;
    private AtomicInteger throttleEventCount = new AtomicInteger(0);
    private ListeningExecutorService executor;
    private ITtlTimeProvider ttlTimeProvider;
    private DynamoDBMetadataStoreTableManager tableHandler;

    private DynamoDB createDynamoDB(Configuration conf, String s3Region, String bucket, AWSCredentialsProvider credentials) throws IOException {
        if (this.amazonDynamoDB == null) {
            Preconditions.checkNotNull(conf);
            Class<DynamoDBClientFactory> cls = conf.getClass("fs.s3a.s3guard.ddb.client.factory.impl", S3Guard.S3GUARD_DDB_CLIENT_FACTORY_IMPL_DEFAULT, DynamoDBClientFactory.class);
            LOG.debug("Creating DynamoDB client {} with S3 region {}", cls, (Object)s3Region);
            this.amazonDynamoDB = ReflectionUtils.newInstance(cls, conf).createDynamoDBClient(s3Region, bucket, credentials);
        }
        return new DynamoDB(this.amazonDynamoDB);
    }

    @Override
    public void initialize(FileSystem fs, ITtlTimeProvider ttlTp) throws IOException {
        Preconditions.checkNotNull(fs, "Null filesystem");
        Preconditions.checkArgument(fs instanceof S3AFileSystem, "DynamoDBMetadataStore only supports S3A filesystem - not %s", (Object)fs);
        this.bindToOwnerFilesystem((S3AFileSystem)fs);
        String bucket = this.owner.getBucket();
        String confRegion = this.conf.getTrimmed("fs.s3a.s3guard.ddb.region");
        if (!StringUtils.isEmpty(confRegion)) {
            this.region = confRegion;
            LOG.debug("Overriding S3 region with configured DynamoDB region: {}", (Object)this.region);
        } else {
            try {
                this.region = this.owner.getBucketLocation();
            }
            catch (AccessDeniedException e) {
                URI uri = this.owner.getUri();
                String message = "Failed to get bucket location as client lacks permission s3:GetBucketLocation for " + uri;
                LOG.error(message);
                throw (IOException)new AccessDeniedException(message).initCause(e);
            }
            LOG.debug("Inferring DynamoDB region from S3 bucket: {}", (Object)this.region);
        }
        this.credentials = this.owner.shareCredentials("s3guard");
        this.dynamoDB = this.createDynamoDB(this.conf, this.region, bucket, this.credentials);
        this.tableName = this.conf.getTrimmed("fs.s3a.s3guard.ddb.table", bucket);
        this.initDataAccessRetries(this.conf);
        this.ttlTimeProvider = ttlTp;
        this.tableHandler = new DynamoDBMetadataStoreTableManager(this.dynamoDB, this.tableName, this.region, this.amazonDynamoDB, this.conf, this.readOp, this.batchWriteRetryPolicy);
        this.table = this.tableHandler.initTable();
        this.instrumentation.initialized();
    }

    @VisibleForTesting
    void bindToOwnerFilesystem(S3AFileSystem fs) {
        this.owner = fs;
        this.conf = this.owner.getConf();
        StoreContext context = this.owner.createStoreContext();
        this.instrumentation = context.getInstrumentation().getS3GuardInstrumentation();
        this.username = context.getUsername();
        this.executor = MoreExecutors.listeningDecorator(context.createThrottledExecutor());
        this.ttlTimeProvider = Preconditions.checkNotNull(context.getTimeProvider(), "ttlTimeProvider must not be null");
    }

    @Override
    public void initialize(Configuration config, ITtlTimeProvider ttlTp) throws IOException {
        this.conf = config;
        this.tableName = this.conf.getTrimmed("fs.s3a.s3guard.ddb.table");
        Preconditions.checkArgument(!StringUtils.isEmpty(this.tableName), "No DynamoDB table name configured");
        this.region = this.conf.getTrimmed("fs.s3a.s3guard.ddb.region");
        Preconditions.checkArgument(!StringUtils.isEmpty(this.region), "No DynamoDB region configured");
        this.credentials = S3AUtils.createAWSCredentialProviderSet(null, this.conf);
        this.dynamoDB = this.createDynamoDB(this.conf, this.region, null, this.credentials);
        this.username = UserGroupInformation.getCurrentUser().getShortUserName();
        int executorCapacity = S3AUtils.intOption(this.conf, "fs.s3a.executor.capacity", 16, 1);
        this.executor = MoreExecutors.listeningDecorator(BlockingThreadPoolExecutorService.newInstance(executorCapacity, executorCapacity * 2, S3AUtils.longOption(this.conf, "fs.s3a.threads.keepalivetime", 60L, 0L), TimeUnit.SECONDS, "s3a-ddb-" + this.tableName));
        this.initDataAccessRetries(this.conf);
        this.ttlTimeProvider = ttlTp;
        this.tableHandler = new DynamoDBMetadataStoreTableManager(this.dynamoDB, this.tableName, this.region, this.amazonDynamoDB, this.conf, this.readOp, this.batchWriteRetryPolicy);
        this.table = this.tableHandler.initTable();
    }

    private void initDataAccessRetries(Configuration config) {
        this.batchWriteRetryPolicy = RetryPolicies.exponentialBackoffRetry(config.getInt("fs.s3a.s3guard.ddb.max.retries", 10), this.conf.getTimeDuration("fs.s3a.s3guard.ddb.throttle.retry.interval", "100ms", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        S3GuardDataAccessRetryPolicy throttledRetryRetryPolicy = new S3GuardDataAccessRetryPolicy(config);
        this.readOp = new Invoker(throttledRetryRetryPolicy, this::readRetryEvent);
        this.writeOp = new Invoker(throttledRetryRetryPolicy, this::writeRetryEvent);
        this.scanOp = new Invoker(throttledRetryRetryPolicy, this::scanRetryEvent);
    }

    @Override
    public void delete(Path path, BulkOperationState operationState) throws IOException {
        this.innerDelete(path, true, this.extractOrCreate(operationState, BulkOperationState.OperationType.Delete));
    }

    @Override
    public void forgetMetadata(Path path) throws IOException {
        LOG.debug("Forget metadata for {}", (Object)path);
        this.innerDelete(path, false, null);
    }

    private void innerDelete(Path path, boolean tombstone, AncestorState ancestorState) throws IOException {
        this.checkPath(path);
        LOG.debug("Deleting from table {} in region {}: {}", new Object[]{this.tableName, this.region, path});
        if (path.isRoot()) {
            LOG.debug("Skip deleting root directory as it does not exist in table");
            return;
        }
        boolean idempotent = true;
        if (tombstone) {
            Preconditions.checkArgument(this.ttlTimeProvider != null, "ttlTimeProvider must not be null");
            PathMetadata pmTombstone = PathMetadata.tombstone(path, this.ttlTimeProvider.getNow());
            Item item = PathMetadataDynamoDBTranslation.pathMetadataToItem(new DDBPathMetadata(pmTombstone));
            this.writeOp.retry("Put tombstone", path.toString(), idempotent, () -> {
                DynamoDBMetadataStore.logPut(ancestorState, item);
                this.recordsWritten(1);
                this.table.putItem(item);
            });
        } else {
            PrimaryKey key = PathMetadataDynamoDBTranslation.pathToKey(path);
            this.writeOp.retry("Delete key", path.toString(), idempotent, () -> {
                DynamoDBMetadataStore.logDelete(ancestorState, key);
                this.recordsDeleted(1);
                this.table.deleteItem(key);
            });
        }
    }

    @Override
    public void deleteSubtree(Path path, BulkOperationState operationState) throws IOException {
        this.checkPath(path);
        LOG.debug("Deleting subtree from table {} in region {}: {}", new Object[]{this.tableName, this.region, path});
        DDBPathMetadata meta = this.get(path);
        if (meta == null) {
            LOG.debug("Subtree path {} does not exist; this will be a no-op", (Object)path);
            return;
        }
        if (meta.isDeleted()) {
            LOG.debug("Subtree path {} is deleted; this will be a no-op", (Object)path);
            return;
        }
        this.deleteEntries(RemoteIterators.mappingRemoteIterator(new DescendantsIterator(this, meta), FileStatus::getPath), operationState);
    }

    @Override
    public void deletePaths(Collection<Path> paths, BulkOperationState operationState) throws IOException {
        this.deleteEntries(RemoteIterators.remoteIteratorFromIterable(paths), operationState);
    }

    private void deleteEntries(RemoteIterator<Path> entries, BulkOperationState operationState) throws IOException {
        ArrayList futures = new ArrayList();
        AncestorState state = this.extractOrCreate(operationState, BulkOperationState.OperationType.Delete);
        while (entries.hasNext()) {
            Path pathToDelete = entries.next();
            futures.add(CallableSupplier.submit(this.executor, () -> {
                this.innerDelete(pathToDelete, true, state);
                return null;
            }));
            if (futures.size() <= 50) continue;
            CallableSupplier.waitForCompletion(futures);
            futures.clear();
        }
        CallableSupplier.waitForCompletion(futures);
    }

    private Item getConsistentItem(Path path) throws IOException {
        PrimaryKey key = PathMetadataDynamoDBTranslation.pathToKey(path);
        GetItemSpec spec = new GetItemSpec().withPrimaryKey(key).withConsistentRead(true);
        return this.readOp.retry("get", path.toString(), true, () -> {
            this.recordsRead(1);
            return this.table.getItem(spec);
        });
    }

    @Override
    public DDBPathMetadata get(Path path) throws IOException {
        return this.get(path, false);
    }

    @Override
    public DDBPathMetadata get(Path path, boolean wantEmptyDirectoryFlag) throws IOException {
        this.checkPath(path);
        LOG.debug("Get from table {} in region {}: {} ; wantEmptyDirectory={}", new Object[]{this.tableName, this.region, path, wantEmptyDirectoryFlag});
        DDBPathMetadata result = this.innerGet(path, wantEmptyDirectoryFlag);
        LOG.debug("result of get {} is: {}", (Object)path, (Object)result);
        return result;
    }

    private DDBPathMetadata innerGet(Path path, boolean wantEmptyDirectoryFlag) throws IOException {
        S3AFileStatus status;
        DDBPathMetadata meta;
        if (path.isRoot()) {
            meta = new DDBPathMetadata(this.makeDirStatus(this.username, path));
        } else {
            Item item = this.getConsistentItem(path);
            meta = PathMetadataDynamoDBTranslation.itemToPathMetadata(item, this.username);
            LOG.debug("Get from table {} in region {} returning for {}: {}", new Object[]{this.tableName, this.region, path, meta});
        }
        if (wantEmptyDirectoryFlag && meta != null && !meta.isDeleted() && (status = meta.getFileStatus()).isDirectory()) {
            QuerySpec spec = new QuerySpec().withHashKey(PathMetadataDynamoDBTranslation.pathToParentKeyAttribute(path)).withConsistentRead(true).withFilterExpression("is_deleted = :false").withValueMap(DELETE_TRACKING_VALUE_MAP);
            boolean hasChildren = this.readOp.retry("get/hasChildren", path.toString(), true, () -> {
                Iterator it = this.table.query(spec).iterator();
                if (((IteratorSupport)it).hasNext()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dir {} is non-empty", (Object)status.getPath());
                        while (((IteratorSupport)it).hasNext()) {
                            LOG.debug("{}", (Object)PathMetadataDynamoDBTranslation.itemToPathMetadata((Item)((IteratorSupport)it).next(), this.username));
                        }
                    }
                    return true;
                }
                return false;
            });
            if (meta.isAuthoritativeDir()) {
                meta.setIsEmptyDirectory(hasChildren ? Tristate.FALSE : Tristate.TRUE);
            } else {
                meta.setIsEmptyDirectory(hasChildren ? Tristate.FALSE : Tristate.UNKNOWN);
            }
        }
        return meta;
    }

    private S3AFileStatus makeDirStatus(String dirOwner, Path path) {
        return new S3AFileStatus(Tristate.UNKNOWN, path, dirOwner);
    }

    @Override
    public DirListingMetadata listChildren(Path path) throws IOException {
        this.checkPath(path);
        LOG.debug("Listing table {} in region {}: {}", new Object[]{this.tableName, this.region, path});
        QuerySpec spec = new QuerySpec().withHashKey(PathMetadataDynamoDBTranslation.pathToParentKeyAttribute(path)).withConsistentRead(true);
        ArrayList<PathMetadata> metas = new ArrayList<PathMetadata>();
        ItemCollection items = this.scanOp.retry("listChildren", path.toString(), true, () -> this.table.query(spec));
        try {
            for (Item item : this.wrapWithRetries(items)) {
                metas.add(PathMetadataDynamoDBTranslation.itemToPathMetadata(item, this.username));
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        return this.getDirListingMetadataFromDirMetaAndList(path, metas, this.get(path));
    }

    DirListingMetadata getDirListingMetadataFromDirMetaAndList(Path path, List<PathMetadata> metas, DDBPathMetadata dirPathMeta) {
        boolean isAuthoritative = false;
        if (dirPathMeta != null) {
            isAuthoritative = dirPathMeta.isAuthoritativeDir();
        }
        LOG.trace("Listing table {} in region {} for {} returning {}", new Object[]{this.tableName, this.region, path, metas});
        if (!metas.isEmpty() && dirPathMeta == null) {
            LOG.warn("Directory marker is deleted, but the list of the directory elements is not empty: {}. This case is handled as if the directory was deleted.", metas);
            return null;
        }
        if (metas.isEmpty() && dirPathMeta == null) {
            return null;
        }
        return new DirListingMetadata(path, metas, isAuthoritative, dirPathMeta.getLastUpdated());
    }

    private Collection<DDBPathMetadata> completeAncestry(Collection<DDBPathMetadata> pathsToCreate, AncestorState ancestorState) throws IOException {
        HashMap<Path, Pair<EntryOrigin, DDBPathMetadata>> ancestry = new HashMap<Path, Pair<EntryOrigin, DDBPathMetadata>>();
        LOG.debug("Completing ancestry for {} paths", (Object)pathsToCreate.size());
        ArrayList<DDBPathMetadata> sortedPaths = new ArrayList<DDBPathMetadata>(pathsToCreate);
        sortedPaths.sort(PathOrderComparators.TOPMOST_PM_FIRST);
        for (DDBPathMetadata entry : sortedPaths) {
            Preconditions.checkArgument(entry != null);
            Path path = entry.getFileStatus().getPath();
            LOG.debug("Adding entry {}", (Object)path);
            if (path.isRoot()) break;
            DDBPathMetadata oldEntry = ancestorState.put(path, entry);
            boolean addAncestors = true;
            if (oldEntry != null) {
                boolean oldWasDir = oldEntry.getFileStatus().isDirectory();
                boolean newIsDir = entry.getFileStatus().isDirectory();
                if (oldWasDir && !newIsDir || !oldWasDir && newIsDir) {
                    LOG.warn("Overwriting a S3Guard file created in the operation: {}", (Object)oldEntry);
                    LOG.warn("With new entry: {}", (Object)entry);
                    ancestorState.put(path, oldEntry);
                    throw new PathIOException(path.toString(), String.format("%s old %s new %s", E_INCONSISTENT_UPDATE, oldEntry, entry));
                }
                LOG.debug("Directory at {} being updated with value {}", (Object)path, (Object)entry);
                addAncestors = false;
            }
            ancestry.put(path, Pair.of(EntryOrigin.Requested, entry));
            Path parent = path.getParent();
            while (addAncestors && !parent.isRoot() && !ancestry.containsKey(parent)) {
                if (!ancestorState.findEntry(parent, true)) {
                    Pair<EntryOrigin, DDBPathMetadata> newEntry;
                    DDBPathMetadata md;
                    Item item = this.getConsistentItem(parent);
                    if (item != null && !PathMetadataDynamoDBTranslation.itemToPathMetadata(item, this.username).isDeleted()) {
                        md = PathMetadataDynamoDBTranslation.itemToPathMetadata(item, this.username);
                        LOG.debug("Found existing entry for parent: {}", (Object)md);
                        newEntry = Pair.of(EntryOrigin.Retrieved, md);
                        addAncestors = false;
                    } else {
                        LOG.debug("auto-create ancestor path {} for child path {}", (Object)parent, (Object)path);
                        S3AFileStatus status = DynamoDBMetadataStore.makeDirStatus(parent, this.username);
                        md = new DDBPathMetadata(status, Tristate.FALSE, false, false, this.ttlTimeProvider.getNow());
                        newEntry = Pair.of(EntryOrigin.Generated, md);
                    }
                    ancestorState.put(parent, md);
                    ancestry.put(parent, newEntry);
                }
                parent = parent.getParent();
            }
        }
        return ancestry.values().stream().filter(p -> p.getLeft() != EntryOrigin.Retrieved).map(Pair::getRight).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAncestors(Path qualifiedPath, @Nullable BulkOperationState operationState) throws IOException {
        ArrayList<DDBPathMetadata> newDirs = new ArrayList<DDBPathMetadata>();
        AncestorState ancestorState = this.extractOrCreate(operationState, BulkOperationState.OperationType.Put);
        Path parent = qualifiedPath.getParent();
        boolean entryFound = false;
        while (!parent.isRoot()) {
            AncestorState ancestorState2 = ancestorState;
            synchronized (ancestorState2) {
                if (ancestorState.contains(parent)) {
                    break;
                }
            }
            DDBPathMetadata directory = this.get(parent);
            if (directory == null || directory.isDeleted()) {
                if (entryFound) {
                    LOG.warn("Inconsistent S3Guard table: adding directory {}", (Object)parent);
                }
                S3AFileStatus status = this.makeDirStatus(this.username, parent);
                LOG.debug("Adding new ancestor entry {}", (Object)status);
                DDBPathMetadata meta = new DDBPathMetadata(status, Tristate.FALSE, false, this.ttlTimeProvider.getNow());
                newDirs.add(meta);
            } else {
                entryFound = true;
                if (directory.getFileStatus().isFile()) {
                    throw new PathIOException(parent.toString(), "Cannot overwrite parent file: metastore is in an inconsistent state");
                }
                AncestorState ancestorState3 = ancestorState;
                synchronized (ancestorState3) {
                    ancestorState.put(parent, new DDBPathMetadata(directory));
                }
            }
            parent = parent.getParent();
        }
        if (!newDirs.isEmpty()) {
            S3Guard.patchLastUpdated(newDirs, this.ttlTimeProvider);
            this.innerPut(newDirs, operationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(@Nullable Collection<Path> pathsToDelete, @Nullable Collection<PathMetadata> pathsToCreate, @Nullable BulkOperationState operationState) throws IOException {
        if (pathsToDelete == null && pathsToCreate == null) {
            return;
        }
        LOG.debug("Moving paths of table {} in region {}: {} paths to delete and {} paths to create", new Object[]{this.tableName, this.region, pathsToDelete == null ? 0 : pathsToDelete.size(), pathsToCreate == null ? 0 : pathsToCreate.size()});
        LOG.trace("move: pathsToDelete = {}, pathsToCreate = {}", pathsToDelete, pathsToCreate);
        AncestorState ancestorState = this.extractOrCreate(operationState, BulkOperationState.OperationType.Rename);
        ArrayList<DDBPathMetadata> newItems = new ArrayList<DDBPathMetadata>();
        if (pathsToCreate != null) {
            AncestorState ancestorState2 = ancestorState;
            synchronized (ancestorState2) {
                newItems.addAll(this.completeAncestry(PathMetadataDynamoDBTranslation.pathMetaToDDBPathMeta(pathsToCreate), ancestorState));
            }
        }
        newItems.sort(PathOrderComparators.TOPMOST_PM_FIRST);
        if (pathsToDelete != null) {
            ArrayList<PathMetadata> tombstones = new ArrayList<PathMetadata>(pathsToDelete.size());
            for (Path meta : pathsToDelete) {
                Preconditions.checkArgument(this.ttlTimeProvider != null, "ttlTimeProvider must not be null");
                PathMetadata pmTombstone = PathMetadata.tombstone(meta, this.ttlTimeProvider.getNow());
                tombstones.add(new DDBPathMetadata(pmTombstone));
            }
            tombstones.sort(PathOrderComparators.TOPMOST_PM_LAST);
            newItems.addAll(tombstones);
        }
        this.processBatchWriteRequest(ancestorState, null, PathMetadataDynamoDBTranslation.pathMetadataToItem(newItems));
    }

    private int processBatchWriteRequest(@Nullable AncestorState ancestorState, PrimaryKey[] keysToDelete, Item[] itemsToPut) throws IOException {
        int totalToPut;
        int totalToDelete = keysToDelete == null ? 0 : keysToDelete.length;
        int n = totalToPut = itemsToPut == null ? 0 : itemsToPut.length;
        if (totalToPut == 0 && totalToDelete == 0) {
            LOG.debug("Ignoring empty batch write request");
            return 0;
        }
        int count = 0;
        int batches = 0;
        while (count < totalToDelete + totalToPut) {
            TableWriteItems writeItems = new TableWriteItems(this.tableName);
            int numToDelete = 0;
            if (keysToDelete != null && count < totalToDelete) {
                numToDelete = Math.min(25, totalToDelete - count);
                PrimaryKey[] toDelete = Arrays.copyOfRange(keysToDelete, count, count + numToDelete);
                LOG.debug("Deleting {} entries: {}", (Object)toDelete.length, (Object)toDelete);
                writeItems.withPrimaryKeysToDelete(toDelete);
                count += numToDelete;
            }
            if (numToDelete < 25 && itemsToPut != null && count < totalToDelete + totalToPut) {
                int numToPut = Math.min(25 - numToDelete, totalToDelete + totalToPut - count);
                int index = count - totalToDelete;
                writeItems.withItemsToPut(Arrays.copyOfRange(itemsToPut, index, index + numToPut));
                count += numToPut;
            }
            ++batches;
            BatchWriteItemOutcome res = this.writeOp.retry("batch write", "", true, () -> this.dynamoDB.batchWriteItem(writeItems));
            Map<String, List<WriteRequest>> unprocessed = res.getUnprocessedItems();
            int retryCount = 0;
            while (!unprocessed.isEmpty()) {
                this.batchWriteCapacityExceededEvents.incrementAndGet();
                ++batches;
                this.retryBackoffOnBatchWrite(retryCount++);
                Map<String, List<WriteRequest>> upx = unprocessed;
                res = this.writeOp.retry("batch write", "", true, () -> this.dynamoDB.batchWriteItemUnprocessed(upx));
                unprocessed = res.getUnprocessedItems();
            }
        }
        if (itemsToPut != null) {
            this.recordsWritten(itemsToPut.length);
            DynamoDBMetadataStore.logPut(ancestorState, itemsToPut);
        }
        if (keysToDelete != null) {
            this.recordsDeleted(keysToDelete.length);
            DynamoDBMetadataStore.logDelete(ancestorState, keysToDelete);
        }
        return batches;
    }

    private void retryBackoffOnBatchWrite(int retryCount) throws IOException {
        try {
            RetryPolicy.RetryAction action = this.batchWriteRetryPolicy.shouldRetry(null, retryCount, 0, true);
            if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                AmazonServiceException cause = new AmazonServiceException(THROTTLING);
                cause.setServiceName("S3Guard");
                cause.setStatusCode(503);
                cause.setErrorCode(THROTTLING);
                cause.setErrorType(AmazonServiceException.ErrorType.Service);
                cause.setErrorMessage(THROTTLING);
                cause.setRequestId("n/a");
                throw new AWSServiceThrottledException(String.format("Max retries during batch write exceeded (%d) for DynamoDB. This may be because the write threshold of DynamoDB is set too low.", retryCount), cause);
            }
            LOG.debug("Sleeping {} msec before next retry", (Object)action.delayMillis);
            Thread.sleep(action.delayMillis);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Unexpected exception " + e, e);
        }
    }

    @Override
    public void put(PathMetadata meta) throws IOException {
        this.put(meta, null);
    }

    @Override
    public void put(PathMetadata meta, @Nullable BulkOperationState operationState) throws IOException {
        LOG.debug("Saving to table {} in region {}: {}", new Object[]{this.tableName, this.region, meta});
        ArrayList<PathMetadata> wrapper = new ArrayList<PathMetadata>(1);
        wrapper.add(meta);
        this.put(wrapper, operationState);
    }

    @Override
    public void put(Collection<? extends PathMetadata> metas, @Nullable BulkOperationState operationState) throws IOException {
        this.innerPut(PathMetadataDynamoDBTranslation.pathMetaToDDBPathMeta(metas), operationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerPut(Collection<DDBPathMetadata> metas, @Nullable BulkOperationState operationState) throws IOException {
        Item[] items;
        AncestorState ancestorState;
        if (metas.isEmpty()) {
            LOG.debug("Ignoring empty list of entries to put");
            return;
        }
        AncestorState ancestorState2 = ancestorState = this.extractOrCreate(operationState, BulkOperationState.OperationType.Put);
        synchronized (ancestorState2) {
            items = PathMetadataDynamoDBTranslation.pathMetadataToItem(this.completeAncestry(metas, ancestorState));
        }
        LOG.debug("Saving batch of {} items to table {}, region {}", new Object[]{items.length, this.tableName, this.region});
        this.processBatchWriteRequest(ancestorState, null, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<DDBPathMetadata> fullPathsToPut(DDBPathMetadata meta, @Nullable BulkOperationState operationState) throws IOException {
        DynamoDBMetadataStore.checkPathMetadata(meta);
        ArrayList<DDBPathMetadata> metasToPut = new ArrayList<DDBPathMetadata>();
        if (!meta.getFileStatus().getPath().isRoot()) {
            metasToPut.add(meta);
        }
        AncestorState ancestorState = this.extractOrCreate(operationState, BulkOperationState.OperationType.Put);
        for (Path path = meta.getFileStatus().getPath().getParent(); path != null && !path.isRoot(); path = path.getParent()) {
            AncestorState ancestorState2 = ancestorState;
            synchronized (ancestorState2) {
                if (ancestorState.findEntry(path, true)) {
                    break;
                }
            }
            Item item = this.getConsistentItem(path);
            if (!DynamoDBMetadataStore.itemExists(item)) {
                S3AFileStatus status = DynamoDBMetadataStore.makeDirStatus(path, this.username);
                metasToPut.add(new DDBPathMetadata(status, Tristate.FALSE, false, meta.isAuthoritativeDir(), meta.getLastUpdated()));
                continue;
            }
            AncestorState ancestorState3 = ancestorState;
            synchronized (ancestorState3) {
                ancestorState.put(path, PathMetadataDynamoDBTranslation.itemToPathMetadata(item, this.username));
                break;
            }
        }
        return metasToPut;
    }

    private static boolean itemExists(Item item) {
        if (item == null) {
            return false;
        }
        return !item.hasAttribute("is_deleted") || !item.getBoolean("is_deleted");
    }

    private static boolean getBoolAttribute(Item item, String attrName, boolean defVal) {
        return item.hasAttribute(attrName) ? item.getBoolean(attrName) : defVal;
    }

    static S3AFileStatus makeDirStatus(Path f, String owner) {
        return new S3AFileStatus(Tristate.UNKNOWN, f, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(DirListingMetadata meta, List<Path> unchangedEntries, @Nullable BulkOperationState operationState) throws IOException {
        LOG.debug("Saving {} dir meta for {} to table {} in region {}: {}", new Object[]{meta.isAuthoritative() ? "auth" : "nonauth", meta.getPath(), this.tableName, this.region, meta});
        Path path = meta.getPath();
        DDBPathMetadata ddbPathMeta = new DDBPathMetadata(DynamoDBMetadataStore.makeDirStatus(path, this.username), meta.isEmpty(), false, meta.isAuthoritative(), meta.getLastUpdated());
        AncestorState ancestorState = this.extractOrCreate(operationState, BulkOperationState.OperationType.Put);
        List<DDBPathMetadata> metasToPut = this.fullPathsToPut(ddbPathMeta, ancestorState);
        Collection children = meta.getListing().stream().filter(e -> !unchangedEntries.contains(e.getFileStatus().getPath())).collect(Collectors.toList());
        metasToPut.addAll(PathMetadataDynamoDBTranslation.pathMetaToDDBPathMeta(children));
        metasToPut.sort(PathOrderComparators.TOPMOST_PM_FIRST);
        this.processBatchWriteRequest(ancestorState, null, PathMetadataDynamoDBTranslation.pathMetadataToItem(metasToPut));
        AncestorState ancestorState2 = ancestorState;
        synchronized (ancestorState2) {
            metasToPut.forEach(ancestorState::put);
        }
    }

    @Override
    public synchronized void close() {
        this.instrumentation.storeClosed();
        try {
            if (this.dynamoDB != null) {
                LOG.debug("Shutting down {}", (Object)this);
                this.dynamoDB.shutdown();
                this.dynamoDB = null;
            }
        }
        catch (Throwable throwable) {
            S3AUtils.closeAutocloseables(LOG, this.credentials);
            this.credentials = null;
            throw throwable;
        }
        S3AUtils.closeAutocloseables(LOG, this.credentials);
        this.credentials = null;
    }

    @Override
    public void destroy() throws IOException {
        this.tableHandler.destroy();
    }

    private ItemCollection<ScanOutcome> expiredFiles(MetadataStore.PruneMode pruneMode, long cutoff, String keyPrefix) throws IOException {
        ValueMap map;
        String projectionExpression;
        String filterExpression;
        switch (pruneMode) {
            case ALL_BY_MODTIME: {
                filterExpression = "mod_time < :mod_time and begins_with(parent, :parent) and not is_dir = :is_dir";
                projectionExpression = "parent,child";
                map = new ValueMap().withLong(":mod_time", cutoff).withString(":parent", keyPrefix).withBoolean(":is_dir", true);
                break;
            }
            case TOMBSTONES_BY_LASTUPDATED: {
                filterExpression = "last_updated < :last_updated and begins_with(parent, :parent) and is_deleted = :is_deleted";
                projectionExpression = "parent,child,is_deleted";
                map = new ValueMap().withLong(":last_updated", cutoff).withString(":parent", keyPrefix).withBoolean(":is_deleted", true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported prune mode: " + (Object)((Object)pruneMode));
            }
        }
        return this.readOp.retry("scan", keyPrefix, true, () -> this.table.scan(filterExpression, projectionExpression, null, map));
    }

    @Override
    public void prune(MetadataStore.PruneMode pruneMode, long cutoff) throws IOException {
        this.prune(pruneMode, cutoff, "/");
    }

    @Override
    public long prune(MetadataStore.PruneMode pruneMode, long cutoff, String keyPrefix) throws IOException {
        LOG.debug("Prune {} under {} with age {}", new Object[]{pruneMode == MetadataStore.PruneMode.ALL_BY_MODTIME ? "files and tombstones" : "tombstones", keyPrefix, cutoff});
        ItemCollection<ScanOutcome> items = this.expiredFiles(pruneMode, cutoff, keyPrefix);
        return this.innerPrune(pruneMode, cutoff, keyPrefix, items);
    }

    private int innerPrune(MetadataStore.PruneMode pruneMode, long cutoff, String keyPrefix, ItemCollection<ScanOutcome> items) throws IOException {
        int itemCount = 0;
        try (AncestorState state = this.initiateBulkWrite(BulkOperationState.OperationType.Prune, null);
             DurationInfo ignored = new DurationInfo(LOG, "Pruning DynamoDB Store", new Object[0]);){
            ArrayList<Path> deletionBatch = new ArrayList<Path>(25);
            long delay = this.conf.getTimeDuration("fs.s3a.s3guard.ddb.background.sleep", 25L, TimeUnit.MILLISECONDS);
            HashSet<Path> parentPathSet = new HashSet<Path>();
            HashSet clearedParentPathSet = new HashSet();
            CallableRaisingIOE<Void> deleteBatchOperation = () -> {
                deletionBatch.sort(PathOrderComparators.TOPMOST_PATH_LAST);
                this.processBatchWriteRequest(state, PathMetadataDynamoDBTranslation.pathToKey(deletionBatch), null);
                this.removeAuthoritativeDirFlag(parentPathSet, state);
                clearedParentPathSet.addAll(parentPathSet);
                parentPathSet.clear();
                return null;
            };
            for (Item item : items) {
                DDBPathMetadata md = PathMetadataDynamoDBTranslation.itemToPathMetadata(item, this.username);
                Path path = md.getFileStatus().getPath();
                boolean tombstone = md.isDeleted();
                LOG.debug("Prune entry {}", (Object)path);
                deletionBatch.add(path);
                Path parentPath = path.getParent();
                if (!(tombstone || parentPath == null || parentPath.isRoot() || clearedParentPathSet.contains(parentPath))) {
                    parentPathSet.add(parentPath);
                }
                ++itemCount;
                if (deletionBatch.size() != 25) continue;
                deleteBatchOperation.apply();
                deletionBatch.clear();
                if (delay <= 0L) continue;
                Thread.sleep(delay);
            }
            if (!deletionBatch.isEmpty()) {
                deleteBatchOperation.apply();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Pruning was interrupted");
        }
        catch (AmazonDynamoDBException e) {
            throw S3AUtils.translateDynamoDBException(keyPrefix, "Prune of " + keyPrefix + " failed", e);
        }
        LOG.info("Finished pruning {} items in batches of {}", (Object)itemCount, (Object)25);
        return itemCount;
    }

    private void removeAuthoritativeDirFlag(Set<Path> pathSet, AncestorState state) throws IOException {
        AtomicReference<IOException> rIOException = new AtomicReference<IOException>();
        Set<DDBPathMetadata> metas = pathSet.stream().map(path -> {
            try {
                if (path.isRoot()) {
                    LOG.debug("ignoring root path");
                    return null;
                }
                if (state != null && state.get((Path)path) != null) {
                    LOG.debug("Ignoring update of entry already in the state map");
                    return null;
                }
                DDBPathMetadata ddbPathMetadata = this.get((Path)path);
                if (ddbPathMetadata == null) {
                    LOG.debug("No parent {}; skipping", path);
                    return null;
                }
                if (ddbPathMetadata.isDeleted()) {
                    LOG.debug("Parent has been deleted {}; skipping", path);
                    return null;
                }
                if (!ddbPathMetadata.getFileStatus().isDirectory()) {
                    LOG.debug("Parent is not a directory {}; skipping", path);
                    return null;
                }
                LOG.debug("Setting isAuthoritativeDir==false on {}", (Object)ddbPathMetadata);
                ddbPathMetadata.setAuthoritativeDir(false);
                ddbPathMetadata.setLastUpdated(this.ttlTimeProvider.getNow());
                return ddbPathMetadata;
            }
            catch (IOException e) {
                String msg = String.format("IOException while getting PathMetadata on path: %s.", path);
                LOG.error(msg, (Throwable)e);
                rIOException.set(e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            LOG.debug("innerPut on metas: {}", metas);
            if (!metas.isEmpty()) {
                this.innerPut(metas, state);
            }
        }
        catch (IOException e) {
            String msg = String.format("IOException while setting false authoritative directory flag on: %s.", metas);
            LOG.error(msg, (Throwable)e);
            rIOException.set(e);
        }
        if (rIOException.get() != null) {
            throw (IOException)rIOException.get();
        }
    }

    @VisibleForTesting
    public AmazonDynamoDB getAmazonDynamoDB() {
        return this.amazonDynamoDB;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "region=" + this.region + ", tableName=" + this.tableName + ", tableArn=" + this.tableHandler.getTableArn() + '}';
    }

    @Override
    public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
        Preconditions.checkState(this.tableHandler.getTableArn() != null, "TableARN not known");
        if (access.isEmpty()) {
            return Collections.emptyList();
        }
        RoleModel.Statement stat = access.contains((Object)AWSPolicyProvider.AccessLevel.ADMIN) ? RolePolicies.allowAllDynamoDBOperations(this.tableHandler.getTableArn()) : RolePolicies.allowS3GuardClientOperations(this.tableHandler.getTableArn());
        return Lists.newArrayList(stat);
    }

    private PutItemOutcome putItem(Item item) {
        LOG.debug("Putting item {}", (Object)item);
        return this.table.putItem(item);
    }

    @VisibleForTesting
    Table getTable() {
        return this.table;
    }

    String getRegion() {
        return this.region;
    }

    @VisibleForTesting
    public String getTableName() {
        return this.tableName;
    }

    @VisibleForTesting
    DynamoDB getDynamoDB() {
        return this.dynamoDB;
    }

    private Path checkPath(Path path) {
        Preconditions.checkNotNull(path);
        Preconditions.checkArgument(path.isAbsolute(), "Path %s is not absolute", (Object)path);
        URI uri = path.toUri();
        Preconditions.checkNotNull(uri.getScheme(), "Path %s missing scheme", (Object)path);
        Preconditions.checkArgument(uri.getScheme().equals("s3a"), "Path %s scheme must be %s", (Object)path, (Object)"s3a");
        Preconditions.checkArgument(!StringUtils.isEmpty(uri.getHost()), "Path %s is missing bucket.", (Object)path);
        return path;
    }

    private static void checkPathMetadata(PathMetadata meta) {
        Preconditions.checkNotNull(meta);
        Preconditions.checkNotNull(meta.getFileStatus());
        Preconditions.checkNotNull(meta.getFileStatus().getPath());
    }

    @Override
    public Map<String, String> getDiagnostics() throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (this.table != null) {
            TableDescription desc = this.getTableDescription(true);
            map.put("name", desc.getTableName());
            map.put(STATUS, desc.getTableStatus());
            map.put("ARN", desc.getTableArn());
            map.put("size", desc.getTableSizeBytes().toString());
            map.put(TABLE, desc.toString());
            ProvisionedThroughputDescription throughput = desc.getProvisionedThroughput();
            map.put(READ_CAPACITY, throughput.getReadCapacityUnits().toString());
            map.put(WRITE_CAPACITY, throughput.getWriteCapacityUnits().toString());
            map.put(BILLING_MODE, throughput.getWriteCapacityUnits() == 0L ? BILLING_MODE_PER_REQUEST : BILLING_MODE_PROVISIONED);
            map.put("sse", desc.getSSEDescription() == null ? "DISABLED" : desc.getSSEDescription().toString());
            map.put("persist.authoritative.bit", Boolean.toString(true));
        } else {
            map.put("name", "DynamoDB Metadata Store");
            map.put(TABLE, "none");
            map.put(STATUS, "undefined");
        }
        map.put("description", DESCRIPTION);
        map.put("region", this.region);
        if (this.batchWriteRetryPolicy != null) {
            map.put("retryPolicy", this.batchWriteRetryPolicy.toString());
        }
        return map;
    }

    private TableDescription getTableDescription(boolean forceUpdate) {
        TableDescription desc = this.table.getDescription();
        if (desc == null || forceUpdate) {
            desc = this.table.describe();
        }
        return desc;
    }

    @Override
    public void updateParameters(Map<String, String> parameters) throws IOException {
        Preconditions.checkNotNull(this.table, "Not initialized");
        TableDescription desc = this.getTableDescription(true);
        ProvisionedThroughputDescription current = desc.getProvisionedThroughput();
        long currentRead = current.getReadCapacityUnits();
        long newRead = this.getLongParam(parameters, "fs.s3a.s3guard.ddb.table.capacity.read", currentRead);
        long currentWrite = current.getWriteCapacityUnits();
        long newWrite = this.getLongParam(parameters, "fs.s3a.s3guard.ddb.table.capacity.write", currentWrite);
        if (currentRead == 0L || currentWrite == 0L) {
            throw new IOException(E_ON_DEMAND_NO_SET_CAPACITY);
        }
        if (newRead != currentRead || newWrite != currentWrite) {
            LOG.info("Current table capacity is read: {}, write: {}", (Object)currentRead, (Object)currentWrite);
            LOG.info("Changing capacity of table to read: {}, write: {}", (Object)newRead, (Object)newWrite);
            this.tableHandler.provisionTableBlocking(newRead, newWrite);
        } else {
            LOG.info("Table capacity unchanged at read: {}, write: {}", (Object)newRead, (Object)newWrite);
        }
    }

    private long getLongParam(Map<String, String> parameters, String key, long defVal) {
        String k = parameters.get(key);
        if (k != null) {
            return Long.parseLong(k);
        }
        return defVal;
    }

    void readRetryEvent(String text, IOException ex, int attempts, boolean idempotent) {
        this.readThrottleEvents.incrementAndGet();
        this.retryEvent(text, ex, attempts, true);
    }

    void writeRetryEvent(String text, IOException ex, int attempts, boolean idempotent) {
        this.writeThrottleEvents.incrementAndGet();
        this.retryEvent(text, ex, attempts, idempotent);
    }

    void scanRetryEvent(String text, IOException ex, int attempts, boolean idempotent) {
        this.scanThrottleEvents.incrementAndGet();
        this.retryEvent(text, ex, attempts, idempotent);
    }

    void retryEvent(String text, IOException ex, int attempts, boolean idempotent) {
        if (S3AUtils.isThrottleException(ex)) {
            this.instrumentation.throttled();
            int eventCount = this.throttleEventCount.addAndGet(1);
            if (attempts == 1 && eventCount < 100) {
                LOG.warn("DynamoDB IO limits reached in {}; consider increasing capacity: {}", (Object)text, (Object)ex.toString());
                LOG.debug("Throttled", (Throwable)ex);
            } else {
                LOG.debug("DynamoDB IO limits reached in {}; consider increasing capacity: {}", (Object)text, (Object)ex.toString());
            }
        } else if (attempts == 1) {
            LOG.info("Retrying {}: {}", (Object)text, (Object)ex.toString());
            LOG.debug("Retrying {}", (Object)text, (Object)ex);
        }
        this.instrumentation.retrying();
        if (this.owner != null) {
            this.owner.metastoreOperationRetried(ex, attempts, idempotent);
        }
    }

    @VisibleForTesting
    public long getReadThrottleEventCount() {
        return this.readThrottleEvents.get();
    }

    @VisibleForTesting
    public long getWriteThrottleEventCount() {
        return this.writeThrottleEvents.get();
    }

    @VisibleForTesting
    public long getScanThrottleEventCount() {
        return this.scanThrottleEvents.get();
    }

    @VisibleForTesting
    public long getBatchWriteCapacityExceededCount() {
        return this.batchWriteCapacityExceededEvents.get();
    }

    public Invoker getInvoker() {
        return this.writeOp;
    }

    public <T> Iterable<T> wrapWithRetries(Iterable<T> source) {
        return new RetryingCollection<T>("scan dynamoDB table", this.scanOp, source);
    }

    private void recordsWritten(int count) {
        this.instrumentation.recordsWritten(count);
    }

    private void recordsRead(int count) {
        this.instrumentation.recordsRead(count);
    }

    private void recordsDeleted(int count) {
        this.instrumentation.recordsDeleted(count);
    }

    @Override
    public RenameTracker initiateRenameOperation(StoreContext storeContext, Path source, S3AFileStatus sourceStatus, Path dest) {
        return new ProgressiveRenameTracker(storeContext, this, source, dest, new AncestorState(this, BulkOperationState.OperationType.Rename, dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int markAsAuthoritative(Path dest, BulkOperationState operationState) throws IOException {
        if (operationState == null) {
            return 0;
        }
        Preconditions.checkArgument(operationState instanceof AncestorState, "Not an AncestorState %s", (Object)operationState);
        AncestorState state = (AncestorState)operationState;
        String simpleDestKey = PathMetadataDynamoDBTranslation.pathToParentKey(dest);
        String destPathKey = simpleDestKey + "/";
        String opId = AncestorState.stateAsString(state);
        LOG.debug("{}: marking directories under {} as authoritative", (Object)opId, (Object)destPathKey);
        ArrayList<DDBPathMetadata> dirsToUpdate = new ArrayList<DDBPathMetadata>();
        AncestorState ancestorState = state;
        synchronized (ancestorState) {
            for (Map.Entry<Path, DDBPathMetadata> entry : state.getAncestry().entrySet()) {
                Path path = entry.getKey();
                DDBPathMetadata md = entry.getValue();
                String key = PathMetadataDynamoDBTranslation.pathToParentKey(path);
                if (!md.getFileStatus().isDirectory() || !key.equals(simpleDestKey) && !key.startsWith(destPathKey)) continue;
                md.setAuthoritativeDir(true);
                md.setLastUpdated(this.ttlTimeProvider.getNow());
                LOG.debug("{}: added {}", (Object)opId, (Object)key);
                dirsToUpdate.add(md);
            }
            this.processBatchWriteRequest(state, null, PathMetadataDynamoDBTranslation.pathMetadataToItem(dirsToUpdate));
        }
        return dirsToUpdate.size();
    }

    @Override
    public AncestorState initiateBulkWrite(BulkOperationState.OperationType operation, Path dest) {
        return new AncestorState(this, operation, dest);
    }

    @Override
    public void setTtlTimeProvider(ITtlTimeProvider ttlTimeProvider) {
        this.ttlTimeProvider = ttlTimeProvider;
    }

    String getUsername() {
        return this.username;
    }

    private static void logPut(@Nullable AncestorState state, Item[] items) {
        if (OPERATIONS_LOG.isDebugEnabled()) {
            String stateStr = AncestorState.stateAsString(state);
            for (Item item : items) {
                boolean tombstone = !DynamoDBMetadataStore.itemExists(item);
                boolean isDir = DynamoDBMetadataStore.getBoolAttribute(item, "is_dir", false);
                boolean auth = DynamoDBMetadataStore.getBoolAttribute(item, "is_authoritative", false);
                OPERATIONS_LOG.debug("{} {} {}{}{}", new Object[]{stateStr, tombstone ? "TOMBSTONE" : "PUT", PathMetadataDynamoDBTranslation.itemPrimaryKeyToString(item), auth ? " [auth]" : "", isDir ? " directory" : ""});
            }
        }
    }

    private static void logPut(@Nullable AncestorState state, Item item) {
        if (OPERATIONS_LOG.isDebugEnabled()) {
            DynamoDBMetadataStore.logPut(state, new Item[]{item});
        }
    }

    private static void logDelete(@Nullable AncestorState state, PrimaryKey[] keysDeleted) {
        if (OPERATIONS_LOG.isDebugEnabled()) {
            String stateStr = AncestorState.stateAsString(state);
            for (PrimaryKey key : keysDeleted) {
                OPERATIONS_LOG.debug("{} DELETE {}", (Object)stateStr, (Object)PathMetadataDynamoDBTranslation.primaryKeyToString(key));
            }
        }
    }

    private static void logDelete(@Nullable AncestorState state, PrimaryKey key) {
        if (OPERATIONS_LOG.isDebugEnabled()) {
            DynamoDBMetadataStore.logDelete(state, new PrimaryKey[]{key});
        }
    }

    private AncestorState extractOrCreate(@Nullable BulkOperationState state, BulkOperationState.OperationType operation) {
        if (state != null) {
            return (AncestorState)state;
        }
        return new AncestorState(this, operation, null);
    }

    @Override
    public MetastoreInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    protected DynamoDBMetadataStoreTableManager getTableHandler() {
        Preconditions.checkNotNull(this.tableHandler, "Not initialized");
        return this.tableHandler;
    }

    @VisibleForTesting
    static final class AncestorState
    extends BulkOperationState {
        private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
        private final DynamoDBMetadataStore store;
        private final long id;
        private final Map<Path, DDBPathMetadata> ancestry = new HashMap<Path, DDBPathMetadata>();
        private final Path dest;

        AncestorState(@Nullable DynamoDBMetadataStore store, BulkOperationState.OperationType operation, @Nullable Path dest) {
            super(operation);
            this.store = store;
            this.dest = dest;
            this.id = ID_COUNTER.addAndGet(1L);
        }

        int size() {
            return this.ancestry.size();
        }

        Map<Path, DDBPathMetadata> getAncestry() {
            return this.ancestry;
        }

        public Path getDest() {
            return this.dest;
        }

        long getId() {
            return this.id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AncestorState{");
            sb.append("operation=").append((Object)this.getOperation());
            sb.append("id=").append(this.id);
            sb.append("; dest=").append(this.dest);
            sb.append("; size=").append(this.size());
            sb.append("; paths={").append(StringUtils.join(this.ancestry.keySet(), " ")).append('}');
            sb.append('}');
            return sb.toString();
        }

        boolean contains(Path p) {
            return this.get(p) != null;
        }

        DDBPathMetadata put(Path p, DDBPathMetadata md) {
            return this.ancestry.put(p, md);
        }

        DDBPathMetadata put(DDBPathMetadata md) {
            return this.ancestry.put(md.getFileStatus().getPath(), md);
        }

        DDBPathMetadata get(Path p) {
            return this.ancestry.get(p);
        }

        boolean findEntry(Path path, boolean failOnFile) throws PathIOException {
            DDBPathMetadata ancestor = this.get(path);
            if (ancestor != null) {
                if (!ancestor.getFileStatus().isDirectory()) {
                    String message = "Duplicate and inconsistent entry in update operation entry is " + ancestor.getFileStatus();
                    LOG.error(message);
                    if (failOnFile) {
                        throw new PathIOException(path.toString(), message);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            if (LOG.isDebugEnabled() && this.store != null) {
                LOG.debug("Auditing {}", (Object)AncestorState.stateAsString(this));
                for (Map.Entry<Path, DDBPathMetadata> entry : this.ancestry.entrySet()) {
                    String message;
                    DDBPathMetadata actual;
                    Path path = entry.getKey();
                    DDBPathMetadata expected = entry.getValue();
                    if (expected.isDeleted()) continue;
                    try {
                        actual = this.store.get(path);
                    }
                    catch (IOException e) {
                        LOG.debug("Retrieving {}", (Object)path, (Object)e);
                        return;
                    }
                    if (actual == null || actual.isDeleted()) {
                        message = "Metastore entry for path " + path + " deleted during bulk " + (Object)((Object)this.getOperation()) + " operation";
                        LOG.debug(message);
                        continue;
                    }
                    if (actual.getFileStatus().isDirectory() == expected.getFileStatus().isDirectory()) continue;
                    message = "Metastore entry for path " + path + " changed during bulk " + (Object)((Object)this.getOperation()) + " operation from " + expected + " to " + actual;
                    LOG.debug(message);
                }
            }
        }

        private static String stateAsString(@Nullable AncestorState state) {
            String stateStr = state != null ? String.format("#(%s-%04d)", new Object[]{state.getOperation(), state.getId()}) : "#()";
            return stateStr;
        }
    }

    private static enum EntryOrigin {
        Requested,
        Retrieved,
        Generated;

    }
}

