/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.Metalake;
import org.apache.gravitino.proto.ProtoSerDe;
import org.apache.gravitino.proto.SchemaVersion;

class BaseMetalakeSerDe
implements ProtoSerDe<BaseMetalake, Metalake> {
    BaseMetalakeSerDe() {
    }

    @Override
    public Metalake serialize(BaseMetalake baseMetalake) {
        Metalake.Builder builder = Metalake.newBuilder().setId(baseMetalake.id().longValue()).setName(baseMetalake.name()).setAuditInfo(new AuditInfoSerDe().serialize(baseMetalake.auditInfo()));
        if (baseMetalake.comment() != null) {
            builder.setComment(baseMetalake.comment());
        }
        if (baseMetalake.properties() != null && !baseMetalake.properties().isEmpty()) {
            builder.putAllProperties(baseMetalake.properties());
        }
        SchemaVersion version = SchemaVersion.newBuilder().setMajorNumber(baseMetalake.getVersion().majorVersion).setMinorNumber(baseMetalake.getVersion().minorVersion).build();
        builder.setVersion(version);
        return builder.build();
    }

    @Override
    public BaseMetalake deserialize(Metalake p, Namespace namespace) {
        BaseMetalake.Builder builder = BaseMetalake.builder();
        builder.withId(p.getId()).withName(p.getName()).withAuditInfo(new AuditInfoSerDe().deserialize(p.getAuditInfo(), namespace));
        if (p.hasComment()) {
            builder.withComment(p.getComment());
        }
        if (p.getPropertiesCount() > 0) {
            builder.withProperties(p.getPropertiesMap());
        }
        org.apache.gravitino.meta.SchemaVersion version = org.apache.gravitino.meta.SchemaVersion.forValues(p.getVersion().getMajorNumber(), p.getVersion().getMinorNumber());
        builder.withVersion(version);
        return builder.build();
    }
}

