/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.storage.BiPredicate;
import org.apache.gravitino.utils.Bytes;

public class KvRange {
    private byte[] start;
    private byte[] end;
    private boolean startInclusive;
    private boolean endInclusive;
    private int limit;
    private BiPredicate<byte[], byte[]> predicate;

    public KvRange(byte[] start, byte[] end, boolean startInclusive, boolean endInclusive, int limit, BiPredicate<byte[], byte[]> predicate) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"start cannot be null");
        Preconditions.checkArgument((end != null ? 1 : 0) != 0, (Object)"start cannot be null");
        Preconditions.checkArgument((Bytes.wrap(start).compareTo(end) <= 0 ? 1 : 0) != 0, (Object)"start must be less than or equal to end");
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater than 0");
        this.start = start;
        this.end = end;
        this.startInclusive = startInclusive;
        this.endInclusive = endInclusive;
        this.limit = limit;
        this.predicate = predicate == null ? (k, v) -> true : predicate;
    }

    public static KvRangeBuilder builder() {
        return new KvRangeBuilder();
    }

    public byte[] getStart() {
        return this.start;
    }

    public byte[] getEnd() {
        return this.end;
    }

    public boolean isStartInclusive() {
        return this.startInclusive;
    }

    public boolean isEndInclusive() {
        return this.endInclusive;
    }

    public int getLimit() {
        return this.limit;
    }

    public BiPredicate<byte[], byte[]> getPredicate() {
        return this.predicate;
    }

    public void setStart(byte[] start) {
        this.start = start;
    }

    public void setEnd(byte[] end) {
        this.end = end;
    }

    public void setStartInclusive(boolean startInclusive) {
        this.startInclusive = startInclusive;
    }

    public void setEndInclusive(boolean endInclusive) {
        this.endInclusive = endInclusive;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setPredicate(BiPredicate<byte[], byte[]> predicate) {
        this.predicate = predicate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KvRange)) {
            return false;
        }
        KvRange other = (KvRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStartInclusive() != other.isStartInclusive()) {
            return false;
        }
        if (this.isEndInclusive() != other.isEndInclusive()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (!Arrays.equals(this.getStart(), other.getStart())) {
            return false;
        }
        if (!Arrays.equals(this.getEnd(), other.getEnd())) {
            return false;
        }
        BiPredicate<byte[], byte[]> this$predicate = this.getPredicate();
        BiPredicate<byte[], byte[]> other$predicate = other.getPredicate();
        return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KvRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStartInclusive() ? 79 : 97);
        result = result * 59 + (this.isEndInclusive() ? 79 : 97);
        result = result * 59 + this.getLimit();
        result = result * 59 + Arrays.hashCode(this.getStart());
        result = result * 59 + Arrays.hashCode(this.getEnd());
        BiPredicate<byte[], byte[]> $predicate = this.getPredicate();
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        return result;
    }

    public String toString() {
        return "KvRange(start=" + Arrays.toString(this.getStart()) + ", end=" + Arrays.toString(this.getEnd()) + ", startInclusive=" + this.isStartInclusive() + ", endInclusive=" + this.isEndInclusive() + ", limit=" + this.getLimit() + ", predicate=" + this.getPredicate() + ")";
    }

    public static class KvRangeBuilder {
        private byte[] start;
        private byte[] end;
        private boolean startInclusive;
        private boolean endInclusive;
        private int limit;
        private BiPredicate<byte[], byte[]> predicate;

        KvRangeBuilder() {
        }

        public KvRangeBuilder start(byte[] start) {
            this.start = start;
            return this;
        }

        public KvRangeBuilder end(byte[] end) {
            this.end = end;
            return this;
        }

        public KvRangeBuilder startInclusive(boolean startInclusive) {
            this.startInclusive = startInclusive;
            return this;
        }

        public KvRangeBuilder endInclusive(boolean endInclusive) {
            this.endInclusive = endInclusive;
            return this;
        }

        public KvRangeBuilder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public KvRangeBuilder predicate(BiPredicate<byte[], byte[]> predicate) {
            this.predicate = predicate;
            return this;
        }

        public KvRange build() {
            return new KvRange(this.start, this.end, this.startInclusive, this.endInclusive, this.limit, this.predicate);
        }

        public String toString() {
            return "KvRange.KvRangeBuilder(start=" + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + ", startInclusive=" + this.startInclusive + ", endInclusive=" + this.endInclusive + ", limit=" + this.limit + ", predicate=" + this.predicate + ")";
        }
    }
}

