/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.memory.MemorySegment;
import sun.misc.Unsafe;

public class BinaryRowDataUtil {
    public static final Unsafe UNSAFE = MemorySegment.UNSAFE;
    public static final int BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    public static final BinaryRow EMPTY_ROW = new BinaryRow(0);

    public static boolean byteArrayEquals(byte[] left, byte[] right, int length) {
        return BinaryRowDataUtil.byteArrayEquals(left, BYTE_ARRAY_BASE_OFFSET, right, BYTE_ARRAY_BASE_OFFSET, length);
    }

    public static boolean byteArrayEquals(Object left, long leftOffset, Object right, long rightOffset, int length) {
        int i;
        for (i = 0; i <= length - 8; i += 8) {
            if (UNSAFE.getLong(left, leftOffset + (long)i) == UNSAFE.getLong(right, rightOffset + (long)i)) continue;
            return false;
        }
        while (i < length) {
            if (UNSAFE.getByte(left, leftOffset + (long)i) != UNSAFE.getByte(right, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        int size = EMPTY_ROW.getFixedLengthPartSize();
        byte[] bytes = new byte[size];
        EMPTY_ROW.pointTo(MemorySegment.wrap(bytes), 0, size);
    }
}

