/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.nio.ByteBuffer;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.util.ByteBuffers;

class BaseEncryptionKeyMetadata
implements EncryptionKeyMetadata {
    private final ByteBuffer keyMetadata;

    public static EncryptionKeyMetadata fromKeyMetadata(ByteBuffer keyMetadata) {
        if (keyMetadata == null) {
            return EncryptionKeyMetadata.empty();
        }
        return new BaseEncryptionKeyMetadata(keyMetadata);
    }

    public static EncryptionKeyMetadata fromByteArray(byte[] keyMetadata) {
        if (keyMetadata == null) {
            return EncryptionKeyMetadata.empty();
        }
        return BaseEncryptionKeyMetadata.fromKeyMetadata(ByteBuffer.wrap(keyMetadata));
    }

    private BaseEncryptionKeyMetadata(ByteBuffer keyMetadata) {
        this.keyMetadata = keyMetadata;
    }

    public ByteBuffer buffer() {
        return this.keyMetadata;
    }

    public EncryptionKeyMetadata copy() {
        return new BaseEncryptionKeyMetadata(ByteBuffers.copy((ByteBuffer)this.keyMetadata));
    }
}

