/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonCatalogBackend;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonCatalogPropertiesMetadata;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.AuthenticationConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos.KerberosClient;
import org.apache.gravitino.catalog.lakehouse.paimon.ops.PaimonBackendCatalogWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.options.Options;

public class CatalogUtils {
    private CatalogUtils() {
    }

    public static PaimonBackendCatalogWrapper loadCatalogBackend(PaimonConfig paimonConfig) {
        Map allConfig = paimonConfig.getAllConfig();
        AuthenticationConfig authenticationConfig = new AuthenticationConfig(allConfig);
        if (authenticationConfig.isSimpleAuth()) {
            return new PaimonBackendCatalogWrapper(CatalogUtils.loadCatalogBackendWithSimpleAuth(paimonConfig), null);
        }
        if (authenticationConfig.isKerberosAuth()) {
            Configuration configuration = new Configuration();
            allConfig.forEach((arg_0, arg_1) -> ((Configuration)configuration).set(arg_0, arg_1));
            configuration.set("hadoop.security.authorization", "true");
            configuration.set("hadoop.security.authentication", "kerberos");
            try {
                KerberosClient kerberosClient = new KerberosClient(allConfig, configuration);
                File keytabFile = kerberosClient.saveKeyTabFileFromUri(UUID.randomUUID().toString().replace("-", ""));
                kerberosClient.login(keytabFile.getAbsolutePath());
                Catalog catalog = CatalogUtils.loadCatalogBackendWithKerberosAuth(paimonConfig, configuration);
                return new PaimonBackendCatalogWrapper(catalog, kerberosClient);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to login with kerberos", e);
            }
        }
        throw new UnsupportedOperationException("Unsupported authentication method: " + authenticationConfig.getAuthType());
    }

    public static Catalog loadCatalogBackendWithKerberosAuth(PaimonConfig paimonConfig, Configuration configuration) {
        CatalogUtils.checkPaimonConfig(paimonConfig);
        Preconditions.checkArgument((boolean)PaimonCatalogBackend.FILESYSTEM.name().equalsIgnoreCase((String)paimonConfig.get(PaimonConfig.CATALOG_BACKEND)));
        CatalogContext catalogContext = CatalogContext.create((Options)Options.fromMap((Map)paimonConfig.getAllConfig()), (Configuration)configuration);
        return CatalogFactory.createCatalog((CatalogContext)catalogContext);
    }

    public static Catalog loadCatalogBackendWithSimpleAuth(PaimonConfig paimonConfig) {
        CatalogUtils.checkPaimonConfig(paimonConfig);
        CatalogContext catalogContext = CatalogContext.create((Options)Options.fromMap((Map)paimonConfig.getAllConfig()));
        return CatalogFactory.createCatalog((CatalogContext)catalogContext);
    }

    private static void checkPaimonConfig(PaimonConfig paimonConfig) {
        String metastore = (String)paimonConfig.get(PaimonConfig.CATALOG_BACKEND);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metastore), (Object)"Paimon Catalog metastore can not be null or empty.");
        String warehouse = (String)paimonConfig.get(PaimonConfig.CATALOG_WAREHOUSE);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)warehouse), (Object)"Paimon Catalog warehouse can not be null or empty.");
        if (!PaimonCatalogBackend.FILESYSTEM.name().equalsIgnoreCase(metastore)) {
            String uri = (String)paimonConfig.get(PaimonConfig.CATALOG_URI);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"Paimon Catalog uri can not be null or empty.");
        }
        if (PaimonCatalogBackend.JDBC.name().equalsIgnoreCase(metastore)) {
            String driverClassName = paimonConfig.getJdbcDriver();
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Couldn't load jdbc driver " + driverClassName);
            }
        }
    }

    public static Map<String, String> toInnerProperty(Map<String, String> properties, boolean keepUnknown) {
        HashMap<String, String> gravitinoConfig = new HashMap<String, String>();
        properties.forEach((key, value) -> {
            if (PaimonCatalogPropertiesMetadata.GRAVITINO_CONFIG_TO_PAIMON.containsKey(key)) {
                gravitinoConfig.put(PaimonCatalogPropertiesMetadata.GRAVITINO_CONFIG_TO_PAIMON.get(key), (String)value);
            } else if (PaimonCatalogPropertiesMetadata.KERBEROS_CONFIGURATION.containsKey(key)) {
                gravitinoConfig.put(PaimonCatalogPropertiesMetadata.KERBEROS_CONFIGURATION.get(key), (String)value);
            } else if (PaimonCatalogPropertiesMetadata.S3_CONFIGURATION.containsKey(key)) {
                gravitinoConfig.put(PaimonCatalogPropertiesMetadata.S3_CONFIGURATION.get(key), (String)value);
            } else if (PaimonCatalogPropertiesMetadata.OSS_CONFIGURATION.containsKey(key)) {
                gravitinoConfig.put(PaimonCatalogPropertiesMetadata.OSS_CONFIGURATION.get(key), (String)value);
            } else if (keepUnknown) {
                gravitinoConfig.put((String)key, (String)value);
            }
        });
        return gravitinoConfig;
    }
}

