/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.operation;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.jdbc.JdbcSchema;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.operation.DatabaseOperation;
import org.apache.gravitino.catalog.jdbc.utils.JdbcConnectorUtils;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcDatabaseOperations
implements DatabaseOperation {
    public static final Logger LOG = LoggerFactory.getLogger(JdbcDatabaseOperations.class);
    protected DataSource dataSource;
    protected JdbcExceptionConverter exceptionMapper;

    @Override
    public void initialize(DataSource dataSource, JdbcExceptionConverter exceptionMapper, Map<String, String> conf) {
        this.dataSource = dataSource;
        this.exceptionMapper = exceptionMapper;
    }

    @Override
    public void create(String databaseName, String comment, Map<String, String> properties) throws SchemaAlreadyExistsException {
        LOG.info("Beginning to create database {}", (Object)databaseName);
        String originComment = StringIdentifier.removeIdFromComment((String)comment);
        if (!this.supportSchemaComment() && StringUtils.isNotEmpty((CharSequence)originComment)) {
            throw new UnsupportedOperationException("Doesn't support setting schema comment: " + originComment);
        }
        try (Connection connection = this.getConnection();){
            JdbcConnectorUtils.executeUpdate(connection, this.generateCreateDatabaseSql(databaseName, comment, properties));
            LOG.info("Finished creating database {}", (Object)databaseName);
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    @Override
    public boolean delete(String databaseName, boolean cascade) {
        LOG.info("Beginning to drop database {}", (Object)databaseName);
        try {
            this.dropDatabase(databaseName, cascade);
            LOG.info("Finished dropping database {}", (Object)databaseName);
        }
        catch (NoSuchSchemaException e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> listDatabases() {
        ArrayList<String> databaseNames = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getCatalogs();
            while (resultSet.next()) {
                String databaseName = resultSet.getString("TABLE_CAT");
                if (this.isSystemDatabase(databaseName)) continue;
                databaseNames.add(databaseName);
            }
            ArrayList<String> arrayList = databaseNames;
            return arrayList;
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    protected void dropDatabase(String databaseName, boolean cascade) {
        try (Connection connection = this.getConnection();){
            JdbcConnectorUtils.executeUpdate(connection, this.generateDropDatabaseSql(databaseName, cascade));
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    protected String generateCreateDatabaseSql(String databaseName, String comment, Map<String, String> properties) {
        String createDatabaseSql = String.format("CREATE DATABASE `%s`", databaseName);
        if (MapUtils.isNotEmpty(properties)) {
            throw new UnsupportedOperationException("Properties are not supported yet.");
        }
        LOG.info("Generated create database:{} sql: {}", (Object)databaseName, (Object)createDatabaseSql);
        return createDatabaseSql;
    }

    protected String generateDropDatabaseSql(String databaseName, boolean cascade) {
        String dropDatabaseSql = String.format("DROP DATABASE `%s`", databaseName);
        if (cascade) {
            return dropDatabaseSql;
        }
        try (Connection connection = this.dataSource.getConnection();){
            String query = String.format("SHOW TABLES IN `%s`", databaseName);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(query);){
                if (resultSet.next()) {
                    throw new IllegalStateException(String.format("Database %s is not empty, the value of cascade should be true.", databaseName));
                }
            }
        }
        catch (SQLException sqlException) {
            throw this.exceptionMapper.toGravitinoException(sqlException);
        }
        return dropDatabaseSql;
    }

    @Override
    public JdbcSchema load(String databaseName) throws NoSuchSchemaException {
        List<String> allDatabases = this.listDatabases();
        String dbName = allDatabases.stream().filter(db -> db.equals(databaseName)).findFirst().orElseThrow(() -> new NoSuchSchemaException("Database %s could not be found", new Object[]{databaseName}));
        return (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withName(dbName)).withProperties((Map)ImmutableMap.of())).withAuditInfo(AuditInfo.EMPTY)).build();
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected boolean isSystemDatabase(String dbName) {
        return this.createSysDatabaseNameSet().contains(dbName.toLowerCase(Locale.ROOT));
    }

    protected abstract boolean supportSchemaComment();

    protected abstract Set<String> createSysDatabaseNameSet();
}

