/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.PartitionIndex;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashBucketAssigner
implements BucketAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(HashBucketAssigner.class);
    private final SnapshotManager snapshotManager;
    private final String commitUser;
    private final IndexFileHandler indexFileHandler;
    private final int numChannels;
    private final int numAssigners;
    private final int assignId;
    private final long targetBucketRowNumber;
    private final Map<BinaryRow, PartitionIndex> partitionIndex;

    public HashBucketAssigner(SnapshotManager snapshotManager, String commitUser, IndexFileHandler indexFileHandler, int numChannels, int numAssigners, int assignId, long targetBucketRowNumber) {
        this.snapshotManager = snapshotManager;
        this.commitUser = commitUser;
        this.indexFileHandler = indexFileHandler;
        this.numChannels = numChannels;
        this.numAssigners = numAssigners;
        this.assignId = assignId;
        this.targetBucketRowNumber = targetBucketRowNumber;
        this.partitionIndex = new HashMap<BinaryRow, PartitionIndex>();
    }

    @Override
    public int assign(BinaryRow partition, int hash) {
        int partitionHash = partition.hashCode();
        int recordAssignId = this.computeAssignId(partitionHash, hash);
        Preconditions.checkArgument((recordAssignId == this.assignId ? 1 : 0) != 0, (String)"This is a bug, record assign id %s should equal to assign id %s.", (Object[])new Object[]{recordAssignId, this.assignId});
        PartitionIndex index = this.partitionIndex.get(partition);
        if (index == null) {
            partition = partition.copy();
            index = this.loadIndex(partition, partitionHash);
            this.partitionIndex.put(partition, index);
        }
        int assigned = index.assign(hash, this::isMyBucket);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Assign " + assigned + " to the partition " + partition + " key hash " + hash);
        }
        return assigned;
    }

    @Override
    public void prepareCommit(long commitIdentifier) {
        long latestCommittedIdentifier = this.partitionIndex.values().stream().mapToLong(i -> i.lastAccessedCommitIdentifier).max().orElse(Long.MIN_VALUE) == Long.MIN_VALUE ? Long.MIN_VALUE : this.snapshotManager.latestSnapshotOfUser(this.commitUser).map(Snapshot::commitIdentifier).orElse(Long.MIN_VALUE);
        Iterator<Map.Entry<BinaryRow, PartitionIndex>> iterator = this.partitionIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BinaryRow, PartitionIndex> entry = iterator.next();
            BinaryRow partition = entry.getKey();
            PartitionIndex index = entry.getValue();
            if (index.accessed) {
                index.lastAccessedCommitIdentifier = commitIdentifier;
            } else if (index.lastAccessedCommitIdentifier <= latestCommittedIdentifier) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing index for partition {}. Index's last accessed identifier is {}, while latest committed identifier is {}, current commit identifier is {}.", new Object[]{partition, index.lastAccessedCommitIdentifier, latestCommittedIdentifier, commitIdentifier});
                }
                iterator.remove();
            }
            index.accessed = false;
        }
    }

    @VisibleForTesting
    Set<BinaryRow> currentPartitions() {
        return this.partitionIndex.keySet();
    }

    private int computeAssignId(int partitionHash, int keyHash) {
        return BucketAssigner.computeAssigner(partitionHash, keyHash, this.numChannels, this.numAssigners);
    }

    private boolean isMyBucket(int bucket) {
        return bucket % this.numAssigners == this.assignId % this.numAssigners;
    }

    private PartitionIndex loadIndex(BinaryRow partition, int partitionHash) {
        return PartitionIndex.loadIndex(this.indexFileHandler, partition, this.targetBucketRowNumber, hash -> this.computeAssignId(partitionHash, hash) == this.assignId, this::isMyBucket);
    }
}

