/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.converter;

import java.util.Objects;
import org.apache.gravitino.connector.DataTypeConverter;

public abstract class JdbcTypeConverter
implements DataTypeConverter<String, JdbcTypeBean> {
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String TIMESTAMP = "timestamp";
    public static final String VARCHAR = "varchar";
    public static final String TEXT = "text";

    public static class JdbcTypeBean {
        private String typeName;
        private String columnSize;
        private String scale;

        public JdbcTypeBean(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getColumnSize() {
            return this.columnSize;
        }

        public void setColumnSize(String columnSize) {
            this.columnSize = columnSize;
        }

        public String getScale() {
            return this.scale;
        }

        public void setScale(String scale) {
            this.scale = scale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JdbcTypeBean)) {
                return false;
            }
            JdbcTypeBean typeBean = (JdbcTypeBean)o;
            return Objects.equals(this.typeName, typeBean.typeName) && Objects.equals(this.columnSize, typeBean.columnSize) && Objects.equals(this.scale, typeBean.scale);
        }

        public int hashCode() {
            return Objects.hash(this.typeName, this.columnSize, this.scale);
        }

        public String toString() {
            return "JdbcTypeBean{typeName='" + this.typeName + '\'' + ", columnSize='" + this.columnSize + '\'' + ", scale='" + this.scale + '\'' + '}';
        }
    }
}

