/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.mysql.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class MysqlTableOperations
extends JdbcTableOperations {
    private static final String BACK_QUOTE = "`";
    private static final String MYSQL_AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG = "Mysql does not support nested column names.";

    protected String generateCreateTableSql(String tableName, JdbcColumn[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, Index[] indexes) {
        if (ArrayUtils.isNotEmpty((Object[])partitioning)) {
            throw new UnsupportedOperationException("Currently we do not support Partitioning in mysql");
        }
        Preconditions.checkArgument((boolean)Distributions.NONE.equals(distribution), (Object)"MySQL does not support distribution");
        MysqlTableOperations.validateIncrementCol((JdbcColumn[])columns, (Index[])indexes);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE TABLE ").append(BACK_QUOTE).append(tableName).append(BACK_QUOTE).append(" (\n");
        for (int i = 0; i < columns.length; ++i) {
            JdbcColumn column = columns[i];
            sqlBuilder.append(" ").append(" ").append(BACK_QUOTE).append(column.name()).append(BACK_QUOTE);
            this.appendColumnDefinition(column, sqlBuilder);
            if (i >= columns.length - 1) continue;
            sqlBuilder.append(",\n");
        }
        MysqlTableOperations.appendIndexesSql(indexes, sqlBuilder);
        sqlBuilder.append("\n)");
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            sqlBuilder.append(" COMMENT='").append(comment).append("'");
        }
        if (MapUtils.isNotEmpty(properties)) {
            sqlBuilder.append(properties.entrySet().stream().map(entry -> String.format("%s = %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n", "\n", "")));
        }
        String result = sqlBuilder.append(";").toString();
        LOG.info("Generated create table:{} sql: {}", (Object)tableName, (Object)result);
        return result;
    }

    public static void appendIndexesSql(Index[] indexes, StringBuilder sqlBuilder) {
        block4: for (Index index : indexes) {
            String fieldStr = MysqlTableOperations.getIndexFieldStr((String[][])index.fieldNames());
            sqlBuilder.append(",\n");
            switch (index.type()) {
                case PRIMARY_KEY: {
                    if (null != index.name() && !StringUtils.equalsIgnoreCase((CharSequence)index.name(), (CharSequence)"PRIMARY")) {
                        throw new IllegalArgumentException("Primary key name must be PRIMARY in MySQL");
                    }
                    sqlBuilder.append("CONSTRAINT ").append("PRIMARY KEY (").append(fieldStr).append(")");
                    continue block4;
                }
                case UNIQUE_KEY: {
                    sqlBuilder.append("CONSTRAINT ");
                    if (null != index.name()) {
                        sqlBuilder.append(BACK_QUOTE).append(index.name()).append(BACK_QUOTE);
                    }
                    sqlBuilder.append(" UNIQUE (").append(fieldStr).append(")");
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("MySQL doesn't support index : " + index.type());
                }
            }
        }
    }

    protected boolean getAutoIncrementInfo(ResultSet resultSet) throws SQLException {
        return "YES".equalsIgnoreCase(resultSet.getString("IS_AUTOINCREMENT"));
    }

    /*
     * Exception decompiling
     */
    protected Map<String, String> getTableProperties(Connection connection, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void correctJdbcTableFields(Connection connection, String databaseName, String tableName, JdbcTable.Builder tableBuilder) throws SQLException {
        if (StringUtils.isEmpty((CharSequence)tableBuilder.comment())) {
            LOG.warn("Not found comment in mysql driver api. Will try to get comment from sql");
            tableBuilder.withComment(tableBuilder.properties().getOrDefault("COMMENT", tableBuilder.comment()));
        }
    }

    protected String generatePurgeTableSql(String tableName) {
        throw new UnsupportedOperationException("MySQL does not support purge table in Gravitino, please use drop table");
    }

    protected String generateAlterTableSql(String databaseName, String tableName, TableChange ... changes) {
        JdbcTable lazyLoadTable = null;
        TableChange.UpdateComment updateComment = null;
        ArrayList<TableChange.SetProperty> setProperties = new ArrayList<TableChange.SetProperty>();
        ArrayList<String> alterSql = new ArrayList<String>();
        for (int i = 0; i < changes.length; ++i) {
            TableChange change = changes[i];
            if (change instanceof TableChange.UpdateComment) {
                updateComment = (TableChange.UpdateComment)change;
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                setProperties.add((TableChange.SetProperty)change);
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                throw new IllegalArgumentException("Remove property is not supported yet");
            }
            if (change instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.addColumnFieldDefinition(addColumn));
                continue;
            }
            if (change instanceof TableChange.RenameColumn) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)change;
                alterSql.add(this.renameColumnFieldDefinition(renameColumn, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnDefaultValue) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.UpdateColumnDefaultValue updateColumnDefaultValue = (TableChange.UpdateColumnDefaultValue)change;
                alterSql.add(this.updateColumnDefaultValueFieldDefinition(updateColumnDefaultValue, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnType) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)change;
                alterSql.add(this.updateColumnTypeFieldDefinition(updateColumnType, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnComment) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)change;
                alterSql.add(this.updateColumnCommentFieldDefinition(updateColumnComment, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnPosition) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)change;
                alterSql.add(this.updateColumnPositionFieldDefinition(updateColumnPosition, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)change;
                String deleteColSql = this.deleteColumnFieldDefinition(deleteColumn, lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable));
                if (!StringUtils.isNotEmpty((CharSequence)deleteColSql)) continue;
                alterSql.add(deleteColSql);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnNullability) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.updateColumnNullabilityDefinition((TableChange.UpdateColumnNullability)change, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.AddIndex) {
                alterSql.add(MysqlTableOperations.addIndexDefinition((TableChange.AddIndex)change));
                continue;
            }
            if (change instanceof TableChange.DeleteIndex) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(MysqlTableOperations.deleteIndexDefinition(lazyLoadTable, (TableChange.DeleteIndex)change));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnAutoIncrement) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.updateColumnAutoIncrementDefinition(lazyLoadTable, (TableChange.UpdateColumnAutoIncrement)change));
                continue;
            }
            throw new IllegalArgumentException("Unsupported table change type: " + change.getClass().getName());
        }
        if (!setProperties.isEmpty()) {
            alterSql.add(this.generateTableProperties(setProperties));
        }
        if (null != updateComment) {
            JdbcTable jdbcTable;
            StringIdentifier identifier;
            String newComment = updateComment.getNewComment();
            if (null == StringIdentifier.fromComment((String)newComment) && null != (identifier = StringIdentifier.fromComment((String)(jdbcTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable)).comment()))) {
                newComment = StringIdentifier.addToComment((StringIdentifier)identifier, (String)newComment);
            }
            alterSql.add("COMMENT '" + newComment + "'");
        }
        if (!setProperties.isEmpty()) {
            alterSql.add(this.generateTableProperties(setProperties));
        }
        if (CollectionUtils.isEmpty(alterSql)) {
            return "";
        }
        String result = "ALTER TABLE `" + tableName + "`\n" + String.join((CharSequence)",\n", alterSql) + ";";
        LOG.info("Generated alter table:{} sql: {}", (Object)(databaseName + "." + tableName), (Object)result);
        return result;
    }

    private String updateColumnAutoIncrementDefinition(JdbcTable table, TableChange.UpdateColumnAutoIncrement change) {
        if (change.fieldName().length > 1) {
            throw new UnsupportedOperationException("Nested column names are not supported");
        }
        String col = change.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(table, col);
        if (change.isAutoIncrement()) {
            Preconditions.checkArgument((boolean)Types.allowAutoIncrement((Type)column.dataType()), (Object)("Auto increment is not allowed, type: " + column.dataType()));
        }
        JdbcColumn updateColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withDefaultValue(column.defaultValue())).withNullable(column.nullable())).withType(column.dataType())).withComment(column.comment())).withAutoIncrement(change.isAutoIncrement())).build();
        return "MODIFY COLUMN `" + col + BACK_QUOTE + this.appendColumnDefinition(updateColumn, new StringBuilder());
    }

    @VisibleForTesting
    static String deleteIndexDefinition(JdbcTable lazyLoadTable, TableChange.DeleteIndex deleteIndex) {
        if (deleteIndex.isIfExists() && Arrays.stream(lazyLoadTable.index()).anyMatch(index -> index.name().equals(deleteIndex.getName()))) {
            throw new IllegalArgumentException("Index does not exist");
        }
        return "DROP INDEX `" + deleteIndex.getName() + BACK_QUOTE;
    }

    private String updateColumnNullabilityDefinition(TableChange.UpdateColumnNullability change, JdbcTable table) {
        this.validateUpdateColumnNullable(change, table);
        String col = change.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(table, col);
        JdbcColumn updateColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withDefaultValue(column.defaultValue())).withNullable(change.nullable())).withType(column.dataType())).withComment(column.comment())).withAutoIncrement(column.autoIncrement())).build();
        return "MODIFY COLUMN `" + col + BACK_QUOTE + this.appendColumnDefinition(updateColumn, new StringBuilder());
    }

    @VisibleForTesting
    static String addIndexDefinition(TableChange.AddIndex addIndex) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("ADD ");
        switch (addIndex.getType()) {
            case PRIMARY_KEY: {
                if (null != addIndex.getName() && !StringUtils.equalsIgnoreCase((CharSequence)addIndex.getName(), (CharSequence)"PRIMARY")) {
                    throw new IllegalArgumentException("Primary key name must be PRIMARY in MySQL");
                }
                sqlBuilder.append("PRIMARY KEY ");
                break;
            }
            case UNIQUE_KEY: {
                sqlBuilder.append("UNIQUE INDEX ").append(BACK_QUOTE).append(addIndex.getName()).append(BACK_QUOTE);
                break;
            }
        }
        sqlBuilder.append(" (").append(MysqlTableOperations.getIndexFieldStr((String[][])addIndex.getFieldNames())).append(")");
        return sqlBuilder.toString();
    }

    private String generateTableProperties(List<TableChange.SetProperty> setProperties) {
        return setProperties.stream().map(setProperty -> String.format("%s = %s", setProperty.getProperty(), setProperty.getValue())).collect(Collectors.joining(",\n"));
    }

    private String updateColumnCommentFieldDefinition(TableChange.UpdateColumnComment updateColumnComment, JdbcTable jdbcTable) {
        String newComment = updateColumnComment.getNewComment();
        if (updateColumnComment.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnComment.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        JdbcColumn updateColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withDefaultValue(column.defaultValue())).withNullable(column.nullable())).withType(column.dataType())).withComment(newComment)).withAutoIncrement(column.autoIncrement())).build();
        return "MODIFY COLUMN `" + col + BACK_QUOTE + this.appendColumnDefinition(updateColumn, new StringBuilder());
    }

    private String addColumnFieldDefinition(TableChange.AddColumn addColumn) {
        String dataType = (String)this.typeConverter.fromGravitino(addColumn.getDataType());
        if (addColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = addColumn.fieldName()[0];
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append("ADD COLUMN ").append(BACK_QUOTE).append(col).append(BACK_QUOTE).append(" ").append(dataType).append(" ");
        if (addColumn.isAutoIncrement()) {
            Preconditions.checkArgument((boolean)Types.allowAutoIncrement((Type)addColumn.getDataType()), (Object)("Auto increment is not allowed, type: " + addColumn.getDataType()));
            columnDefinition.append(MYSQL_AUTO_INCREMENT).append(" ");
        }
        if (!addColumn.isNullable()) {
            columnDefinition.append("NOT NULL ");
        }
        if (StringUtils.isNotEmpty((CharSequence)addColumn.getComment())) {
            columnDefinition.append("COMMENT '").append(addColumn.getComment()).append("' ");
        }
        if (!Column.DEFAULT_VALUE_NOT_SET.equals(addColumn.getDefaultValue())) {
            columnDefinition.append("DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(addColumn.getDefaultValue())).append(" ");
        }
        if (addColumn.getPosition() instanceof TableChange.First) {
            columnDefinition.append("FIRST");
        } else if (addColumn.getPosition() instanceof TableChange.After) {
            TableChange.After afterPosition = (TableChange.After)addColumn.getPosition();
            columnDefinition.append("AFTER ").append(BACK_QUOTE).append(afterPosition.getColumn()).append(BACK_QUOTE);
        } else if (!(addColumn.getPosition() instanceof TableChange.Default)) {
            throw new IllegalArgumentException("Invalid column position.");
        }
        return columnDefinition.toString();
    }

    private String renameColumnFieldDefinition(TableChange.RenameColumn renameColumn, JdbcTable jdbcTable) {
        if (renameColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String oldColumnName = renameColumn.fieldName()[0];
        String newColumnName = renameColumn.getNewName();
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, oldColumnName);
        StringBuilder sqlBuilder = new StringBuilder("CHANGE COLUMN `" + oldColumnName + BACK_QUOTE + " " + BACK_QUOTE + newColumnName + BACK_QUOTE);
        JdbcColumn newColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(newColumnName)).withType(column.dataType())).withComment(column.comment())).withDefaultValue(column.defaultValue())).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).build();
        return this.appendColumnDefinition(newColumn, sqlBuilder).toString();
    }

    private String updateColumnPositionFieldDefinition(TableChange.UpdateColumnPosition updateColumnPosition, JdbcTable jdbcTable) {
        if (updateColumnPosition.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnPosition.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append("MODIFY COLUMN ").append(MysqlTableOperations.quote(col));
        this.appendColumnDefinition(column, columnDefinition);
        if (updateColumnPosition.getPosition() instanceof TableChange.First) {
            columnDefinition.append("FIRST");
        } else if (updateColumnPosition.getPosition() instanceof TableChange.After) {
            TableChange.After afterPosition = (TableChange.After)updateColumnPosition.getPosition();
            columnDefinition.append("AFTER ").append(afterPosition.getColumn());
        } else {
            Arrays.stream(jdbcTable.columns()).reduce((column1, column2) -> column2).map(Column::name).ifPresent(s -> columnDefinition.append("AFTER ").append((String)s));
        }
        return columnDefinition.toString();
    }

    private String deleteColumnFieldDefinition(TableChange.DeleteColumn deleteColumn, JdbcTable jdbcTable) {
        if (deleteColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = deleteColumn.fieldName()[0];
        boolean colExists = true;
        try {
            this.getJdbcColumnFromTable(jdbcTable, col);
        }
        catch (NoSuchColumnException noSuchColumnException) {
            colExists = false;
        }
        if (!colExists) {
            if (BooleanUtils.isTrue((Boolean)deleteColumn.getIfExists())) {
                return "";
            }
            throw new IllegalArgumentException("Delete column does not exist: " + col);
        }
        return "DROP COLUMN `" + col + BACK_QUOTE;
    }

    private String updateColumnDefaultValueFieldDefinition(TableChange.UpdateColumnDefaultValue updateColumnDefaultValue, JdbcTable jdbcTable) {
        if (updateColumnDefaultValue.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnDefaultValue.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder sqlBuilder = new StringBuilder("MODIFY COLUMN " + MysqlTableOperations.quote(col));
        JdbcColumn newColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withType(column.dataType())).withNullable(column.nullable())).withComment(column.comment())).withDefaultValue(updateColumnDefaultValue.getNewDefaultValue())).build();
        return this.appendColumnDefinition(newColumn, sqlBuilder).toString();
    }

    private String updateColumnTypeFieldDefinition(TableChange.UpdateColumnType updateColumnType, JdbcTable jdbcTable) {
        if (updateColumnType.fieldName().length > 1) {
            throw new UnsupportedOperationException(MYSQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnType.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder sqlBuilder = new StringBuilder("MODIFY COLUMN " + MysqlTableOperations.quote(col));
        JdbcColumn newColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withType(updateColumnType.getNewDataType())).withComment(column.comment())).withDefaultValue(Column.DEFAULT_VALUE_NOT_SET)).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).build();
        return this.appendColumnDefinition(newColumn, sqlBuilder).toString();
    }

    private StringBuilder appendColumnDefinition(JdbcColumn column, StringBuilder sqlBuilder) {
        sqlBuilder.append(" ").append((String)this.typeConverter.fromGravitino(column.dataType())).append(" ");
        if (column.nullable()) {
            sqlBuilder.append("NULL ");
        } else {
            sqlBuilder.append("NOT NULL ");
        }
        if (!Column.DEFAULT_VALUE_NOT_SET.equals(column.defaultValue())) {
            sqlBuilder.append("DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(column.defaultValue())).append(" ");
        }
        if (column.autoIncrement()) {
            sqlBuilder.append(MYSQL_AUTO_INCREMENT).append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)column.comment())) {
            sqlBuilder.append("COMMENT '").append(column.comment()).append("' ");
        }
        return sqlBuilder;
    }

    private static String quote(String name) {
        return BACK_QUOTE + name + BACK_QUOTE;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

