/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.utils.StringUtils;

public class RetryingMetaStoreClientFactory {
    private static final Map<Class<?>[], HiveMetastoreProxySupplier> PROXY_SUPPLIERS = ImmutableMap.builder().put((Object)new Class[]{HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName)).put((Object)new Class[]{HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true)).put((Object)new Class[]{Configuration.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true)).put((Object)new Class[]{Configuration.class, Class[].class, Object[].class, ConcurrentHashMap.class, String.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, new Class[]{HiveConf.class, HiveMetaHookLoader.class, Boolean.class}, new Object[]{hiveConf, tbl -> null, true}, new ConcurrentHashMap(), clientClassName)).build();
    private static final Map<Class<?>[], HiveMetastoreProxySupplier> PROXY_SUPPLIERS_SHADED = ImmutableMap.builder().put((Object)new Class[]{HiveConf.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf)).put((Object)new Class[]{HiveConf.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, true)).put((Object)new Class[]{Configuration.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, true)).build();

    public IMetaStoreClient createClient(HiveConf hiveConf, String clientClassName) {
        LinkedHashMap<Class<?>[], HiveMetastoreProxySupplier> suppliers = new LinkedHashMap<Class<?>[], HiveMetastoreProxySupplier>(PROXY_SUPPLIERS);
        if (HiveMetaStoreClient.class.getName().equals(clientClassName)) {
            suppliers.putAll(PROXY_SUPPLIERS_SHADED);
        }
        RuntimeException failToCreate = new RuntimeException("Failed to create the desired metastore client (class name: " + clientClassName + ")");
        for (Map.Entry entry : suppliers.entrySet()) {
            Class[] classes = (Class[])entry.getKey();
            try {
                Method getProxy = RetryingMetaStoreClient.class.getMethod("getProxy", classes);
                HiveMetastoreProxySupplier supplier = (HiveMetastoreProxySupplier)entry.getValue();
                IMetaStoreClient client = supplier.get(getProxy, (Configuration)hiveConf, clientClassName);
                return StringUtils.isNullOrWhitespaceOnly((String)hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)) ? client : HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)client);
            }
            catch (Exception e) {
                failToCreate.addSuppressed(e);
            }
        }
        throw failToCreate;
    }

    public static interface HiveMetastoreProxySupplier {
        public IMetaStoreClient get(Method var1, Configuration var2, String var3) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

