/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.ParquetReadOptions;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.paimon.shade.org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.paimon.shade.org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.paimon.shade.org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.paimon.shade.org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.paimon.shade.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.paimon.shade.org.apache.parquet.hadoop.util.HadoopCodecs;

public class HadoopReadOptions
extends ParquetReadOptions {
    private final Configuration conf;
    private static final String ALLOCATION_SIZE = "parquet.read.allocation.size";

    private HadoopReadOptions(boolean useSignedStringMinMax, boolean useStatsFilter, boolean useDictionaryFilter, boolean useRecordFilter, boolean useColumnIndexFilter, boolean usePageChecksumVerification, boolean useBloomFilter, FilterCompat.Filter recordFilter, ParquetMetadataConverter.MetadataFilter metadataFilter, CompressionCodecFactory codecFactory, ByteBufferAllocator allocator, int maxAllocationSize, Map<String, String> properties, Configuration conf, FileDecryptionProperties fileDecryptionProperties) {
        super(useSignedStringMinMax, useStatsFilter, useDictionaryFilter, useRecordFilter, useColumnIndexFilter, usePageChecksumVerification, useBloomFilter, recordFilter, metadataFilter, codecFactory, allocator, maxAllocationSize, properties, fileDecryptionProperties);
        this.conf = conf;
    }

    @Override
    public String getProperty(String property) {
        String value = super.getProperty(property);
        if (value != null) {
            return value;
        }
        return this.conf.get(property);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static Builder builder(Configuration conf) {
        return new Builder(conf);
    }

    public static Builder builder(Configuration conf, Path filePath) {
        return new Builder(conf, filePath);
    }

    private static FileDecryptionProperties createDecryptionProperties(Path file, Configuration hadoopConfig) {
        DecryptionPropertiesFactory cryptoFactory = DecryptionPropertiesFactory.loadFactory(hadoopConfig);
        if (null == cryptoFactory) {
            return null;
        }
        return cryptoFactory.getFileDecryptionProperties(hadoopConfig, file);
    }

    public static class Builder
    extends ParquetReadOptions.Builder {
        private final Configuration conf;
        private final Path filePath;

        public Builder(Configuration conf) {
            this(conf, null);
        }

        public Builder(Configuration conf, Path filePath) {
            this.conf = conf;
            this.filePath = filePath;
            this.useSignedStringMinMax(conf.getBoolean("parquet.strings.signed-min-max.enabled", false));
            this.useDictionaryFilter(conf.getBoolean("parquet.filter.dictionary.enabled", true));
            this.useStatsFilter(conf.getBoolean("parquet.filter.stats.enabled", true));
            this.useRecordFilter(conf.getBoolean("parquet.filter.record-level.enabled", true));
            this.useColumnIndexFilter(conf.getBoolean("parquet.filter.columnindex.enabled", true));
            this.usePageChecksumVerification(conf.getBoolean("parquet.page.verify-checksum.enabled", this.usePageChecksumVerification));
            this.useBloomFilter(conf.getBoolean("parquet.filter.bloom.enabled", true));
            this.withCodecFactory(HadoopCodecs.newFactory(conf, 0));
            this.withRecordFilter(ParquetInputFormat.getFilter(conf));
            this.withMaxAllocationInBytes(conf.getInt(HadoopReadOptions.ALLOCATION_SIZE, 0x800000));
            String badRecordThresh = conf.get("parquet.read.bad.record.threshold");
            if (badRecordThresh != null) {
                this.set("parquet.read.bad.record.threshold", badRecordThresh);
            }
        }

        @Override
        public ParquetReadOptions build() {
            if (null == this.fileDecryptionProperties) {
                this.fileDecryptionProperties = HadoopReadOptions.createDecryptionProperties(this.filePath, this.conf);
            }
            return new HadoopReadOptions(this.useSignedStringMinMax, this.useStatsFilter, this.useDictionaryFilter, this.useRecordFilter, this.useColumnIndexFilter, this.usePageChecksumVerification, this.useBloomFilter, this.recordFilter, this.metadataFilter, this.codecFactory, this.allocator, this.maxAllocationSize, this.properties, this.conf, this.fileDecryptionProperties);
        }
    }
}

