/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import java.util.Comparator;
import java.util.TreeSet;

public enum ApiVersion {
    V_1(1);

    private static final TreeSet<ApiVersion> VERSIONS;
    private final int version;

    private ApiVersion(int version) {
        this.version = version;
    }

    public int version() {
        return this.version;
    }

    public static ApiVersion latestVersion() {
        return VERSIONS.last();
    }

    public static boolean isSupportedVersion(int version) {
        for (ApiVersion v : ApiVersion.values()) {
            if (v.version != version) continue;
            return true;
        }
        return false;
    }

    static {
        VERSIONS = new TreeSet<ApiVersion>(Comparator.comparingInt(o -> o.version));
        VERSIONS.add(V_1);
    }
}

