/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.dto.requests.SchemaCreateRequest;
import org.apache.gravitino.dto.requests.SchemaUpdateRequest;
import org.apache.gravitino.dto.requests.SchemaUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.SchemaResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/catalogs/{catalog}/schemas")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SchemaOperations {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaOperations.class);
    private final SchemaDispatcher dispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public SchemaOperations(SchemaDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-schema.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-schema", absolute=true)
    public Response listSchemas(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog) {
        LOG.info("Received list schema request for catalog: {}.{}", (Object)metalake, (Object)catalog);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                Namespace schemaNS = NamespaceUtil.ofSchema((String)metalake, (String)catalog);
                NameIdentifier[] idents = (NameIdentifier[])TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])new String[]{metalake, catalog}), (LockType)LockType.READ, () -> this.dispatcher.listSchemas(schemaNS));
                Response response = Utils.ok(new EntityListResponse(idents));
                LOG.info("List {} schemas in catalog {}.{}", new Object[]{idents.length, metalake, catalog});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleSchemaException(OperationType.LIST, "", catalog, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-schema.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-schema", absolute=true)
    public Response createSchema(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, SchemaCreateRequest request) {
        LOG.info("Received create schema request: {}.{}.{}", new Object[]{metalake, catalog, request.getName()});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)request.getName());
                Schema schema = (Schema)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifierUtil.ofCatalog((String)metalake, (String)catalog), (LockType)LockType.WRITE, () -> this.dispatcher.createSchema(ident, request.getComment(), request.getProperties()));
                Response response = Utils.ok(new SchemaResponse(DTOConverters.toDTO((Schema)schema)));
                LOG.info("Schema created: {}.{}.{}", new Object[]{metalake, catalog, schema.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleSchemaException(OperationType.CREATE, request.getName(), catalog, e);
        }
    }

    @GET
    @Path(value="/{schema}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="load-schema.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-schema", absolute=true)
    public Response loadSchema(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema) {
        LOG.info("Received load schema request for schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema);
                Schema s = this.dispatcher.loadSchema(ident);
                Response response = Utils.ok(new SchemaResponse(DTOConverters.toDTO((Schema)s)));
                LOG.info("Schema loaded: {}.{}.{}", new Object[]{metalake, catalog, s.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleSchemaException(OperationType.LOAD, schema, catalog, e);
        }
    }

    @PUT
    @Path(value="/{schema}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-schema.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-schema", absolute=true)
    public Response alterSchema(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, SchemaUpdatesRequest request) {
        LOG.info("Received alter schema request: {}.{}.{}", new Object[]{metalake, catalog, schema});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema);
                SchemaChange[] changes = (SchemaChange[])request.getUpdates().stream().map(SchemaUpdateRequest::schemaChange).toArray(SchemaChange[]::new);
                Schema s = (Schema)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifierUtil.ofCatalog((String)metalake, (String)catalog), (LockType)LockType.WRITE, () -> this.dispatcher.alterSchema(ident, changes));
                Response response = Utils.ok(new SchemaResponse(DTOConverters.toDTO((Schema)s)));
                LOG.info("Schema altered: {}.{}.{}", new Object[]{metalake, catalog, s.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleSchemaException(OperationType.ALTER, schema, catalog, e);
        }
    }

    @DELETE
    @Path(value="/{schema}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-schema.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-schema", absolute=true)
    public Response dropSchema(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @DefaultValue(value="false") @QueryParam(value="cascade") boolean cascade) {
        LOG.info("Received drop schema request: {}.{}.{}", new Object[]{metalake, catalog, schema});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema);
                boolean dropped = (Boolean)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifierUtil.ofCatalog((String)metalake, (String)catalog), (LockType)LockType.WRITE, () -> this.dispatcher.dropSchema(ident, cascade));
                if (!dropped) {
                    LOG.warn("Fail to drop schema {} under namespace {}", (Object)schema, (Object)ident.namespace());
                }
                Response response = Utils.ok(new DropResponse(dropped));
                LOG.info("Schema dropped: {}.{}.{}", new Object[]{metalake, catalog, schema});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleSchemaException(OperationType.DROP, schema, catalog, e);
        }
    }
}

