/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.ranger.RangerPrivilege;

public class RangerPrivileges {
    static List<Class<? extends Enum<? extends RangerPrivilege>>> allRangerPrivileges = Lists.newArrayList((Object[])new Class[]{RangerHivePrivilege.class, RangerHdfsPrivilege.class});

    public static RangerPrivilege valueOf(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Privilege name string cannot be null!");
        String strPrivilege = name.trim().toLowerCase();
        for (Class<? extends Enum<? extends RangerPrivilege>> enumClass : allRangerPrivileges) {
            for (Enum<? extends RangerPrivilege> privilege : enumClass.getEnumConstants()) {
                if (!((RangerPrivilege)((Object)privilege)).equalsTo(strPrivilege)) continue;
                return (RangerPrivilege)((Object)privilege);
            }
        }
        throw new IllegalArgumentException("Unknown privilege name: " + name);
    }

    public static enum RangerHdfsPrivilege implements RangerPrivilege
    {
        READ("read"),
        WRITE("write"),
        EXECUTE("execute");

        private final String name;

        private RangerHdfsPrivilege(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Privilege.Condition condition() {
            return null;
        }

        @Override
        public boolean equalsTo(String value) {
            return this.name.equalsIgnoreCase(value);
        }
    }

    public static class RangerHivePrivilegeImpl
    implements RangerPrivilege {
        private RangerPrivilege rangerHivePrivilege;
        private Privilege.Condition condition;

        public RangerHivePrivilegeImpl(RangerPrivilege rangerHivePrivilege, Privilege.Condition condition) {
            this.rangerHivePrivilege = rangerHivePrivilege;
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.rangerHivePrivilege.getName();
        }

        @Override
        public Privilege.Condition condition() {
            return this.condition;
        }

        @Override
        public boolean equalsTo(String value) {
            return this.rangerHivePrivilege.equalsTo(value);
        }
    }

    public static enum RangerHivePrivilege implements RangerPrivilege
    {
        ALL("all"),
        SELECT("select"),
        UPDATE("update"),
        CREATE("create"),
        DROP("drop"),
        ALTER("alter"),
        INDEX("index"),
        LOCK("lock"),
        READ("read"),
        WRITE("write"),
        REPLADMIN("repladmin"),
        SERVICEADMIN("serviceadmin");

        private final String name;

        private RangerHivePrivilege(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Privilege.Condition condition() {
            return null;
        }

        @Override
        public boolean equalsTo(String value) {
            return this.name.equalsIgnoreCase(value);
        }
    }
}

