/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.audit.CallerContext;
import org.apache.gravitino.audit.FilesetDataOperation;
import org.apache.gravitino.catalog.hadoop.HadoopFileset;
import org.apache.gravitino.catalog.hadoop.HadoopSchema;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCatalogOperations
implements CatalogOperations,
SupportsSchemas,
FilesetCatalog {
    private static final String SCHEMA_DOES_NOT_EXIST_MSG = "Schema %s does not exist";
    private static final String FILESET_DOES_NOT_EXIST_MSG = "Fileset %s does not exist";
    private static final String SLASH = "/";
    private static final Logger LOG = LoggerFactory.getLogger(HadoopCatalogOperations.class);
    private final EntityStore store;
    private HasPropertyMetadata propertiesMetadata;
    @VisibleForTesting
    Configuration hadoopConf;
    @VisibleForTesting
    Optional<Path> catalogStorageLocation;
    private Map<String, String> conf;
    private CatalogInfo catalogInfo;
    private final Map<String, FileSystemProvider> fileSystemProvidersMap = Maps.newHashMap();
    private FileSystemProvider defaultFileSystemProvider;

    HadoopCatalogOperations(EntityStore store) {
        this.store = store;
    }

    public HadoopCatalogOperations() {
        this(GravitinoEnv.getInstance().entityStore());
    }

    public EntityStore getStore() {
        return this.store;
    }

    public CatalogInfo getCatalogInfo() {
        return this.catalogInfo;
    }

    public Configuration getHadoopConf() {
        Configuration configuration = new Configuration();
        this.conf.forEach((k, v) -> configuration.set(k.replace("gravitino.bypass.", ""), v));
        return configuration;
    }

    public Map<String, String> getConf() {
        return this.conf;
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        this.propertiesMetadata = propertiesMetadata;
        this.catalogInfo = info;
        this.conf = config;
        String fileSystemProviders = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "filesystem-providers");
        this.fileSystemProvidersMap.putAll(FileSystemUtils.getFileSystemProviders(fileSystemProviders));
        String defaultFileSystemProviderName = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "default-filesystem-provider");
        this.defaultFileSystemProvider = FileSystemUtils.getFileSystemProviderByName(this.fileSystemProvidersMap, defaultFileSystemProviderName);
        String catalogLocation = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "location");
        this.catalogStorageLocation = StringUtils.isNotBlank((CharSequence)catalogLocation) ? Optional.of(catalogLocation).map(s -> s.endsWith(SLASH) ? s : s + SLASH).map(Path::new) : Optional.empty();
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        try {
            NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
            if (!this.store.exists(schemaIdent, Entity.EntityType.SCHEMA)) {
                throw new NoSuchSchemaException(SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{schemaIdent});
            }
            List filesets = this.store.list(namespace, FilesetEntity.class, Entity.EntityType.FILESET);
            return (NameIdentifier[])filesets.stream().map(f -> NameIdentifier.of((Namespace)namespace, (String)f.name())).toArray(NameIdentifier[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list filesets under namespace " + namespace, e);
        }
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        try {
            FilesetEntity filesetEntity = (FilesetEntity)this.store.get(ident, Entity.EntityType.FILESET, FilesetEntity.class);
            return ((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)HadoopFileset.builder().withName(ident.name())).withType(filesetEntity.filesetType())).withComment(filesetEntity.comment())).withStorageLocation(filesetEntity.storageLocation())).withProperties(filesetEntity.properties())).withAuditInfo(filesetEntity.auditInfo())).build();
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchFilesetException((Throwable)exception, FILESET_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load fileset %s" + ident, ioe);
        }
    }

    public Fileset createFileset(NameIdentifier ident, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        SchemaEntity schemaEntity;
        try {
            if (this.store.exists(ident, Entity.EntityType.FILESET)) {
                throw new FilesetAlreadyExistsException("Fileset %s already exists", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if fileset " + ident + " exists", ioe);
        }
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        try {
            schemaEntity = (SchemaEntity)this.store.get(schemaIdent, Entity.EntityType.SCHEMA, SchemaEntity.class);
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchSchemaException((Throwable)exception, SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{schemaIdent});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load schema " + schemaIdent, ioe);
        }
        if (type == Fileset.Type.EXTERNAL && StringUtils.isBlank((CharSequence)storageLocation)) {
            throw new IllegalArgumentException("Storage location must be set for external fileset " + ident);
        }
        Path schemaPath = this.getSchemaPath(schemaIdent.name(), schemaEntity.properties());
        if (schemaPath == null && StringUtils.isBlank((CharSequence)storageLocation)) {
            throw new IllegalArgumentException("Storage location must be set for fileset " + ident + " when it's catalog and schema location are not set");
        }
        Path filesetPath = StringUtils.isNotBlank((CharSequence)storageLocation) ? new Path(storageLocation) : new Path(schemaPath, ident.name());
        try {
            filesetPath = this.formalizePath(filesetPath, this.conf);
            FileSystem fs = this.getFileSystem(filesetPath, this.conf);
            if (!fs.exists(filesetPath)) {
                if (!fs.mkdirs(filesetPath)) {
                    throw new RuntimeException("Failed to create fileset " + ident + " location " + filesetPath);
                }
                LOG.info("Created fileset {} location {}", (Object)ident, (Object)filesetPath);
            } else {
                LOG.info("Fileset {} manages the existing location {}", (Object)ident, (Object)filesetPath);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create fileset " + ident + " location " + filesetPath, ioe);
        }
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property String identifier should not be null");
        FilesetEntity filesetEntity = FilesetEntity.builder().withName(ident.name()).withId(Long.valueOf(stringId.id())).withNamespace(ident.namespace()).withComment(comment).withFilesetType(type).withStorageLocation(filesetPath.toString()).withProperties(properties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)filesetEntity, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create fileset " + ident, ioe);
        }
        return ((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)HadoopFileset.builder().withName(ident.name())).withComment(comment)).withType(type)).withStorageLocation(filesetPath.toString())).withProperties(filesetEntity.properties())).withAuditInfo(filesetEntity.auditInfo())).build();
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        try {
            if (!this.store.exists(ident, Entity.EntityType.FILESET)) {
                throw new NoSuchFilesetException(FILESET_DOES_NOT_EXIST_MSG, new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load fileset " + ident, ioe);
        }
        try {
            FilesetEntity updatedFilesetEntity = (FilesetEntity)this.store.update(ident, FilesetEntity.class, Entity.EntityType.FILESET, e -> this.updateFilesetEntity(ident, (FilesetEntity)e, changes));
            return ((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)((HadoopFileset.Builder)HadoopFileset.builder().withName(updatedFilesetEntity.name())).withComment(updatedFilesetEntity.comment())).withType(updatedFilesetEntity.filesetType())).withStorageLocation(updatedFilesetEntity.storageLocation())).withProperties(updatedFilesetEntity.properties())).withAuditInfo(updatedFilesetEntity.auditInfo())).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to update fileset " + ident, ioe);
        }
        catch (NoSuchEntityException nsee) {
            throw new NoSuchFilesetException((Throwable)nsee, FILESET_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (AlreadyExistsException aee) {
            throw new RuntimeException("Fileset with the same name " + ident.name() + " already exists", aee);
        }
    }

    public boolean dropFileset(NameIdentifier ident) {
        try {
            FilesetEntity filesetEntity = (FilesetEntity)this.store.get(ident, Entity.EntityType.FILESET, FilesetEntity.class);
            Path filesetPath = new Path(filesetEntity.storageLocation());
            if (filesetEntity.filesetType() == Fileset.Type.MANAGED) {
                FileSystem fs = this.getFileSystem(filesetPath, this.conf);
                if (fs.exists(filesetPath)) {
                    if (!fs.delete(filesetPath, true)) {
                        LOG.warn("Failed to delete fileset {} location {}", (Object)ident, (Object)filesetPath);
                        return false;
                    }
                } else {
                    LOG.warn("Fileset {} location {} does not exist", (Object)ident, (Object)filesetPath);
                }
            }
            return this.store.delete(ident, Entity.EntityType.FILESET);
        }
        catch (NoSuchEntityException ne) {
            LOG.warn("Fileset {} does not exist", (Object)ident);
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete fileset " + ident, ioe);
        }
    }

    public String getFileLocation(NameIdentifier ident, String subPath) throws NoSuchFilesetException {
        String fileLocation;
        Preconditions.checkArgument((subPath != null ? 1 : 0) != 0, (Object)"subPath must not be null");
        String processedSubPath = !subPath.trim().isEmpty() && !subPath.trim().startsWith(SLASH) ? SLASH + subPath.trim() : subPath.trim();
        Fileset fileset = this.loadFileset(ident);
        boolean isSingleFile = this.checkSingleFile(fileset);
        if (isSingleFile && StringUtils.isBlank((CharSequence)processedSubPath)) {
            throw new GravitinoRuntimeException("Sub path should always be blank, because the fileset only mounts a single file.");
        }
        if (this.hasCallerContext()) {
            Map contextMap = CallerContext.CallerContextHolder.get().context();
            String operation = contextMap.getOrDefault("FilesetDataOperation", FilesetDataOperation.UNKNOWN.name());
            if (!FilesetDataOperation.checkValid((String)operation)) {
                LOG.warn("The data operation: {} is not valid, we cannot do some checks for this operation.", (Object)operation);
            } else {
                FilesetDataOperation dataOperation = FilesetDataOperation.valueOf((String)operation);
                switch (dataOperation) {
                    case RENAME: {
                        if (isSingleFile) {
                            throw new GravitinoRuntimeException("Cannot rename the fileset: %s which only mounts to a single file.", new Object[]{ident});
                        }
                        if (!StringUtils.isBlank((CharSequence)processedSubPath) && (!processedSubPath.startsWith(SLASH) || processedSubPath.length() != 1)) break;
                        throw new GravitinoRuntimeException("subPath cannot be blank when need to rename a file or a directory.");
                    }
                }
            }
        }
        if (isSingleFile || StringUtils.isBlank((CharSequence)processedSubPath)) {
            fileLocation = fileset.storageLocation();
        } else {
            String storageLocation = fileset.storageLocation().endsWith(SLASH) ? fileset.storageLocation().substring(0, fileset.storageLocation().length() - 1) : fileset.storageLocation();
            fileLocation = String.format("%s%s", storageLocation, processedSubPath);
        }
        return fileLocation;
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            List schemas = this.store.list(namespace, SchemaEntity.class, Entity.EntityType.SCHEMA);
            return (NameIdentifier[])schemas.stream().map(s -> NameIdentifier.of((Namespace)namespace, (String)s.name())).toArray(NameIdentifier[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list schemas under namespace " + namespace, e);
        }
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        try {
            if (this.store.exists(ident, Entity.EntityType.SCHEMA)) {
                throw new SchemaAlreadyExistsException("Schema %s already exists", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if schema " + ident + " exists", ioe);
        }
        Path schemaPath = this.getSchemaPath(ident.name(), properties);
        if (schemaPath != null) {
            try {
                FileSystem fs = this.getFileSystem(schemaPath, this.conf);
                if (!fs.exists(schemaPath)) {
                    if (!fs.mkdirs(schemaPath)) {
                        throw new RuntimeException("Failed to create schema " + ident + " location " + schemaPath);
                    }
                    LOG.info("Created schema {} location {}", (Object)ident, (Object)schemaPath);
                } else {
                    LOG.info("Schema {} manages the existing location {}", (Object)ident, (Object)schemaPath);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to create schema " + ident + " location " + schemaPath, ioe);
            }
        }
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkNotNull((Object)stringId, (Object)"Property String identifier should not be null");
        SchemaEntity schemaEntity = SchemaEntity.builder().withName(ident.name()).withId(Long.valueOf(stringId.id())).withNamespace(ident.namespace()).withComment(comment).withProperties(properties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)schemaEntity, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create schema " + ident, ioe);
        }
        return ((HadoopSchema.Builder)((HadoopSchema.Builder)((HadoopSchema.Builder)((HadoopSchema.Builder)HadoopSchema.builder().withName(ident.name())).withComment(comment)).withProperties(schemaEntity.properties())).withAuditInfo(schemaEntity.auditInfo())).build();
    }

    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        try {
            SchemaEntity schemaEntity = (SchemaEntity)this.store.get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            return ((HadoopSchema.Builder)((HadoopSchema.Builder)((HadoopSchema.Builder)((HadoopSchema.Builder)HadoopSchema.builder().withName(ident.name())).withComment(schemaEntity.comment())).withProperties(schemaEntity.properties())).withAuditInfo(schemaEntity.auditInfo())).build();
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchSchemaException((Throwable)exception, SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load schema " + ident, ioe);
        }
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        try {
            if (!this.store.exists(ident, Entity.EntityType.SCHEMA)) {
                throw new NoSuchSchemaException(SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if schema " + ident + " exists", ioe);
        }
        try {
            SchemaEntity entity = (SchemaEntity)this.store.update(ident, SchemaEntity.class, Entity.EntityType.SCHEMA, schemaEntity -> this.updateSchemaEntity(ident, (SchemaEntity)schemaEntity, changes));
            return ((HadoopSchema.Builder)((HadoopSchema.Builder)((HadoopSchema.Builder)((HadoopSchema.Builder)HadoopSchema.builder().withName(ident.name())).withComment(entity.comment())).withProperties(entity.properties())).withAuditInfo(entity.auditInfo())).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to update schema " + ident, ioe);
        }
        catch (NoSuchEntityException nsee) {
            throw new NoSuchSchemaException((Throwable)nsee, SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (AlreadyExistsException aee) {
            throw new RuntimeException("Schema with the same name " + ident.name() + " already exists, this is unexpected because schema doesn't support rename", aee);
        }
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            SchemaEntity schemaEntity = (SchemaEntity)this.store.get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            Map<String, String> properties = Optional.ofNullable(schemaEntity.properties()).orElse(Collections.emptyMap());
            Path schemaPath = this.getSchemaPath(ident.name(), properties);
            if (schemaPath == null) {
                return false;
            }
            FileSystem fs = this.getFileSystem(schemaPath, this.conf);
            if (!fs.exists(schemaPath)) {
                return false;
            }
            if (fs.listStatus(schemaPath).length > 0 && !cascade) {
                throw new NonEmptySchemaException("Schema %s with location %s is not empty", new Object[]{ident, schemaPath});
            }
            fs.delete(schemaPath, true);
            LOG.info("Deleted schema {} location {}", (Object)ident, (Object)schemaPath);
            return true;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete schema " + ident + " location", ioe);
        }
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
    }

    public void close() throws IOException {
    }

    private SchemaEntity updateSchemaEntity(NameIdentifier ident, SchemaEntity schemaEntity, SchemaChange ... changes) {
        HashMap props = schemaEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)schemaEntity.properties());
        for (SchemaChange change : changes) {
            if (change instanceof SchemaChange.SetProperty) {
                SchemaChange.SetProperty setProperty = (SchemaChange.SetProperty)change;
                props.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change instanceof SchemaChange.RemoveProperty) {
                SchemaChange.RemoveProperty removeProperty = (SchemaChange.RemoveProperty)change;
                props.remove(removeProperty.getProperty());
                continue;
            }
            throw new IllegalArgumentException("Unsupported schema change: " + change.getClass().getSimpleName());
        }
        return SchemaEntity.builder().withName(schemaEntity.name()).withNamespace(ident.namespace()).withId(schemaEntity.id()).withComment(schemaEntity.comment()).withProperties((Map)props).withAuditInfo(AuditInfo.builder().withCreator(schemaEntity.auditInfo().creator()).withCreateTime(schemaEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }

    private FilesetEntity updateFilesetEntity(NameIdentifier ident, FilesetEntity filesetEntity, FilesetChange ... changes) {
        HashMap props = filesetEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)filesetEntity.properties());
        String newName = ident.name();
        String newComment = filesetEntity.comment();
        for (FilesetChange change : changes) {
            if (change instanceof FilesetChange.SetProperty) {
                FilesetChange.SetProperty setProperty = (FilesetChange.SetProperty)change;
                props.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change instanceof FilesetChange.RemoveProperty) {
                FilesetChange.RemoveProperty removeProperty = (FilesetChange.RemoveProperty)change;
                props.remove(removeProperty.getProperty());
                continue;
            }
            if (change instanceof FilesetChange.RenameFileset) {
                newName = ((FilesetChange.RenameFileset)change).getNewName();
                continue;
            }
            if (change instanceof FilesetChange.UpdateFilesetComment) {
                newComment = ((FilesetChange.UpdateFilesetComment)change).getNewComment();
                continue;
            }
            if (change instanceof FilesetChange.RemoveComment) {
                newComment = null;
                continue;
            }
            throw new IllegalArgumentException("Unsupported fileset change: " + change.getClass().getSimpleName());
        }
        return FilesetEntity.builder().withName(newName).withNamespace(ident.namespace()).withId(filesetEntity.id()).withComment(newComment).withFilesetType(filesetEntity.filesetType()).withStorageLocation(filesetEntity.storageLocation()).withProperties((Map)props).withAuditInfo(AuditInfo.builder().withCreator(filesetEntity.auditInfo().creator()).withCreateTime(filesetEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }

    private Path getSchemaPath(String name, Map<String, String> properties) {
        String schemaLocation = (String)this.propertiesMetadata.schemaPropertiesMetadata().getOrDefault(properties, "location");
        return Optional.ofNullable(schemaLocation).map(s -> s.endsWith(SLASH) ? s : s + SLASH).map(Path::new).orElse(this.catalogStorageLocation.map(p -> new Path(p, name)).orElse(null));
    }

    @VisibleForTesting
    Path formalizePath(Path path, Map<String, String> configuration) throws IOException {
        FileSystem defaultFs = this.getFileSystem(path, configuration);
        return path.makeQualified(defaultFs.getUri(), defaultFs.getWorkingDirectory());
    }

    private boolean hasCallerContext() {
        return CallerContext.CallerContextHolder.get() != null && CallerContext.CallerContextHolder.get().context() != null && !CallerContext.CallerContextHolder.get().context().isEmpty();
    }

    private boolean checkSingleFile(Fileset fileset) {
        try {
            Path locationPath = new Path(fileset.storageLocation());
            return this.getFileSystem(locationPath, this.conf).getFileStatus(locationPath).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new GravitinoRuntimeException((Throwable)e, "Exception occurs when checking whether fileset: %s mounts a single file", new Object[]{fileset.name()});
        }
    }

    FileSystem getFileSystem(Path path, Map<String, String> config) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path should not be null");
        }
        String scheme = path.toUri().getScheme() != null ? path.toUri().getScheme() : this.defaultFileSystemProvider.scheme();
        FileSystemProvider provider = this.fileSystemProvidersMap.get(scheme);
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Unsupported scheme: %s, path: %s, all supported schemes: %s and providers: %s", scheme, path, this.fileSystemProvidersMap.keySet(), this.fileSystemProvidersMap.values()));
        }
        return provider.getFileSystem(path, config);
    }
}

