/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ActivityCorrelator {
    private static Map<Long, ActivityId> ActivityIdTlsMap = new ConcurrentHashMap<Long, ActivityId>();

    ActivityCorrelator() {
    }

    static void cleanupActivityId() {
        long uniqueThreadId = Thread.currentThread().getId();
        if (ActivityIdTlsMap.containsKey(uniqueThreadId)) {
            ActivityIdTlsMap.remove(uniqueThreadId);
        }
    }

    static ActivityId getCurrent() {
        long uniqueThreadId = Thread.currentThread().getId();
        if (!ActivityIdTlsMap.containsKey(uniqueThreadId)) {
            ActivityIdTlsMap.put(uniqueThreadId, new ActivityId());
        }
        return ActivityIdTlsMap.get(uniqueThreadId);
    }

    static ActivityId getNext() {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        activityId.Increment();
        return activityId;
    }

    static void setCurrentActivityIdSentFlag() {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        activityId.setSentFlag();
    }
}

