/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver.factory;

import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.util.E;

public class DefaultHugeClientFactory {
    private final String defaultHugeGraph = "hugegraph";
    private final String[] urls;

    public DefaultHugeClientFactory(String[] urls) {
        this.urls = urls;
    }

    public HugeClient createClient(String graphSpace, String graph) {
        return this.createClient(graphSpace, graph, 60);
    }

    public HugeClient createClient(String graphSpace, String graph, int timeout) {
        return this.createClient(graphSpace, graph, null, null, null, timeout);
    }

    public HugeClient createClient(String graphSpace, String graph, String token, String username, String password) {
        return this.createClient(graphSpace, graph, token, username, password, 60);
    }

    public HugeClient createClient(String graphSpace, String graph, String token, String username, String password, int timeout) {
        E.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Client timeout must > 0", (Object[])new Object[0]);
        int r = (int)Math.floor(Math.random() * (double)this.urls.length);
        String url = this.urls[r];
        HugeClient client = HugeClient.builder(url, graphSpace, graph).configToken(token).configUser(username, password).configTimeout(timeout).build();
        return client;
    }
}

