/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.jdbc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.hugegraph.loader.source.AbstractSource;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.jdbc.JDBCVendor;
import org.apache.hugegraph.util.E;

@JsonPropertyOrder(value={"type", "vendor"})
public class JDBCSource
extends AbstractSource {
    @JsonProperty(value="custom_sql")
    private String customSQL;
    @JsonProperty(value="vendor")
    private JDBCVendor vendor;
    @JsonProperty(value="driver")
    private String driver;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="schema")
    private String schema;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="where")
    private String where;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="batch_size")
    private int batchSize = 500;

    @Override
    public SourceType type() {
        return SourceType.JDBC;
    }

    @Override
    public void check() throws IllegalArgumentException {
        super.check();
        E.checkArgument((this.vendor != null ? 1 : 0) != 0, (String)"The vendor can't be null", (Object[])new Object[0]);
        E.checkArgument((this.url != null ? 1 : 0) != 0, (String)"The url can't be null", (Object[])new Object[0]);
        E.checkArgument((this.database != null ? 1 : 0) != 0, (String)"The database can't be null", (Object[])new Object[0]);
        E.checkArgument((this.username != null ? 1 : 0) != 0, (String)"The username can't be null", (Object[])new Object[0]);
        E.checkArgument((this.password != null ? 1 : 0) != 0, (String)"The password can't be null", (Object[])new Object[0]);
        E.checkArgument((this.table != null || this.customSQL != null ? 1 : 0) != 0, (String)"At least one of table and sql can't be null", (Object[])new Object[0]);
        this.schema = this.vendor.checkSchema(this);
        if (this.driver == null) {
            this.driver = this.vendor.defaultDriver();
        }
    }

    public String customSQL() {
        return this.customSQL;
    }

    public boolean existsCustomSQL() {
        return this.customSQL != null;
    }

    public JDBCVendor vendor() {
        return this.vendor;
    }

    public String driver() {
        return this.driver;
    }

    public String url() {
        return this.url;
    }

    public String database() {
        return this.database;
    }

    public String schema() {
        return this.schema;
    }

    public String table() {
        return this.table;
    }

    public String getWhere() {
        return this.where;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public FileSource asFileSource() {
        FileSource source = new FileSource();
        source.header(this.header());
        source.charset(this.charset());
        source.listFormat(this.listFormat());
        return source;
    }

    public String toString() {
        return String.format("%s(%s)", new Object[]{this.type(), this.url()});
    }
}

