/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.loader.progress.InputProgress;
import org.apache.hugegraph.loader.serializer.DeserializeException;
import org.apache.hugegraph.loader.serializer.InputProgressDeser;
import org.apache.hugegraph.loader.serializer.InputSourceDeser;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.rest.SerializeException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class JsonUtil {
    private static final Logger LOG = Log.logger(JsonUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void registerModule(Module module) {
        MAPPER.registerModule(module);
    }

    public static String toJson(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to serialize objects", (Throwable)e);
            throw new SerializeException("Failed to serialize objects", (Throwable)e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize json", (Throwable)e);
            throw new SerializeException("Failed to deserialize json", (Throwable)e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeRef) {
        E.checkState((json != null ? 1 : 0) != 0, (String)"Json value can't be null for '%s'", (Object[])new Object[]{typeRef.getType()});
        try {
            return (T)MAPPER.readValue(json, typeRef);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize json", (Throwable)e);
            throw new DeserializeException("Failed to deserialize json", e);
        }
    }

    public static <T> T convert(JsonNode node, Class<T> clazz) {
        return (T)MAPPER.convertValue((Object)node, clazz);
    }

    public static <T> Set<T> convertSet(String json, Class<T> clazz) {
        CollectionType type = MAPPER.getTypeFactory().constructCollectionType(LinkedHashSet.class, clazz);
        try {
            return (Set)MAPPER.readValue(json, (JavaType)type);
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize json", (Throwable)e);
            throw new DeserializeException("Failed to deserialize json", e);
        }
    }

    public static <T> Set<T> convertSet(JsonNode node, Class<T> clazz) {
        CollectionType type = MAPPER.getTypeFactory().constructCollectionType(LinkedHashSet.class, clazz);
        return (Set)MAPPER.convertValue((Object)node, (JavaType)type);
    }

    public static <T> List<T> convertList(String json, Class<T> clazz) {
        CollectionType type = MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
        try {
            return (List)MAPPER.readValue(json, (JavaType)type);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize json", (Throwable)e);
            throw new DeserializeException("Failed to deserialize json", e);
        }
    }

    public static <T> List<T> convertList(JsonNode node, Class<T> clazz) {
        CollectionType type = MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)MAPPER.convertValue((Object)node, (JavaType)type);
    }

    public static <K, V> Map<K, V> convertMap(String json, Class<K> kClazz, Class<V> vClazz) {
        MapType type = MAPPER.getTypeFactory().constructMapType(Map.class, kClazz, vClazz);
        try {
            return (Map)MAPPER.readValue(json, (JavaType)type);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize json", (Throwable)e);
            throw new DeserializeException("Failed to deserialize json", e);
        }
    }

    public static <K, V> Map<K, V> convertMap(JsonNode node, Class<K> kClazz, Class<V> vClazz) {
        MapType type = MAPPER.getTypeFactory().constructMapType(Map.class, kClazz, vClazz);
        return (Map)MAPPER.convertValue((Object)node, (JavaType)type);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(InputSource.class, (JsonDeserializer)new InputSourceDeser());
        module.addDeserializer(InputProgress.class, (JsonDeserializer)new InputProgressDeser());
        JsonUtil.registerModule((Module)module);
    }
}

