/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DriverUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnDriver(HiveConf conf, String user, SessionState sessionState, String query, ValidWriteIdList writeIds) throws HiveException {
        SessionState.setCurrentSessionState(sessionState);
        boolean isOk = false;
        try {
            QueryState qs = new QueryState.Builder().withHiveConf(conf).nonIsolated().build();
            Driver driver = new Driver(qs, user, null, null);
            driver.setCompactionWriteIds(writeIds);
            try {
                CommandProcessorResponse cpr = driver.run(query);
                if (cpr.getResponseCode() != 0) {
                    LOG.error("Failed to run " + query, cpr.getException());
                    throw new HiveException("Failed to run " + query, cpr.getException());
                }
            }
            finally {
                driver.close();
                driver.destroy();
            }
            isOk = true;
        }
        finally {
            if (!isOk) {
                try {
                    sessionState.close();
                }
                catch (Throwable th) {
                    LOG.warn("Failed to close a bad session", th);
                    SessionState.detachSession();
                }
            }
        }
    }

    public static SessionState setUpSessionState(HiveConf conf, String user, boolean doStart) {
        SessionState sessionState = SessionState.get();
        if (sessionState == null) {
            sessionState = new SessionState(conf, user);
            if (doStart) {
                sessionState.setIsHiveServerQuery(true);
                SessionState.start(sessionState);
            }
            SessionState.setCurrentSessionState(sessionState);
        }
        return sessionState;
    }
}

