/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.license;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hugegraph.license.LicenseExtraParam;

public class LicenseCommonParam {
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="issued_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date issuedTime;
    @JsonProperty(value="not_before")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date notBefore;
    @JsonProperty(value="not_after")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date notAfter;
    @JsonProperty(value="consumer_type")
    private String consumerType;
    @JsonProperty(value="consumer_amount")
    private Integer consumerAmount;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="extra_params")
    private List<LicenseExtraParam> extraParams;

    public LicenseCommonParam() {
        this.notBefore = this.issuedTime = new Date();
        this.notAfter = DateUtils.addDays((Date)this.notBefore, (int)30);
        this.consumerType = "user";
        this.consumerAmount = 1;
        this.description = "";
    }

    public LicenseCommonParam(String subject, String description, Date issued, Date notBefore, Date notAfter, String consumerType, int consumerAmount, List<LicenseExtraParam> extraParams) {
        this.notBefore = this.issuedTime = new Date();
        this.notAfter = DateUtils.addDays((Date)this.notBefore, (int)30);
        this.consumerType = "user";
        this.consumerAmount = 1;
        this.description = "";
        this.subject = subject;
        this.description = description;
        this.issuedTime = issued;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.consumerType = consumerType;
        this.consumerAmount = consumerAmount;
        this.extraParams = extraParams;
    }

    public String subject() {
        return this.subject;
    }

    public Date issuedTime() {
        return this.issuedTime;
    }

    public Date notBefore() {
        return this.notBefore;
    }

    public Date notAfter() {
        return this.notAfter;
    }

    public String consumerType() {
        return this.consumerType;
    }

    public Integer consumerAmount() {
        return this.consumerAmount;
    }

    public String description() {
        return this.description;
    }

    public List<LicenseExtraParam> extraParams() {
        return this.extraParams;
    }
}

