/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import com.google.common.base.Predicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class OptionChecker {
    public static <O> Predicate<O> disallowEmpty() {
        return o -> {
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return StringUtils.isNotBlank((CharSequence)((String)o));
            }
            if (o.getClass().isArray() && Array.getLength(o) == 0) {
                return false;
            }
            return !(o instanceof Iterable) || ((Iterable)o).iterator().hasNext();
        };
    }

    public static <O> Predicate<O> allowValues(O ... values) {
        return o -> o != null && Arrays.asList(values).contains(o);
    }

    public static <O> Predicate<List<O>> inValues(O ... values) {
        return o -> o != null && new HashSet<Object>(Arrays.asList(values)).containsAll((Collection<?>)o);
    }

    public static <N extends Number> Predicate<N> positiveInt() {
        return number -> number != null && number.longValue() > 0L;
    }

    public static <N extends Number> Predicate<N> nonNegativeInt() {
        return number -> number != null && number.longValue() >= 0L;
    }

    public static <N extends Number> Predicate<N> rangeInt(N min, N max) {
        return number -> {
            if (number == null) {
                return false;
            }
            long value = number.longValue();
            return value >= min.longValue() && value <= max.longValue();
        };
    }

    public static <N extends Number> Predicate<N> rangeDouble(N min, N max) {
        return number -> {
            if (number == null) {
                return false;
            }
            double value = number.doubleValue();
            return value >= min.doubleValue() && value <= max.doubleValue();
        };
    }
}

