/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hugegraph.exception.InternalException;

public final class FileUtil {
    public static int countLines(String path) {
        return FileUtil.countLines(new File(path));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int countLines(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("The file %s doesn't exist", file));
        }
        long fileLength = file.length();
        try (FileInputStream fis = new FileInputStream(file);){
            int n;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                int number = 0;
                int i = 0;
                while ((long)i < fileLength - 1L) {
                    if (bis.read() == 10) {
                        ++number;
                    }
                    ++i;
                }
                if (fileLength > 0L) {
                    ++number;
                }
                n = number;
            }
            return n;
        }
        catch (IOException e) {
            throw new InternalException("Failed to count lines of file %s", file);
        }
    }
}

