/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.space;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.space.GraphSpace;
import org.apache.hugegraph.util.JsonUtil;

public class GraphSpaceAPI
extends API {
    private static final String PATH = "graphspaces";
    private static final String DELIMITER = "/";

    public GraphSpaceAPI(RestClient client) {
        super(client);
        this.path(PATH);
    }

    private static String joinPath(String path, String id) {
        return String.join((CharSequence)DELIMITER, path, id);
    }

    @Override
    protected String type() {
        return HugeType.GRAPHSPACES.string();
    }

    public GraphSpace create(GraphSpace graphSpace) {
        this.client.checkApiVersion("0.67", "dynamic graph space add");
        Object obj = graphSpace.convertReq();
        RestResult result = this.client.post(this.path(), obj);
        return (GraphSpace)result.readObject(GraphSpace.class);
    }

    public GraphSpace get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (GraphSpace)result.readObject(GraphSpace.class);
    }

    public List<String> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), String.class);
    }

    public List<Map<String, Object>> listProfile(String prefix) {
        String profilePath = GraphSpaceAPI.joinPath(this.path(), "profile");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("prefix", prefix);
        RestResult result = this.client.get(profilePath, params);
        List results = result.readList(Map.class);
        ArrayList<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
        for (Object entry : results) {
            profiles.add(JsonUtil.fromJson(JsonUtil.toJson(entry), Map.class));
        }
        return profiles;
    }

    public Map<String, String> setDefault(String name) {
        String defaultPath = GraphSpaceAPI.joinPath(this.path(), name, "default");
        RestResult result = this.client.get(defaultPath);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, String> getDefault() {
        String defaultPath = GraphSpaceAPI.joinPath(this.path(), "default");
        RestResult result = this.client.get(defaultPath);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, String> setDefaultRole(String name, String user, String role, String graph) {
        String path = GraphSpaceAPI.joinPath(this.path(), name, "role");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("role", role);
        if (StringUtils.isNotEmpty((String)graph)) {
            params.put("graph", graph);
        }
        RestResult result = this.client.post(path, params);
        return (Map)result.readObject(Map.class);
    }

    public boolean checkDefaultRole(String name, String user, String role, String graph) {
        String path = GraphSpaceAPI.joinPath(this.path(), name, "role");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", user);
        params.put("role", role);
        if (StringUtils.isNotEmpty((String)graph)) {
            params.put("graph", graph);
        }
        RestResult result = this.client.get(path, params);
        return ((Map)result.readObject(Map.class)).getOrDefault("check", false);
    }

    public Map<String, String> deleteDefaultRole(String name, String user, String role, String graph) {
        String path = GraphSpaceAPI.joinPath(this.path(), name, "role");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", user);
        params.put("role", role);
        if (StringUtils.isNotEmpty((String)graph)) {
            params.put("graph", graph);
        }
        RestResult result = this.client.delete(path, params);
        return (Map)result.readObject(Map.class);
    }

    public void delete(String name) {
        this.client.delete(GraphSpaceAPI.joinPath(this.path(), name), (Map<String, Object>)ImmutableMap.of());
    }

    public GraphSpace update(GraphSpace graphSpace) {
        Object obj = graphSpace.convertReq();
        RestResult result = this.client.put(this.path(), graphSpace.getName(), ImmutableMap.of((Object)"action", (Object)"update", (Object)"update", (Object)obj));
        return (GraphSpace)result.readObject(GraphSpace.class);
    }
}

