/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.base;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hugegraph.base.Printer;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.base.ToolManager;
import org.apache.hugegraph.exception.ToolsException;

public class RetryManager
extends ToolManager {
    private int cpus = Runtime.getRuntime().availableProcessors();
    private int threadsNum = Math.min(10, Math.max(4, this.cpus / 2));
    private ExecutorService pool;
    private final Queue<Future<?>> futures = new ConcurrentLinkedQueue();
    private int retry = 0;

    public RetryManager(ToolClient.ConnectionInfo info, String type) {
        super(info, type);
    }

    public void initExecutors() {
        Printer.print("Init %s executors", this.threadsNum);
        this.pool = Executors.newFixedThreadPool(this.threadsNum);
    }

    public <R> R retry(Supplier<R> supplier, String description) {
        int retries = 0;
        R r = null;
        while (true) {
            try {
                r = supplier.get();
            }
            catch (Exception e) {
                if (retries != this.retry) continue;
                throw new ToolsException("Exception occurred while %s(after %s retries)", (Throwable)e, description, this.retry);
                if (retries++ < this.retry) continue;
            }
            break;
        }
        return r;
    }

    public void submit(Runnable task) {
        this.futures.add(this.pool.submit(task));
    }

    public void awaitTasks() {
        Future<?> future;
        while ((future = this.futures.poll()) != null) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown(String taskType) {
        if (this.pool == null) {
            return;
        }
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(24L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            throw new ToolsException("Exception appears in %s threads", (Throwable)e, taskType);
        }
    }

    public int retry() {
        return this.retry;
    }

    public void retry(int retry) {
        this.retry = retry;
    }

    public int threadsNum() {
        return this.threadsNum;
    }

    public void threadsNum(int threadsNum) {
        if (threadsNum > 0) {
            this.threadsNum = threadsNum;
        }
    }
}

