/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableLongSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableLongSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.set.primitive.AbstractLongSet;

public class LongHashSet
extends AbstractLongSet
implements MutableLongSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long EMPTY = 0L;
    private static final long REMOVED = 1L;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private long[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public LongHashSet() {
        this.allocateTable(16);
    }

    public LongHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public LongHashSet(long ... elements) {
        this();
        this.addAll(elements);
    }

    public LongHashSet(LongIterable elements) {
        this();
        this.addAll(elements);
    }

    public LongHashSet(LongHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public static LongHashSet newSet(LongIterable source) {
        if (source instanceof LongHashSet) {
            return new LongHashSet((LongHashSet)source);
        }
        return new LongHashSet(source);
    }

    public static LongHashSet newSetWith(long ... source) {
        return new LongHashSet(source);
    }

    private static boolean isBetweenZeroAndThirtyOne(long value) {
        return value >= 0L && value <= 31L;
    }

    @Override
    public int hashCode() {
        long value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (int)(value ^ value >>> 32);
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                result += (int)(this.table[i] ^ this.table[i] >>> 32);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            long value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean add(long element) {
        if (LongHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << (int)element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    @Override
    public boolean addAll(long ... source) {
        int oldSize = this.size();
        for (long item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean addAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongHashSet) {
            LongHashSet hashSet = (LongHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (long item : hashSet.table) {
                if (!LongHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                long item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean remove(long value) {
        if (LongHashSet.isBetweenZeroAndThirtyOne(value)) {
            return this.removeZeroToThirtyOne(value);
        }
        if (this.occupiedWithData == 0) {
            return false;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return true;
        }
        return false;
    }

    private boolean removeZeroToThirtyOne(long value) {
        int initial = this.zeroToThirtyOne;
        this.zeroToThirtyOne &= ~(1 << (int)value);
        if (this.zeroToThirtyOne == initial) {
            return false;
        }
        --this.zeroToThirtyOneOccupied;
        return true;
    }

    @Override
    public boolean removeAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongHashSet) {
            LongHashSet hashSet = (LongHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (long item : hashSet.table) {
                if (!LongHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                long item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (long item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(LongIterable source) {
        int oldSize = this.size();
        LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
        LongHashSet retained = this.select(sourceSet::contains);
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(long ... source) {
        return this.retainAll(LongHashSet.newSetWith(source));
    }

    @Override
    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new long[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0L);
        }
    }

    @Override
    public LongHashSet with(long element) {
        this.add(element);
        return this;
    }

    @Override
    public LongHashSet without(long element) {
        this.remove(element);
        return this;
    }

    @Override
    public LongHashSet withAll(LongIterable elements) {
        this.addAll(elements);
        return this;
    }

    @Override
    public LongHashSet withoutAll(LongIterable elements) {
        this.removeAll(elements);
        return this;
    }

    @Override
    public MutableLongSet asUnmodifiable() {
        return new UnmodifiableLongSet(this);
    }

    @Override
    public MutableLongSet asSynchronized() {
        return new SynchronizedLongSet(this);
    }

    @Override
    public ImmutableLongSet toImmutable() {
        LongHashSet mutableSet;
        if (this.size() == 0) {
            return LongSets.immutable.with();
        }
        if (this.size() == 1) {
            return LongSets.immutable.with(this.longIterator().next());
        }
        if (this.table.length == this.smallestPowerOfTwoGreaterThan(this.size() << 1)) {
            mutableSet = this;
            this.copyOnWrite = true;
        } else {
            mutableSet = new LongHashSet(this.size());
            mutableSet.addAll(this);
        }
        return new ImmutableLongHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    @Override
    public MutableLongIterator longIterator() {
        return new InternalLongIterator();
    }

    @Override
    public long[] toArray() {
        long value;
        long[] array = new long[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            array[j] = value = (long)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!LongHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public long[] toArray(long[] array) {
        long value;
        if (array.length < this.size()) {
            array = new long[this.size()];
        }
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            array[j] = value = (long)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!LongHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public boolean contains(long value) {
        if (LongHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> (int)value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    @Override
    public void each(LongProcedure procedure) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    @Override
    public LongHashSet select(LongPredicate predicate) {
        return this.select(predicate, new LongHashSet());
    }

    @Override
    public <R extends MutableLongCollection> R select(LongPredicate predicate, R target) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            target.add(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public LongHashSet reject(LongPredicate predicate) {
        return this.reject(predicate, new LongHashSet());
    }

    @Override
    public <R extends MutableLongCollection> R reject(LongPredicate predicate, R target) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            target.add(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        return this.collect(function, UnifiedSet.newSet(this.size()));
    }

    @Override
    public <V, R extends Collection<V>> R collect(LongToObjectFunction<? extends V> function, R target) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    @Override
    public int count(LongPredicate predicate) {
        long value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sum() {
        long value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            result += value2;
        }
        return result;
    }

    @Override
    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (long value : this.table) {
            if (!LongHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long min2 = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (long value : this.table) {
            if (!LongHashSet.isNonSentinel(value) || isMinSet && value >= min2) continue;
            min2 = value;
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public LongSet freeze() {
        if (this.size() == 0) {
            return LongSets.immutable.with();
        }
        if (this.size() == 1) {
            return LongSets.immutable.with(this.longIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableLongHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        long value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeLong(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            out.writeLong(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readLong());
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        long value;
        T result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    @Override
    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<LongIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(LongSets.mutable.withAll(this));
            } else {
                MutableLongIterator iterator = this.longIterator();
                while (iterator.hasNext()) {
                    MutableLongSet batch = LongSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }

    @Override
    public LongHashSet newEmpty() {
        return new LongHashSet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        long[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    protected void allocateTable(int sizeToAllocate) {
        this.table = new long[sizeToAllocate];
    }

    int probe(long element) {
        int index = this.spreadAndMask(element);
        long valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0L) {
            return index;
        }
        int removedIndex = valueAtIndex == 1L ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            valueAtIndex = this.table[nextIndex];
            if (valueAtIndex == element) {
                return nextIndex;
            }
            if (valueAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(long element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            long valueAtIndex = this.table[nextIndex];
            if (valueAtIndex == element) {
                return nextIndex;
            }
            if (valueAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(long element, int removedIndex) {
        int nextIndex = (int)Long.reverse(SpreadFunctions.longSpreadOne(element));
        int spreadTwo = (int)Long.reverse(SpreadFunctions.longSpreadTwo(element)) | 1;
        long valueAtIndex;
        while ((valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (valueAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(long element) {
        long code = SpreadFunctions.longSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(long element) {
        long code = SpreadFunctions.longSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        long[] copy = new long[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, this.table.length);
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        return this.table.length >> 1;
    }

    private static boolean isNonSentinel(long value) {
        return value != 0L && value != 1L;
    }

    private class InternalLongIterator
    implements MutableLongIterator {
        private int count;
        private int position;
        private long zeroToThirtyOne;

        private InternalLongIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < LongHashSet.this.size();
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32L) {
                if (LongHashSet.this.contains(this.zeroToThirtyOne)) {
                    long result = this.zeroToThirtyOne++;
                    return result;
                }
                ++this.zeroToThirtyOne;
            }
            long[] table = LongHashSet.this.table;
            while (!LongHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            long result = table[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            long removeValue;
            if (this.count == 0) {
                throw new IllegalStateException();
            }
            if (this.zeroToThirtyOne <= 32L && this.position == 0) {
                if (LongHashSet.this.zeroToThirtyOne != (LongHashSet.this.zeroToThirtyOne | 1 << (int)(this.zeroToThirtyOne - 1L))) {
                    throw new IllegalStateException();
                }
                removeValue = this.zeroToThirtyOne - 1L;
            } else {
                if (LongHashSet.this.table[this.position - 1] == 1L) {
                    throw new IllegalStateException();
                }
                removeValue = LongHashSet.this.table[this.position - 1];
            }
            if (LongHashSet.isBetweenZeroAndThirtyOne(removeValue)) {
                LongHashSet.this.removeZeroToThirtyOne(removeValue);
            } else if (LongHashSet.this.table[this.position - 1] == removeValue) {
                if (LongHashSet.this.copyOnWrite) {
                    LongHashSet.this.copyTable();
                }
                ((LongHashSet)LongHashSet.this).table[this.position - 1] = 1L;
                LongHashSet.this.occupiedWithData--;
                LongHashSet.this.occupiedWithSentinels++;
            }
            --this.count;
        }
    }

    private static final class ImmutableLongHashSet
    extends AbstractImmutableLongSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableLongHashSet(long[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use LongSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableLongSet newSetWith(long ... elements) {
            return LongHashSet.newSetWith(elements).toImmutable();
        }

        @Override
        public int hashCode() {
            long value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (int)(value ^ value >>> 32);
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                    result += (int)(this.table[i] ^ this.table[i] >>> 32);
                }
            }
            return result;
        }

        @Override
        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                long value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (long value2 : this.table) {
                    if (!LongHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public LongIterator longIterator() {
            return new InternalLongIterator();
        }

        @Override
        public long[] toArray() {
            long value;
            long[] array = new long[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                array[j] = value = (long)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public long[] toArray(long[] array) {
            long value;
            if (array.length < this.size()) {
                array = new long[this.size()];
            }
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                array[j] = value = (long)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public boolean contains(long value) {
            if (LongHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> (int)value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        @Override
        public void each(LongProcedure procedure) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        @Override
        public ImmutableLongSet select(LongPredicate predicate) {
            return this.select(predicate, new LongHashSet()).toImmutable();
        }

        @Override
        public ImmutableLongSet reject(LongPredicate predicate) {
            return this.reject(predicate, new LongHashSet()).toImmutable();
        }

        @Override
        public <V> ImmutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            MutableSet set = this.collect(function, UnifiedSet.newSet(this.size()));
            return set.toImmutable();
        }

        @Override
        public long detectIfNone(LongPredicate predicate, long ifNone) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        @Override
        public int count(LongPredicate predicate) {
            long value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(LongPredicate predicate) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(LongPredicate predicate) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(LongPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public long sum() {
            long value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                result += value2;
            }
            return result;
        }

        @Override
        public long max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (long value : this.table) {
                if (!LongHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        @Override
        public long min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min2 = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (long value : this.table) {
                if (!LongHashSet.isNonSentinel(value) || isMinSet && value >= min2) continue;
                min2 = value;
                isMinSet = true;
            }
            return min2;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            long value;
            T result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        private Object writeReplace() {
            return new ImmutableLongSetSerializationProxy(this);
        }

        int probe(long element) {
            int index = this.spreadAndMask(element);
            long valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0L) {
                return index;
            }
            int removedIndex = valueAtIndex == 1L ? index : -1;
            for (int i = 1; i < 4; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                valueAtIndex = this.table[nextIndex];
                if (valueAtIndex == element) {
                    return nextIndex;
                }
                if (valueAtIndex == 0L) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1L || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeTwo(element, removedIndex);
        }

        int probeTwo(long element, int removedIndex) {
            int index = this.spreadTwoAndMask(element);
            for (int i = 0; i < 4; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                long valueAtIndex = this.table[nextIndex];
                if (valueAtIndex == element) {
                    return nextIndex;
                }
                if (valueAtIndex == 0L) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1L || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeThree(element, removedIndex);
        }

        int probeThree(long element, int removedIndex) {
            int nextIndex = (int)Long.reverse(SpreadFunctions.longSpreadOne(element));
            int spreadTwo = (int)Long.reverse(SpreadFunctions.longSpreadTwo(element)) | 1;
            long valueAtIndex;
            while ((valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
                if (valueAtIndex == 0L) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1L || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return nextIndex;
        }

        int spreadAndMask(long element) {
            long code = SpreadFunctions.longSpreadOne(element);
            return this.mask((int)code);
        }

        int spreadTwoAndMask(long element) {
            long code = SpreadFunctions.longSpreadTwo(element);
            return this.mask((int)code);
        }

        private int mask(int spread) {
            return spread & this.table.length - 1;
        }

        private class InternalLongIterator
        implements LongIterator {
            private int count;
            private int position;
            private long zeroToThirtyOne;

            private InternalLongIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.count < ImmutableLongHashSet.this.size();
            }

            @Override
            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32L) {
                    if (ImmutableLongHashSet.this.contains(this.zeroToThirtyOne)) {
                        long result = this.zeroToThirtyOne++;
                        return result;
                    }
                    ++this.zeroToThirtyOne;
                }
                long[] table = ImmutableLongHashSet.this.table;
                while (!LongHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                long result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

