/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;

public class SimpleAttributeOperand
extends FilterOperand
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=601");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=602");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=603");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15210");
    private final NodeId typeDefinitionId;
    private final QualifiedName[] browsePath;
    private final UInteger attributeId;
    private final String indexRange;

    public SimpleAttributeOperand(NodeId typeDefinitionId, QualifiedName[] browsePath, UInteger attributeId, String indexRange) {
        this.typeDefinitionId = typeDefinitionId;
        this.browsePath = browsePath;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getTypeDefinitionId() {
        return this.typeDefinitionId;
    }

    public QualifiedName[] getBrowsePath() {
        return this.browsePath;
    }

    public UInteger getAttributeId() {
        return this.attributeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    protected SimpleAttributeOperand(SimpleAttributeOperandBuilder<?, ?> b) {
        super((FilterOperand.FilterOperandBuilder<?, ?>)b);
        this.typeDefinitionId = ((SimpleAttributeOperandBuilder)b).typeDefinitionId;
        this.browsePath = ((SimpleAttributeOperandBuilder)b).browsePath;
        this.attributeId = ((SimpleAttributeOperandBuilder)b).attributeId;
        this.indexRange = ((SimpleAttributeOperandBuilder)b).indexRange;
    }

    public static SimpleAttributeOperandBuilder<?, ?> builder() {
        return new SimpleAttributeOperandBuilderImpl();
    }

    public SimpleAttributeOperandBuilder<?, ?> toBuilder() {
        return new SimpleAttributeOperandBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleAttributeOperand)) {
            return false;
        }
        SimpleAttributeOperand other = (SimpleAttributeOperand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeId this$typeDefinitionId = this.getTypeDefinitionId();
        NodeId other$typeDefinitionId = other.getTypeDefinitionId();
        if (this$typeDefinitionId == null ? other$typeDefinitionId != null : !((Object)this$typeDefinitionId).equals(other$typeDefinitionId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBrowsePath(), other.getBrowsePath())) {
            return false;
        }
        UInteger this$attributeId = this.getAttributeId();
        UInteger other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        String this$indexRange = this.getIndexRange();
        String other$indexRange = other.getIndexRange();
        return !(this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SimpleAttributeOperand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeId $typeDefinitionId = this.getTypeDefinitionId();
        result = result * 59 + ($typeDefinitionId == null ? 43 : ((Object)$typeDefinitionId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBrowsePath());
        UInteger $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        String $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SimpleAttributeOperand(typeDefinitionId=" + this.getTypeDefinitionId() + ", browsePath=" + Arrays.deepToString(this.getBrowsePath()) + ", attributeId=" + this.getAttributeId() + ", indexRange=" + this.getIndexRange() + ")";
    }

    private static final class SimpleAttributeOperandBuilderImpl
    extends SimpleAttributeOperandBuilder<SimpleAttributeOperand, SimpleAttributeOperandBuilderImpl> {
        private SimpleAttributeOperandBuilderImpl() {
        }

        @Override
        protected SimpleAttributeOperandBuilderImpl self() {
            return this;
        }

        @Override
        public SimpleAttributeOperand build() {
            return new SimpleAttributeOperand(this);
        }
    }

    public static abstract class SimpleAttributeOperandBuilder<C extends SimpleAttributeOperand, B extends SimpleAttributeOperandBuilder<C, B>>
    extends FilterOperand.FilterOperandBuilder<C, B> {
        private NodeId typeDefinitionId;
        private QualifiedName[] browsePath;
        private UInteger attributeId;
        private String indexRange;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SimpleAttributeOperandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SimpleAttributeOperand instance, SimpleAttributeOperandBuilder<?, ?> b) {
            b.typeDefinitionId(instance.typeDefinitionId);
            b.browsePath(instance.browsePath);
            b.attributeId(instance.attributeId);
            b.indexRange(instance.indexRange);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B typeDefinitionId(NodeId typeDefinitionId) {
            this.typeDefinitionId = typeDefinitionId;
            return (B)this.self();
        }

        public B browsePath(QualifiedName[] browsePath) {
            this.browsePath = browsePath;
            return (B)this.self();
        }

        public B attributeId(UInteger attributeId) {
            this.attributeId = attributeId;
            return (B)this.self();
        }

        public B indexRange(String indexRange) {
            this.indexRange = indexRange;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SimpleAttributeOperand.SimpleAttributeOperandBuilder(super=" + super.toString() + ", typeDefinitionId=" + this.typeDefinitionId + ", browsePath=" + Arrays.deepToString(this.browsePath) + ", attributeId=" + this.attributeId + ", indexRange=" + this.indexRange + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SimpleAttributeOperand> {
        @Override
        public Class<SimpleAttributeOperand> getType() {
            return SimpleAttributeOperand.class;
        }

        @Override
        public SimpleAttributeOperand decode(SerializationContext context, UaDecoder decoder) {
            NodeId typeDefinitionId = decoder.readNodeId("TypeDefinitionId");
            QualifiedName[] browsePath = decoder.readQualifiedNameArray("BrowsePath");
            UInteger attributeId = decoder.readUInt32("AttributeId");
            String indexRange = decoder.readString("IndexRange");
            return new SimpleAttributeOperand(typeDefinitionId, browsePath, attributeId, indexRange);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SimpleAttributeOperand value) {
            encoder.writeNodeId("TypeDefinitionId", value.getTypeDefinitionId());
            encoder.writeQualifiedNameArray("BrowsePath", value.getBrowsePath());
            encoder.writeUInt32("AttributeId", value.getAttributeId());
            encoder.writeString("IndexRange", value.getIndexRange());
        }
    }
}

