/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.slf4j.Logger;

public class ValidatorHtmlLib {
    public static final String jErrors = "errors";
    public static final String jWarnings = "warning";
    public static final String jParseError = "parse-error";
    public static final String jParseErrorLine = "parse-error-line";
    public static final String jParseErrorCol = "parse-error-column";
    public static Logger serviceLog = Fuseki.requestLog;
    public static final String cssFile = "../../css/fuseki.css";
    public static final String respService = "X-Service";

    private ValidatorHtmlLib() {
    }

    public static void output(ServletOutputStream outStream, Consumer<IndentedLineBuffer> content, boolean lineNumbers) throws IOException {
        ValidatorHtmlLib.startFixed(outStream);
        IndentedLineBuffer out = new IndentedLineBuffer(lineNumbers);
        content.accept(out);
        out.flush();
        String x = ValidatorHtmlLib.htmlQuote(out.asString());
        byte[] b = x.getBytes(StandardCharsets.UTF_8);
        outStream.write(b);
        ValidatorHtmlLib.finishFixed(outStream);
    }

    public static void setHeaders(HttpServletResponse httpResponse) {
        ServletBase.setCommonHeaders(httpResponse);
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("text/html");
        httpResponse.setHeader(respService, "Fuseki/ARQ SPARQL Query Validator: http://jena.apache.org/");
    }

    public static String htmlQuote(String str2) {
        StringBuilder sBuff = new StringBuilder();
        block5: for (int i = 0; i < str2.length(); ++i) {
            char ch = str2.charAt(i);
            switch (ch) {
                case '<': {
                    sBuff.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sBuff.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sBuff.append("&amp;");
                    continue block5;
                }
                default: {
                    sBuff.append(ch);
                }
            }
        }
        return sBuff.toString();
    }

    public static void startFixed(ServletOutputStream outStream) throws IOException {
        outStream.println("<pre class=\"box\">");
    }

    public static void columns(String prefix, ServletOutputStream outStream) throws IOException {
        outStream.print(prefix);
        outStream.println("         1         2         3         4         5         6         7");
        outStream.print(prefix);
        outStream.println("12345678901234567890123456789012345678901234567890123456789012345678901234567890");
    }

    public static void finishFixed(ServletOutputStream outStream) throws IOException {
        outStream.println("</pre>");
    }

    public static void printHead(ServletOutputStream outStream, String title) throws IOException {
        outStream.println("<head>");
        outStream.println(" <title>" + title + "</title>");
        outStream.println("   <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        if (cssFile != null) {
            outStream.println("   <link rel=\"stylesheet\" type=\"text/css\" href=\"../../css/fuseki.css\" />");
        }
        outStream.println("</head>");
    }
}

