/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.codec.BatchResult;
import org.osgi.jmx.framework.FrameworkMBean;

public class BatchInstallResult
extends BatchResult {
    private String[] remainingLocationItems;
    private String bundleInError;

    public BatchInstallResult(long[] completedItems) {
        this.completed = completedItems;
        this.success = true;
    }

    public BatchInstallResult(String error) {
        this.error = error;
        this.success = false;
    }

    public BatchInstallResult(long[] completedItems, String error, String[] remainingLocationItems, String bundleInError) {
        this(completedItems, error, remainingLocationItems, false, bundleInError);
    }

    public BatchInstallResult(long[] completedItems, String error, String[] remainingLocationItems, boolean success, String bundleInError) {
        this.bundleInError = bundleInError;
        this.completed = completedItems;
        this.error = error;
        this.remainingLocationItems = remainingLocationItems;
        this.success = success;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("BundleInError", this.bundleInError);
            items.put("Completed", this.toLongArray(this.completed));
            items.put("Error", this.error);
            items.put("Remaining", this.remainingLocationItems);
            items.put("Success", this.success);
            return new CompositeDataSupport(FrameworkMBean.BATCH_INSTALL_RESULT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static BatchInstallResult from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String bundleInError = (String)data.get("BundleInError");
        long[] completedItems = BatchInstallResult.toLongPrimitiveArray((Long[])data.get("Completed"));
        String[] remainingLocationItems = (String[])data.get("Remaining");
        String error = (String)data.get("Error");
        boolean success = (Boolean)data.get("Success");
        return new BatchInstallResult(completedItems, error, remainingLocationItems, success, bundleInError);
    }

    public String[] getRemainingLocationItems() {
        return this.remainingLocationItems;
    }

    public String getBundleInError() {
        return this.bundleInError;
    }
}

