/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hadoopauth.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.hadoopauth.HadoopAuthMessages;
import org.apache.knox.gateway.hadoopauth.filter.HadoopAuthFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.filter.JWTFederationFilter;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;

public class HadoopAuthPostFilter
implements Filter {
    private static HadoopAuthMessages log = (HadoopAuthMessages)MessagesFactory.get(HadoopAuthMessages.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private JWTFederationFilter jwtFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        String supportJwt = filterConfig.getInitParameter("support.jwt");
        boolean jwtSupported = Boolean.parseBoolean(supportJwt == null ? "false" : supportJwt);
        if (jwtSupported) {
            this.jwtFilter = new JWTFederationFilter();
            this.jwtFilter.init(filterConfig);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject subject = null;
        if (HadoopAuthFilter.shouldUseJwtFilter(this.jwtFilter, (HttpServletRequest)request)) {
            try {
                Pair wireToken = this.jwtFilter.getWireToken(request);
                JWTFederationFilter.TokenType tokenType = (JWTFederationFilter.TokenType)wireToken.getLeft();
                String token = (String)wireToken.getRight();
                if (JWTFederationFilter.TokenType.JWT.equals((Object)tokenType)) {
                    subject = this.jwtFilter.createSubjectFromToken(token);
                } else if (JWTFederationFilter.TokenType.Passcode.equals((Object)tokenType)) {
                    subject = this.jwtFilter.createSubjectFromTokenIdentifier(token);
                }
            }
            catch (ParseException | UnknownTokenException wireToken) {}
        } else {
            String principal = ((HttpServletRequest)request).getRemoteUser();
            if (principal != null) {
                subject = new Subject();
                String realUserName = (String)request.getAttribute("real.user.name");
                if (StringUtils.isNotBlank((CharSequence)realUserName)) {
                    subject.getPrincipals().add((Principal)new PrimaryPrincipal(realUserName));
                    subject.getPrincipals().add((Principal)new ImpersonatedPrincipal(principal));
                } else {
                    subject.getPrincipals().add((Principal)new PrimaryPrincipal(principal));
                }
                AuditContext context = auditService.getContext();
                context.setUsername(principal);
                auditService.attachContext(context);
            }
        }
        if (subject != null) {
            log.hadoopAuthAssertedPrincipal(this.getPrincipalsAsString(subject));
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            auditor.audit("authentication", sourceUri, "uri", "success");
            this.doAs(request, response, chain, subject);
        } else {
            ((HttpServletResponse)response).sendError(403, "User not authenticated");
        }
    }

    private String getPrincipalsAsString(Subject subject) {
        return String.join((CharSequence)",", subject.getPrincipals().stream().map(principal -> principal.getName()).collect(Collectors.toSet()));
    }

    private void doAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }
}

