/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControlOutputStyle;
import net.htmlparser.jericho.FormControlType;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;

public abstract class FormControl
extends Segment {
    FormControlType formControlType;
    String name;
    ElementContainer elementContainer;
    FormControlOutputStyle outputStyle = FormControlOutputStyle.NORMAL;
    private static final String CHECKBOX_NULL_DEFAULT_VALUE = "on";
    private static Comparator<FormControl> COMPARATOR = new PositionComparator();

    static FormControl construct(Element element) {
        String string = element.getStartTag().getName();
        if (string == "input") {
            String string2 = element.getAttributes().getRawValue("type");
            if (string2 == null) {
                return new InputFormControl(element, FormControlType.TEXT);
            }
            FormControlType formControlType = FormControlType.getFromInputElementType(string2);
            if (formControlType == null) {
                if (FormControlType.isNonFormControl(string2)) {
                    return null;
                }
                if (element.source.logger.isErrorEnabled()) {
                    element.source.logger.error(element.source.getRowColumnVector(element.begin).appendTo(new StringBuilder(200)).append(": INPUT control with unrecognised type \"").append(string2).append("\" assumed to be type \"text\"").toString());
                }
                formControlType = FormControlType.TEXT;
            }
            switch (formControlType) {
                case TEXT: {
                    return new InputFormControl(element, formControlType);
                }
                case CHECKBOX: 
                case RADIO: {
                    return new RadioCheckboxFormControl(element, formControlType);
                }
                case SUBMIT: {
                    return new SubmitFormControl(element, formControlType);
                }
                case IMAGE: {
                    return new ImageSubmitFormControl(element);
                }
                case HIDDEN: 
                case PASSWORD: 
                case FILE: {
                    return new InputFormControl(element, formControlType);
                }
            }
            throw new AssertionError((Object)formControlType);
        }
        if (string == "select") {
            return new SelectFormControl(element);
        }
        if (string == "textarea") {
            return new TextAreaFormControl(element);
        }
        if (string == "button") {
            return "submit".equalsIgnoreCase(element.getAttributes().getRawValue("type")) ? new SubmitFormControl(element, FormControlType.BUTTON) : null;
        }
        return null;
    }

    private FormControl(Element element, FormControlType formControlType, boolean bl) {
        super(element.source, element.begin, element.end);
        this.elementContainer = new ElementContainer(element, bl);
        this.formControlType = formControlType;
        this.name = element.getAttributes().getValue("name");
        this.verifyName();
    }

    public final FormControlType getFormControlType() {
        return this.formControlType;
    }

    public final String getName() {
        return this.name;
    }

    public final Element getElement() {
        return this.elementContainer.element;
    }

    public Iterator<Element> getOptionElementIterator() {
        throw new UnsupportedOperationException("Only SELECT controls contain OPTION elements");
    }

    public FormControlOutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(FormControlOutputStyle formControlOutputStyle) {
        this.outputStyle = formControlOutputStyle;
    }

    public final Map<String, String> getAttributesMap() {
        return this.elementContainer.getAttributesMap();
    }

    public final boolean isDisabled() {
        return this.elementContainer.getBooleanAttribute("disabled");
    }

    public final void setDisabled(boolean bl) {
        this.elementContainer.setBooleanAttribute("disabled", bl);
    }

    public boolean isChecked() {
        throw new UnsupportedOperationException("This property is only relevant for CHECKBOX and RADIO controls");
    }

    public String getPredefinedValue() {
        return this.elementContainer.predefinedValue;
    }

    public Collection<String> getPredefinedValues() {
        if (this.getPredefinedValue() == null) {
            Collections.emptySet();
        }
        return Collections.singleton(this.getPredefinedValue());
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.addValuesTo(arrayList);
        return arrayList;
    }

    public final void clearValues() {
        this.setValue(null);
    }

    public abstract boolean setValue(String var1);

    public boolean addValue(String string) {
        return this.setValue(string);
    }

    abstract void addValuesTo(Collection<String> var1);

    abstract void addToFormFields(FormFields var1);

    abstract void replaceInOutputDocument(OutputDocument var1);

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.formControlType);
        if (this.name != null) {
            stringBuilder.append(" name=\"").append(this.name).append('\"');
        }
        if (this.elementContainer.predefinedValue != null) {
            stringBuilder.append(" PredefinedValue=\"").append(this.elementContainer.predefinedValue).append('\"');
        }
        stringBuilder.append(" - ").append(this.getElement().getDebugInfo());
        return stringBuilder.toString();
    }

    final String getDisplayValueHTML(CharSequence charSequence, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder((charSequence == null ? 0 : charSequence.length() * 2) + 50);
        stringBuilder.append('<').append(FormControlOutputStyle.ConfigDisplayValue.ElementName);
        try {
            for (String string : FormControlOutputStyle.ConfigDisplayValue.AttributeNames) {
                String string2 = this.elementContainer.getAttributeValue(string);
                if (string2 == null) continue;
                Attribute.appendHTML(stringBuilder, string, string2);
            }
            stringBuilder.append('>');
            if (charSequence == null || charSequence.length() == 0) {
                stringBuilder.append(FormControlOutputStyle.ConfigDisplayValue.EmptyHTML);
            } else if (bl) {
                stringBuilder.append(CharacterReference.encodeWithWhiteSpaceFormatting(charSequence));
            } else {
                CharacterReference.appendEncode((Appendable)stringBuilder, charSequence, false);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        stringBuilder.append("</").append(FormControlOutputStyle.ConfigDisplayValue.ElementName).append('>');
        return stringBuilder.toString();
    }

    final void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
        this.elementContainer.replaceAttributesInOutputDocumentIfModified(outputDocument);
    }

    static List<FormControl> getAll(Segment segment) {
        ArrayList<FormControl> arrayList = new ArrayList<FormControl>();
        FormControl.getAll(segment, arrayList, "input");
        FormControl.getAll(segment, arrayList, "textarea");
        FormControl.getAll(segment, arrayList, "select");
        FormControl.getAll(segment, arrayList, "button");
        Collections.sort(arrayList, COMPARATOR);
        return arrayList;
    }

    private static void getAll(Segment segment, ArrayList<FormControl> arrayList, String string) {
        for (Element element : segment.getAllElements(string)) {
            FormControl formControl = element.getFormControl();
            if (formControl == null) continue;
            arrayList.add(formControl);
        }
    }

    private static String getString(char c, int n) {
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void verifyName() {
        if (this.formControlType.isSubmit()) {
            return;
        }
        if (this.name == null) {
            return;
        }
        if (this.name.length() != 0) {
            return;
        }
        Source source = this.getElement().source;
        if (source.logger.isErrorEnabled()) {
            source.logger.error(this.getElement().source.getRowColumnVector(this.getElement().begin).appendTo(new StringBuilder(200)).append(": compulsory \"name\" attribute of ").append((Object)this.formControlType).append(" control is empty").toString());
        }
    }

    private static final void addValueTo(Collection<String> collection, String string) {
        collection.add(string != null ? string : "");
    }

    static final class ElementContainer {
        public final Element element;
        public Map<String, String> attributesMap = null;
        public String predefinedValue;

        public ElementContainer(Element element, boolean bl) {
            this.element = element;
            this.predefinedValue = bl ? element.getAttributes().getValue("value") : null;
        }

        public Map<String, String> getAttributesMap() {
            if (this.attributesMap == null) {
                this.attributesMap = this.element.getAttributes().getMap(true);
            }
            return this.attributesMap;
        }

        public boolean setSelected(String string, String string2, boolean bl) {
            if (string != null && this.predefinedValue.equals(string.toString())) {
                this.setBooleanAttribute(string2, true);
                return true;
            }
            if (!bl) {
                this.setBooleanAttribute(string2, false);
            }
            return false;
        }

        public String getAttributeValue(String string) {
            if (this.attributesMap != null) {
                return this.attributesMap.get(string);
            }
            return this.element.getAttributes().getValue(string);
        }

        public void setAttributeValue(String string, String string2) {
            if (string2 == null) {
                this.setBooleanAttribute(string, false);
                return;
            }
            if (this.attributesMap != null) {
                this.attributesMap.put(string, string2);
                return;
            }
            String string3 = this.getAttributeValue(string);
            if (string3 != null && string3.equals(string2)) {
                return;
            }
            this.getAttributesMap().put(string, string2);
        }

        public boolean getBooleanAttribute(String string) {
            if (this.attributesMap != null) {
                return this.attributesMap.containsKey(string);
            }
            return this.element.getAttributes().get(string) != null;
        }

        public void setBooleanAttribute(String string, boolean bl) {
            boolean bl2 = this.getBooleanAttribute(string);
            if (bl == bl2) {
                return;
            }
            if (bl) {
                this.getAttributesMap().put(string, string);
            } else {
                this.getAttributesMap().remove(string);
            }
        }

        public void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
            if (this.attributesMap != null) {
                outputDocument.replace(this.element.getAttributes(), this.attributesMap);
            }
        }
    }

    private static final class PositionComparator
    implements Comparator<FormControl> {
        private PositionComparator() {
        }

        @Override
        public int compare(FormControl formControl, FormControl formControl2) {
            int n;
            int n2 = formControl.getElement().getBegin();
            if (n2 < (n = formControl2.getElement().getBegin())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    static final class SelectFormControl
    extends FormControl {
        public ElementContainer[] optionElementContainers;

        public SelectFormControl(Element element) {
            super(element, element.getAttributes().get("multiple") != null ? FormControlType.SELECT_MULTIPLE : FormControlType.SELECT_SINGLE, false);
            List<Element> list = element.getAllElements("option");
            this.optionElementContainers = new ElementContainer[list.size()];
            int n = 0;
            for (Element element2 : list) {
                ElementContainer elementContainer = new ElementContainer(element2, true);
                if (elementContainer.predefinedValue == null) {
                    elementContainer.predefinedValue = CharacterReference.decodeCollapseWhiteSpace(elementContainer.element.getContent());
                }
                this.optionElementContainers[n++] = elementContainer;
            }
        }

        @Override
        public String getPredefinedValue() {
            throw new UnsupportedOperationException("Use getPredefinedValues() method instead on SELECT controls");
        }

        @Override
        public Collection<String> getPredefinedValues() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.optionElementContainers.length * 2, 1.0f);
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                linkedHashSet.add(this.optionElementContainers[i].predefinedValue);
            }
            return linkedHashSet;
        }

        @Override
        public Iterator<Element> getOptionElementIterator() {
            return new OptionElementIterator();
        }

        @Override
        public boolean setValue(String string) {
            return this.addValue(string, false);
        }

        @Override
        public boolean addValue(String string) {
            return this.addValue(string, this.formControlType == FormControlType.SELECT_MULTIPLE);
        }

        private boolean addValue(String string, boolean bl) {
            boolean bl2 = false;
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].setSelected(string, "selected", bl)) continue;
                bl2 = true;
            }
            return bl2;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                FormControl.addValueTo(collection, this.optionElementContainers[i].predefinedValue);
            }
        }

        @Override
        void addToFormFields(FormFields formFields) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                formFields.add(this, this.optionElementContainers[i].predefinedValue);
            }
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                    stringBuilder.append(SelectFormControl.getOptionLabel(this.optionElementContainers[i].element));
                    stringBuilder.append(FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.setLength(stringBuilder.length() - FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator.length());
                }
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(stringBuilder, false));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    this.optionElementContainers[i].replaceAttributesInOutputDocumentIfModified(outputDocument);
                }
            }
        }

        private static String getOptionLabel(Element element) {
            String string = element.getAttributeValue("label");
            if (string != null) {
                return string;
            }
            return CharacterReference.decodeCollapseWhiteSpace(element.getContent());
        }

        private final class OptionElementIterator
        implements Iterator<Element> {
            private int i = 0;

            private OptionElementIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.i < SelectFormControl.this.optionElementContainers.length;
            }

            @Override
            public Element next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SelectFormControl.this.optionElementContainers[this.i++].element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class ImageSubmitFormControl
    extends SubmitFormControl {
        public ImageSubmitFormControl(Element element) {
            super(element, FormControlType.IMAGE);
        }

        @Override
        void addToFormFields(FormFields formFields) {
            super.addToFormFields(formFields);
            formFields.addName(this, this.name + ".x");
            formFields.addName(this, this.name + ".y");
        }
    }

    static class SubmitFormControl
    extends FormControl {
        public SubmitFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
        }

        @Override
        public boolean setValue(String string) {
            return false;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
        }

        @Override
        void addToFormFields(FormFields formFields) {
            if (this.getPredefinedValue() != null) {
                formFields.add(this);
            }
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class RadioCheckboxFormControl
    extends FormControl {
        public RadioCheckboxFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
            if (this.elementContainer.predefinedValue == null) {
                this.elementContainer.predefinedValue = FormControl.CHECKBOX_NULL_DEFAULT_VALUE;
                if (element.source.logger.isErrorEnabled()) {
                    element.source.logger.error(element.source.getRowColumnVector(element.begin).appendTo(new StringBuilder(200)).append(": compulsory \"value\" attribute of ").append((Object)formControlType).append(" control \"").append(this.name).append("\" is missing, assuming the value \"").append(FormControl.CHECKBOX_NULL_DEFAULT_VALUE).append('\"').toString());
                }
            }
        }

        @Override
        public boolean setValue(String string) {
            return this.elementContainer.setSelected(string, "checked", false);
        }

        @Override
        public boolean addValue(String string) {
            return this.elementContainer.setSelected(string, "checked", this.formControlType == FormControlType.CHECKBOX);
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            if (this.isChecked()) {
                FormControl.addValueTo(collection, this.getPredefinedValue());
            }
        }

        @Override
        public boolean isChecked() {
            return this.elementContainer.getBooleanAttribute("checked");
        }

        @Override
        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    String string;
                    String string2 = string = this.isChecked() ? FormControlOutputStyle.ConfigDisplayValue.CheckedHTML : FormControlOutputStyle.ConfigDisplayValue.UncheckedHTML;
                    if (string != null) {
                        outputDocument.replace(this.getElement(), string);
                        return;
                    }
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class TextAreaFormControl
    extends FormControl {
        public String value = UNCHANGED;
        private static final String UNCHANGED = new String();

        public TextAreaFormControl(Element element) {
            super(element, FormControlType.TEXTAREA, false);
        }

        @Override
        public boolean setValue(String string) {
            this.value = string;
            return true;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            FormControl.addValueTo(collection, this.getValue());
        }

        @Override
        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(this.getValue(), true));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                if (this.value != UNCHANGED) {
                    outputDocument.replace(this.getElement().getContent(), CharacterReference.encode(this.value, false));
                }
            }
        }

        private String getValue() {
            return this.value == UNCHANGED ? CharacterReference.decode(this.getElement().getContent()) : this.value;
        }
    }

    static final class InputFormControl
    extends FormControl {
        public InputFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, false);
        }

        @Override
        public boolean setValue(String string) {
            this.elementContainer.setAttributeValue("value", string);
            return true;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            FormControl.addValueTo(collection, this.elementContainer.getAttributeValue("value"));
        }

        @Override
        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                String string = null;
                if (this.formControlType != FormControlType.HIDDEN) {
                    String string2 = this.elementContainer.getAttributeValue("value");
                    if (this.formControlType == FormControlType.PASSWORD && string2 != null) {
                        string2 = FormControl.getString(FormControlOutputStyle.ConfigDisplayValue.PasswordChar, string2.length());
                    }
                    string = this.getDisplayValueHTML(string2, false);
                }
                outputDocument.replace(this.getElement(), string);
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }
}

