/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.step.build.partition;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.engine.spark.builder.PartitionDictionaryBuilderHelper;
import org.apache.kylin.engine.spark.job.PartitionExec;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.step.ParamPropagation;
import org.apache.kylin.engine.spark.job.step.build.FlatTableStage;
import org.apache.kylin.engine.spark.model.PartitionFlatTableDesc;
import org.apache.kylin.engine.spark.smarter.IndexDependencyParser;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.AdaptiveSpanningTree;
import org.apache.kylin.metadata.cube.cuboid.PartitionSpanningTree;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.datasource.storage.StorageListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d!\u0002\n\u0014\u0003\u00031\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\t\u0011Q\u0002!\u0011!Q\u0001\nEB\u0001\"\u000e\u0001\u0003\u0006\u0004%IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005o!A!\t\u0001BC\u0002\u0013%1\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\u0001\u0006A1A\u0005\u0016ECaa\u0018\u0001!\u0002\u001b\u0011\u0006\u0002\u00031\u0001\u0011\u000b\u0007I\u0011K1\t\u0011!\u0004\u0001R1A\u0005R%DQa\u001c\u0001\u0005\u0002ADq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011Q\u000e\u0001\u0005B\u0005\u0015\u0004bBA8\u0001\u0011E\u0013\u0011\u000f\u0002\u0018!\u0006\u0014H/\u001b;j_:4E.\u0019;UC\ndWm\u0015;bO\u0016T!\u0001F\u000b\u0002\u0013A\f'\u000f^5uS>t'B\u0001\f\u0018\u0003\u0015\u0011W/\u001b7e\u0015\tA\u0012$\u0001\u0003ti\u0016\u0004(B\u0001\u000e\u001c\u0003\rQwN\u0019\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0015tw-\u001b8f\u0015\t\u0001\u0013%A\u0003ls2LgN\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001dZ\u0003C\u0001\u0015*\u001b\u0005)\u0012B\u0001\u0016\u0016\u000591E.\u0019;UC\ndWm\u0015;bO\u0016\u0004\"\u0001L\u0017\u000e\u0003eI!AL\r\u0003\u001bA\u000b'\u000f^5uS>tW\t_3d\u0003)QwNY\"p]R,\u0007\u0010^\u000b\u0002cA\u0011AFM\u0005\u0003ge\u0011!bU3h[\u0016tGOS8c\u0003-QwNY\"p]R,\u0007\u0010\u001e\u0011\u0002\u0017\u0011\fG/Y*fO6,g\u000e^\u000b\u0002oA\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\u0006[>$W\r\u001c\u0006\u0003yu\nAaY;cK*\u0011ahH\u0001\t[\u0016$\u0018\rZ1uC&\u0011\u0001)\u000f\u0002\r\u001d\u0012\u000bG/Y*fO6,g\u000e^\u0001\rI\u0006$\u0018mU3h[\u0016tG\u000fI\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0003\u0011\u0003\"!\u0012$\u000e\u0003]I!aR\f\u0003!A\u000b'/Y7Qe>\u0004\u0018mZ1uS>t\u0017a\u00029be\u0006l7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-kej\u0014\t\u0003\u0019\u0002i\u0011a\u0005\u0005\u0006_\u001d\u0001\r!\r\u0005\u0006k\u001d\u0001\ra\u000e\u0005\u0006\u0005\u001e\u0001\r\u0001R\u0001\u000b]\u0016<()^2lKR\u001cX#\u0001*\u0011\u0007MC&,D\u0001U\u0015\t)f+\u0001\u0006d_2dWm\u0019;j_:T\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033R\u00131aU3r!\tYV,D\u0001]\u0015\tQR(\u0003\u0002_9\nI!j\u001c2Ck\u000e\\W\r^\u0001\f]\u0016<()^2lKR\u001c\b%\u0001\u0007ta\u0006tg.\u001b8h)J,W-F\u0001c!\t\u0019g-D\u0001e\u0015\t)7(\u0001\u0004dk\n|\u0017\u000eZ\u0005\u0003O\u0012\u0014Q\u0003U1si&$\u0018n\u001c8Ta\u0006tg.\u001b8h)J,W-A\u0005uC\ndW\rR3tGV\t!\u000e\u0005\u0002l[6\tAN\u0003\u0002;7%\u0011a\u000e\u001c\u0002\u0017!\u0006\u0014H/\u001b;j_:4E.\u0019;UC\ndW\rR3tG\u0006Ir-\u0019;iKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi&\u001cH/[2t)\u0015\t\u0018qCA\u0011!\r\u0011\u0018\u0011\u0003\b\u0004g\u00065ab\u0001;\u0002\f9\u0019Q/!\u0003\u000f\u0007Y\f9AD\u0002x\u0003\u000bq1\u0001_A\u0002\u001d\rI\u0018\u0011\u0001\b\u0003u~t!a\u001f@\u000e\u0003qT!!`\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011A$H\u0005\u00035mI!\u0001G\r\n\u0005Y9\u0012bAA\b+\u0005qa\t\\1u)\u0006\u0014G.Z*uC\u001e,\u0017\u0002BA\n\u0003+\u0011!b\u0015;bi&\u001cH/[2t\u0015\r\ty!\u0006\u0005\u0007)1\u0001\r!!\u0007\u0011\t\u0005m\u0011QD\u0007\u0002-&\u0019\u0011q\u0004,\u0003\t1{gn\u001a\u0005\b\u0003Ga\u0001\u0019AA\u0013\u0003\u001d!\u0018M\u00197f\tN\u0003b!a\n\u00020\u0005MRBAA\u0015\u0015\u0011\tY#!\f\u0002\u0007M\fHN\u0003\u0002\u001dC%!\u0011\u0011GA\u0015\u0005\u001d!\u0015\r^1tKR\u0004B!a\n\u00026%!\u0011qGA\u0015\u0005\r\u0011vn^\u0001\u000fO\u0016$\b+\u0019:uSRLwN\u001c#T)\u0011\t)#!\u0010\t\rQi\u0001\u0019AA\r\u00039\u0001(/\u001a9be\u00164uN\u001d#jGR$\"!a\u0011\u0011\u0019\u0005m\u0011QIA%\u0003\u0013\nI%!\u0013\n\u0007\u0005\u001dcK\u0001\u0004UkBdW\r\u000e\t\u0007\u0003\u0017\n\u0019&!\u0017\u000f\t\u00055\u0013q\n\t\u0003wZK1!!\u0015W\u0003\u0019\u0001&/\u001a3fM&!\u0011QKA,\u0005\r\u0019V\r\u001e\u0006\u0004\u0003#2\u0006\u0003BA.\u0003?j!!!\u0018\u000b\u0005ij\u0014\u0002BA1\u0003;\u0012\u0011\u0002\u00162m\u0007>d'+\u001a4\u0002!%t\u0017\u000e^*qC:t\u0017N\\4Ue\u0016,GCAA4!\u0011\tY\"!\u001b\n\u0007\u0005-dK\u0001\u0003V]&$\u0018!E5oSR4E.\u0019;UC\ndW\rR3tG\u0006\u0011\u0012\r\u001d9msB\u000b'\u000f^5uS>tG)Z:d)\u0011\t)#a\u001d\t\u000f\u0005U\u0014\u00031\u0001\u0002&\u0005AqN]5hS:$5\u000b")
public abstract class PartitionFlatTableStage
extends FlatTableStage
implements PartitionExec {
    private PartitionSpanningTree spanningTree;
    private PartitionFlatTableDesc tableDesc;
    private final SegmentJob jobContext;
    private final NDataSegment dataSegment;
    private final ParamPropagation params;
    private final Seq<JobBucket> newBuckets;
    private List<Long> partitions;
    private Set<Integer> partitionColumns;
    private volatile byte bitmap$0;

    @Override
    public final void newLayoutPartition(NDataSegment dataSegment, LayoutEntity layout, Long partitionId, Dataset<Row> layoutDS, String readableDesc, Option<StorageListener> storageListener) {
        PartitionExec.newLayoutPartition$(this, dataSegment, layout, partitionId, layoutDS, readableDesc, storageListener);
    }

    @Override
    public Set<Integer> wrapDimensions(LayoutEntity layout) {
        return PartitionExec.wrapDimensions$(this, layout);
    }

    @Override
    public void drain(long timeout, TimeUnit unit) {
        PartitionExec.drain$(this, timeout, unit);
    }

    @Override
    public long drain$default$1() {
        return PartitionExec.drain$default$1$(this);
    }

    @Override
    public TimeUnit drain$default$2() {
        return PartitionExec.drain$default$2$(this);
    }

    @Override
    public final SegmentPartition newSegmentPartition(NDataSegment copiedSegment, long partitionId, List<SegmentPartition> newAdds) {
        return PartitionExec.newSegmentPartition$(this, copiedSegment, partitionId, newAdds);
    }

    @Override
    public final void mergeSegmentStatistics(NDataSegment copiedSegment) {
        PartitionExec.mergeSegmentStatistics$(this, copiedSegment);
    }

    private List<Long> partitions$lzycompute() {
        PartitionFlatTableStage partitionFlatTableStage = this;
        synchronized (partitionFlatTableStage) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.partitions = PartitionExec.partitions$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitions;
    }

    @Override
    public final List<Long> partitions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitions$lzycompute() : this.partitions;
    }

    private Set<Integer> partitionColumns$lzycompute() {
        PartitionFlatTableStage partitionFlatTableStage = this;
        synchronized (partitionFlatTableStage) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.partitionColumns = PartitionExec.partitionColumns$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.partitionColumns;
    }

    @Override
    public final Set<Integer> partitionColumns() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.partitionColumns$lzycompute() : this.partitionColumns;
    }

    private SegmentJob jobContext() {
        return this.jobContext;
    }

    private NDataSegment dataSegment() {
        return this.dataSegment;
    }

    private ParamPropagation params() {
        return this.params;
    }

    @Override
    public final Seq<JobBucket> newBuckets() {
        return this.newBuckets;
    }

    private PartitionSpanningTree spanningTree$lzycompute() {
        PartitionFlatTableStage partitionFlatTableStage = this;
        synchronized (partitionFlatTableStage) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spanningTree = this.params().getPartitionSpanningTree();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spanningTree;
    }

    public PartitionSpanningTree spanningTree() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spanningTree$lzycompute() : this.spanningTree;
    }

    private PartitionFlatTableDesc tableDesc$lzycompute() {
        PartitionFlatTableStage partitionFlatTableStage = this;
        synchronized (partitionFlatTableStage) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tableDesc = this.params().getTableDesc();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tableDesc;
    }

    @Override
    public PartitionFlatTableDesc tableDesc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tableDesc$lzycompute() : this.tableDesc;
    }

    public FlatTableStage.Statistics gatherPartitionStatistics(long partition, Dataset<Row> tableDS) {
        String desc = new StringBuilder(49).append("Segment ").append(this.segmentId()).append(" collect partition flat table statistics ").append(partition).toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> desc);
        this.sparkSession().sparkContext().setJobDescription(desc);
        FlatTableStage.Statistics statistics = this.gatherStats(tableDS);
        this.sparkSession().sparkContext().setJobDescription(null);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(desc).append(" ").append(statistics).toString());
        return statistics;
    }

    public Dataset<Row> getPartitionDS(long partition) {
        Buffer columnIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableDesc().getColumnIds()).asScala();
        Buffer columnName2Id = (Buffer)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableDesc().getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> column.getIdentity(), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)columnIds, Buffer$.MODULE$.canBuildFrom());
        Map column2IdMap = columnName2Id.toMap(Predef$.MODULE$.$conforms());
        Buffer partitionColumnIds = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.dataModel().getMultiPartitionDesc().getColumnRefs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getIdentity(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Integer)column2IdMap.apply(x), Buffer$.MODULE$.canBuildFrom());
        Seq values = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataModel().getMultiPartitionDesc().getPartitionInfo(partition).getValues())).toSeq();
        String converted = ((TraversableOnce)((TraversableLike)partitionColumnIds.zip((GenIterable)values, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer k = (Integer)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(7).append("`").append(k).append("` = '").append(v).append("'").toString();
            return string;
        }, Buffer$.MODULE$.canBuildFrom())).mkString(" and ");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Segment ").append(this.segmentId()).append(" single partition condition: ").append(converted).toString());
        return this.FLAT_TABLE().where(converted);
    }

    @Override
    public Tuple4<scala.collection.immutable.Set<TblColRef>, scala.collection.immutable.Set<TblColRef>, scala.collection.immutable.Set<TblColRef>, scala.collection.immutable.Set<TblColRef>> prepareForDict() {
        scala.collection.immutable.Set dictCols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(PartitionDictionaryBuilderHelper.extractTreeRelatedGlobalDictToBuild(this.dataSegment(), this.spanningTree().getIndices())).asScala()).toSet();
        scala.collection.immutable.Set encodeCols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(DictionaryBuilderHelper.extractTreeRelatedGlobalDicts(this.dataSegment(), this.spanningTree().getIndices())).asScala()).toSet();
        scala.collection.immutable.Set dictColsWithoutCc = (scala.collection.immutable.Set)dictCols.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PartitionFlatTableStage.$anonfun$prepareForDict$1(x$3)));
        scala.collection.immutable.Set encodeColsWithoutCc = (scala.collection.immutable.Set)encodeCols.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionFlatTableStage.$anonfun$prepareForDict$2(x$4)));
        return new Tuple4((Object)dictCols, (Object)encodeCols, (Object)dictColsWithoutCc, (Object)encodeColsWithoutCc);
    }

    @Override
    public void initSpanningTree() {
        PartitionSpanningTree spanTree = new PartitionSpanningTree(this.config(), new PartitionSpanningTree.PartitionTreeBuilder(this.dataSegment(), this.readOnlyLayouts(), this.jobId(), this.partitions(), (Set)Sets.newHashSet((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(this.newBuckets()).asJava()))));
        this.params().setPartitionSpanningTree(spanTree);
    }

    @Override
    public void initFlatTableDesc() {
        PartitionFlatTableDesc partitionFlatTableDesc;
        if (this.jobContext().isPartialBuild()) {
            IndexDependencyParser parser = new IndexDependencyParser(this.dataModel());
            List<String> relatedTableAlias = parser.getRelatedTablesAlias(this.jobContext().getReadOnlyLayouts());
            partitionFlatTableDesc = new PartitionFlatTableDesc(this.config(), this.dataSegment(), (AdaptiveSpanningTree)this.spanningTree(), relatedTableAlias, this.jobId(), this.partitions());
        } else {
            partitionFlatTableDesc = new PartitionFlatTableDesc(this.config(), this.dataSegment(), (AdaptiveSpanningTree)this.spanningTree(), this.jobId(), this.partitions());
        }
        PartitionFlatTableDesc tableDesc = partitionFlatTableDesc;
        this.params().setTableDesc(tableDesc);
    }

    @Override
    public Dataset<Row> applyPartitionDesc(Dataset<Row> originDS) {
        MultiPartitionDesc descMLP = this.dataModel().getMultiPartitionDesc();
        Predef$.MODULE$.require(Objects.nonNull(descMLP));
        PartitionDesc descDRP = this.dataModel().getPartitionDesc();
        String condition = descMLP.getPartitionConditionBuilder().buildMultiPartitionCondition(descDRP, descMLP, new LinkedList<Long>(this.tableDesc().getPartitions()), null, this.segmentRange());
        if (StringUtils.isBlank((CharSequence)condition)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Segment ").append(this.segmentId()).append(" no available partition condition.").toString());
            return originDS;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Segment ").append(this.segmentId()).append(" apply partition condition ").append(condition).append(".").toString());
        return originDS.where(condition);
    }

    public static final /* synthetic */ boolean $anonfun$newBuckets$1(PartitionFlatTableStage $this, JobBucket x$1) {
        return x$1.getSegmentId().equals($this.segmentId());
    }

    public static final /* synthetic */ boolean $anonfun$prepareForDict$1(TblColRef x$3) {
        return !x$3.getColumnDesc().isComputedColumn();
    }

    public static final /* synthetic */ boolean $anonfun$prepareForDict$2(TblColRef x$4) {
        return !x$4.getColumnDesc().isComputedColumn();
    }

    public PartitionFlatTableStage(SegmentJob jobContext, NDataSegment dataSegment, ParamPropagation params) {
        this.jobContext = jobContext;
        this.dataSegment = dataSegment;
        this.params = params;
        super(jobContext, dataSegment, params);
        PartitionExec.$init$(this);
        this.newBuckets = ((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(jobContext.getReadOnlyBuckets()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionFlatTableStage.$anonfun$newBuckets$1(this, x$1)))).toSeq();
    }
}

