/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import java.io.Serializable;
import java.net.URI;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jnet.Installer;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.kylin.common.constant.ObsConfig;
import org.apache.kylin.engine.spark.source.NSparkTableMeta;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.delta.DeltaTableUtils;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

public class NSparkTableMetaExplorer
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkTableMetaExplorer.class);
    private static final List<String> UNSUPOORT_TYPE = Lists.newArrayList((Object[])new String[]{"array", "map", "struct", "binary"});
    private static final String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY = "__CHAR_VARCHAR_TYPE_STRING";

    public NSparkTableMeta getSparkTableMeta(String database, String tableName) {
        SessionCatalog catalog = SparderEnv.getSparkSession().sessionState().catalog();
        TableIdentifier tableIdentifier = TableIdentifier.apply((String)tableName, (Option)Option.apply((Object)(database.isEmpty() ? null : database)));
        CatalogTable tableMetadata = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
        this.checkTableIsValid(tableMetadata, tableIdentifier, tableName);
        return this.buildSparkTableMeta(tableName, tableMetadata);
    }

    public Set<String> checkAndGetTablePartitions(String database, String tableName, String partitionCol) {
        String firstPartCol;
        SessionCatalog catalog = SparderEnv.getSparkSession().sessionState().catalog();
        TableIdentifier tableIdentifier = TableIdentifier.apply((String)tableName, (Option)Option.apply((Object)(database.isEmpty() ? null : database)));
        CatalogTable tableMetadata = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
        String string = firstPartCol = tableMetadata.partitionColumnNames().isEmpty() ? null : ((String)tableMetadata.partitionColumnNames().head()).toLowerCase(Locale.ROOT);
        if (!partitionCol.equalsIgnoreCase(firstPartCol)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "table partition col %s not match col %s", firstPartCol, partitionCol));
        }
        return JavaConversions.seqAsJavaList((Seq)catalog.listPartitions(tableIdentifier, Option.empty())).stream().map(item -> JavaConversions.mapAsJavaMap((Map)item.spec()).entrySet().stream().filter(entry -> partitionCol.equalsIgnoreCase((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected NSparkTableMeta buildSparkTableMeta(String tableName, CatalogTable tableMetadata) {
        NSparkTableMeta.NSparkTableMetaBuilder builder = NSparkTableMeta.builder();
        builder.tableName(tableName);
        StructType allColSchema = tableMetadata.schema();
        if (DeltaTableUtils.isDeltaTable((CatalogTable)tableMetadata)) {
            allColSchema = SparderEnv.getSparkSession().table(tableMetadata.identifier()).schema();
        }
        builder.allColumns(this.getColumns(tableMetadata, allColSchema));
        builder.owner(tableMetadata.owner());
        builder.createTime(tableMetadata.createTime() + "");
        builder.lastAccessTime(tableMetadata.lastAccessTime() + "");
        builder.tableType(tableMetadata.tableType().name());
        builder.partitionColumns(this.getColumns(tableMetadata, tableMetadata.partitionSchema()));
        builder.isRangePartition(this.isRangePartition(tableMetadata));
        if (tableMetadata.comment().isDefined()) {
            builder.tableComment((String)tableMetadata.comment().get());
        }
        if (tableMetadata.storage().inputFormat().isDefined()) {
            builder.sdInputFormat((String)tableMetadata.storage().inputFormat().get());
        }
        if (tableMetadata.storage().outputFormat().isDefined()) {
            builder.sdOutputFormat((String)tableMetadata.storage().outputFormat().get());
        }
        Option uriOption = tableMetadata.storage().locationUri();
        ObsConfig obsConfig = ObsConfig.S3;
        if (uriOption.isDefined()) {
            builder.sdLocation(((URI)uriOption.get()).toString());
            obsConfig = ObsConfig.getByLocation((String)((URI)uriOption.get()).toString()).orElse(ObsConfig.S3);
        }
        if (tableMetadata.provider().isDefined()) {
            builder.provider((String)tableMetadata.provider().get());
        }
        if (tableMetadata.properties().contains((Object)"totalSize")) {
            builder.fileSize(Long.parseLong((String)tableMetadata.properties().get((Object)"totalSize").get()));
        }
        if (tableMetadata.properties().contains((Object)"numFiles")) {
            builder.fileNum(Long.parseLong((String)tableMetadata.properties().get((Object)"numFiles").get()));
        }
        if (tableMetadata.properties().contains((Object)"transactional")) {
            builder.isTransactional(Boolean.parseBoolean((String)tableMetadata.properties().get((Object)"transactional").get()));
        }
        if (tableMetadata.properties().contains((Object)obsConfig.getRolePropertiesKey())) {
            builder.roleArn((String)tableMetadata.properties().get((Object)obsConfig.getRolePropertiesKey()).get());
        }
        if (tableMetadata.properties().contains((Object)obsConfig.getEndpointPropertiesKey())) {
            builder.endpoint((String)tableMetadata.properties().get((Object)obsConfig.getEndpointPropertiesKey()).get());
        }
        if (tableMetadata.properties().contains((Object)obsConfig.getRegionPropertiesKey())) {
            builder.region((String)tableMetadata.properties().get((Object)obsConfig.getRegionPropertiesKey()).get());
        }
        builder.sourceType(9);
        return builder.build();
    }

    private List<NSparkTableMeta.SparkTableColumnMeta> getColumns(CatalogTable tableMetadata, StructType schema) {
        return this.getColumns(tableMetadata, schema, true);
    }

    private List<NSparkTableMeta.SparkTableColumnMeta> getColumns(CatalogTable tableMetadata, StructType schema, boolean isCheckRepeatColumn) {
        ArrayList allColumns = Lists.newArrayListWithCapacity((int)schema.size());
        HashSet columnCacheTemp = Sets.newHashSet();
        for (StructField field : schema.fields()) {
            String type = field.dataType().simpleString();
            if (field.metadata().contains(CHAR_VARCHAR_TYPE_STRING_METADATA_KEY)) {
                type = field.metadata().getString(CHAR_VARCHAR_TYPE_STRING_METADATA_KEY);
            }
            String finalType = type;
            if (UNSUPOORT_TYPE.stream().anyMatch(finalType::contains)) {
                logger.info("Load table {} ignore column {}:{}", new Object[]{tableMetadata.identifier().identifier(), field.name(), finalType});
                continue;
            }
            if (isCheckRepeatColumn && columnCacheTemp.contains(field.name())) {
                logger.info("The\u3010{}\u3011column is already included and does not need to be added again", (Object)field.name());
                continue;
            }
            columnCacheTemp.add(field.name());
            allColumns.add(new NSparkTableMeta.SparkTableColumnMeta(field.name(), type, field.getComment().isDefined() ? (String)field.getComment().get() : null));
        }
        return allColumns;
    }

    private void checkTableIsValid(CatalogTable tableMetadata, TableIdentifier tableIdentifier, String tableName) {
        if (CatalogTableType.VIEW().equals((Object)tableMetadata.tableType())) {
            try {
                Installer.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
                SparderEnv.getSparkSession().table(tableIdentifier).queryExecution().analyzed();
            }
            catch (Exception e) {
                throw new RuntimeException("Error for parser view: " + tableName + ", " + e.getMessage() + "(There are maybe syntactic differences between HIVE and SparkSQL)", e);
            }
        }
    }

    private Boolean isRangePartition(CatalogTable tableMetadata) {
        List<NSparkTableMeta.SparkTableColumnMeta> allColumns = this.getColumns(tableMetadata, tableMetadata.schema(), false);
        return allColumns.stream().collect(Collectors.groupingBy(p -> p.name)).values().stream().anyMatch(p -> p.size() > 1);
    }

    static enum PROVIDER {
        HIVE("hive"),
        UNSPECIFIED("");

        private static final PROVIDER[] ALL;
        private String value;

        private PROVIDER(String value) {
            this.value = value;
        }

        public static PROVIDER fromString(Option<String> value) {
            if (value.isEmpty()) {
                return UNSPECIFIED;
            }
            for (PROVIDER provider : ALL) {
                if (!provider.value.equals(value.get())) continue;
                return provider;
            }
            return UNSPECIFIED;
        }

        static {
            ALL = new PROVIDER[]{HIVE};
        }
    }
}

