/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.engine.spark.source.SparkSqlUtil;
import org.apache.kylin.source.IReadableTable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;

public class NSparkTableReader
implements IReadableTable.TableReader {
    private String dbName;
    private String tableName;
    private SparkSession ss;
    private List<Row> records;
    private Iterator<Row> iterator;
    private Row currentRow;

    public NSparkTableReader(String dbName, String tableName) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.initialize();
    }

    public static String[] getRowAsStringArray(Row record) {
        StructField[] fields = record.schema().fields();
        String[] arr = new String[fields.length];
        for (int i = 0; i < arr.length; ++i) {
            Object o = record.get(i);
            arr[i] = o == null ? null : o.toString();
        }
        return arr;
    }

    private void initialize() {
        this.ss = SparderEnv.getSparkSession();
        String master = this.ss.sparkContext().master();
        String tableIdentity = this.tableName;
        if (!master.toLowerCase(Locale.ROOT).contains("local")) {
            tableIdentity = String.format(Locale.ROOT, "%s.%s", this.dbName, this.tableName);
        }
        this.records = SparkSqlUtil.queryAll(this.ss, tableIdentity);
        this.iterator = this.records.iterator();
    }

    public boolean next() throws IOException {
        boolean hasNext;
        boolean bl = hasNext = this.iterator != null && this.iterator.hasNext();
        if (hasNext) {
            this.currentRow = this.iterator.next();
        }
        return hasNext;
    }

    public String[] getRow() {
        return NSparkTableReader.getRowAsStringArray(this.currentRow);
    }

    public void close() throws IOException {
        this.records = null;
        this.iterator = null;
        this.currentRow = null;
    }
}

