/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import io.delta.standalone.types.DataType;
import io.delta.standalone.types.FieldMetadata;
import java.util.Objects;

public final class StructField {
    private final String name;
    private final DataType dataType;
    private final boolean nullable;
    private final FieldMetadata metadata;

    public StructField(String string, DataType dataType) {
        this(string, dataType, true);
    }

    public StructField(String string, DataType dataType, boolean bl) {
        this(string, dataType, bl, FieldMetadata.builder().build());
    }

    public StructField(String string, DataType dataType, boolean bl, FieldMetadata fieldMetadata) {
        this.name = string;
        this.dataType = dataType;
        this.nullable = bl;
        this.metadata = fieldMetadata;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public FieldMetadata getMetadata() {
        return this.metadata;
    }

    protected void buildFormattedString(String string, StringBuilder stringBuilder) {
        String string2 = string + "    |";
        stringBuilder.append(String.format("%s-- %s: %s (nullable = %b) (metadata =%s)\n", string, this.name, this.dataType.getTypeName(), this.nullable, this.metadata.toString()));
        DataType.buildFormattedString(this.dataType, string2, stringBuilder);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructField structField = (StructField)object;
        return this.name.equals(structField.name) && this.dataType.equals(structField.dataType) && this.nullable == structField.nullable && this.metadata.equals(structField.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.nullable, this.metadata);
    }
}

