/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.bisync.model;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.metadata.model.JoinTableDesc;

public class JoinTreeNode {
    private JoinTableDesc value;
    private List<JoinTreeNode> childNodes;

    public JoinTableDesc getValue() {
        return this.value;
    }

    public void setValue(JoinTableDesc value) {
        this.value = value;
    }

    public List<JoinTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<JoinTreeNode> childNodes) {
        this.childNodes = childNodes;
    }

    public List<JoinTableDesc> iteratorAsList() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        LinkedList<JoinTreeNode> nodeDeque = new LinkedList<JoinTreeNode>();
        LinkedList<JoinTableDesc> elements = new LinkedList<JoinTableDesc>();
        nodeDeque.push(this);
        this.breadthSerialize(nodeDeque, elements);
        return elements;
    }

    private void breadthSerialize(Deque<JoinTreeNode> nodeDeque, List<JoinTableDesc> elements) {
        if (nodeDeque.isEmpty()) {
            return;
        }
        JoinTreeNode node = nodeDeque.removeFirst();
        elements.add(node.getValue());
        if (node.getChildNodes() != null) {
            for (JoinTreeNode childNode : node.getChildNodes()) {
                nodeDeque.addLast(childNode);
            }
        }
        this.breadthSerialize(nodeDeque, elements);
    }
}

