/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.net.URI;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.HistoryServer;
import org.apache.spark.deploy.history.HistoryServerBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"kylin.history-server.enable"}, havingValue="true")
public class SparkHistoryServer {
    @Bean(value={"historyServer"})
    public HistoryServer createHistoryServer() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        SparkConf sparkConf = new SparkConf();
        Map sparkConfigOverride = config.getSparkConfigOverride();
        for (Map.Entry entry : sparkConfigOverride.entrySet()) {
            sparkConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        String logDir = sparkConf.get("spark.eventLog.dir");
        Path logPath = new Path(new URI(logDir).getPath());
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (!fs.exists(logPath)) {
            fs.mkdirs(logPath);
        }
        sparkConf.set("spark.history.fs.logDirectory", sparkConf.get("spark.eventLog.dir"));
        return HistoryServerBuilder.createHistoryServer((SparkConf)sparkConf);
    }
}

