/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.condition.JobModeCondition;
import org.apache.kylin.job.core.AbstractJobExecutable;
import org.apache.kylin.job.core.lock.JdbcLockClient;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.mapper.JobInfoMapper;
import org.apache.kylin.job.mapper.JobLockMapper;
import org.apache.kylin.job.runners.JobCheckRunner;
import org.apache.kylin.job.runners.JobCheckUtil;
import org.apache.kylin.job.runners.QuotaStorageCheckRunner;
import org.apache.kylin.job.scheduler.JdbcJobScheduler;
import org.apache.kylin.job.scheduler.ResourceAcquirer;
import org.apache.kylin.job.scheduler.SharedFileProgressReporter;
import org.apache.kylin.rest.ISmartApplicationListenerForSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"springContext", "jobMybatisConfig"})
@Conditional(value={JobModeCondition.class})
public class JobContext
implements InitializingBean,
DisposableBean,
ISmartApplicationListenerForSystem {
    private static final Logger logger = LoggerFactory.getLogger((String)"build");
    private String serverNode;
    private KylinConfig kylinConfig;
    @Resource
    private JobInfoMapper jobInfoMapper;
    @Resource
    private JobLockMapper jobLockMapper;
    @Autowired
    private DataSourceTransactionManager transactionManager;
    private Map<String, Boolean> projectReachQuotaLimitMap;
    private ResourceAcquirer resourceAcquirer;
    private SharedFileProgressReporter progressReporter;
    private JdbcLockClient lockClient;
    private JdbcJobScheduler jobScheduler;

    public void destroy() throws Exception {
        if (Objects.nonNull(this.resourceAcquirer)) {
            this.resourceAcquirer.destroy();
        }
        if (Objects.nonNull(this.progressReporter)) {
            this.progressReporter.destroy();
        }
        if (Objects.nonNull(this.jobScheduler)) {
            this.jobScheduler.destroy();
        }
        if (Objects.nonNull(this.lockClient)) {
            this.lockClient.destroy();
        }
        JobCheckUtil.stopJobCheckScheduler();
    }

    @VisibleForTesting
    public void setJobInfoMapper(JobInfoMapper jobInfoMapper) {
        this.jobInfoMapper = jobInfoMapper;
    }

    @VisibleForTesting
    public void setJobLockMapper(JobLockMapper jobLockMapper) {
        this.jobLockMapper = jobLockMapper;
    }

    @VisibleForTesting
    public void setTransactionManager(DataSourceTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @VisibleForTesting
    public void init() {
        this.serverNode = AddressUtil.getLocalInstance();
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.projectReachQuotaLimitMap = Maps.newConcurrentMap();
        QuotaStorageCheckRunner quotaStorageCheckRunner = new QuotaStorageCheckRunner(this);
        JobCheckUtil.startQuotaStorageCheckRunner(quotaStorageCheckRunner);
        if (this.kylinConfig.isJobNode() || this.kylinConfig.isDataLoadingNode() || this.kylinConfig.isUTEnv()) {
            this.resourceAcquirer = new ResourceAcquirer(this.kylinConfig);
            this.resourceAcquirer.start();
            this.progressReporter = new SharedFileProgressReporter(this.kylinConfig);
            this.progressReporter.start();
            this.lockClient = new JdbcLockClient(this);
            this.lockClient.start();
            this.jobScheduler = new JdbcJobScheduler(this);
            this.jobScheduler.start();
            JobCheckRunner jobCheckRunner = new JobCheckRunner(this);
            JobCheckUtil.startJobCheckRunner(jobCheckRunner);
        }
    }

    public String getServerNode() {
        return this.serverNode;
    }

    public KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }

    @VisibleForTesting
    public void setKylinConfig(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobInfoMapper getJobInfoMapper() {
        return this.jobInfoMapper;
    }

    public JobLockMapper getJobLockMapper() {
        return this.jobLockMapper;
    }

    public ResourceAcquirer getResourceAcquirer() {
        return this.resourceAcquirer;
    }

    public SharedFileProgressReporter getProgressReporter() {
        return this.progressReporter;
    }

    public JdbcLockClient getLockClient() {
        return this.lockClient;
    }

    public JdbcJobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public void setJobScheduler(JdbcJobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void setProjectReachQuotaLimit(String project, Boolean reachQuotaLimit) {
        this.projectReachQuotaLimitMap.put(project, reachQuotaLimit);
    }

    public boolean isProjectReachQuotaLimit(String project) {
        if (!this.projectReachQuotaLimitMap.containsKey(project)) {
            return false;
        }
        return this.projectReachQuotaLimitMap.get(project);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            if (null == this.jobScheduler || !this.jobScheduler.hasRunningJob()) {
                return;
            }
            try (SetLogCategory ignored = new SetLogCategory("build");){
                logger.info("Stop kyligence node, kill spark application for cluster mode");
            }
            List<AbstractJobExecutable> runningJobs = this.jobScheduler.getRunningJob().values().stream().map(Pair::getFirst).collect(Collectors.toList());
            runningJobs.forEach(jobExecutable -> {
                ExecutableManager executableManager = ExecutableManager.getInstance(this.kylinConfig, jobExecutable.getProject());
                executableManager.cancelJobSubTasks((AbstractExecutable)jobExecutable);
            });
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

