/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kylin.common.util.CompositeMapView;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CompositeMapViewTest {
    private CompositeMapView<String, String> compositeMapView;

    CompositeMapViewTest() {
    }

    @BeforeEach
    void setup() {
        this.compositeMapView = this.prepareData();
    }

    private CompositeMapView<String, String> prepareData() {
        HashMap map1 = Maps.newHashMap();
        map1.put("k1", "v1");
        map1.put("k2", "v2");
        map1.put("k3", "v3");
        HashMap map2 = Maps.newHashMap();
        map2.put("k1", "vv1");
        map2.put("kk2", "vv2");
        map2.put("kk3", "v3");
        return new CompositeMapView(new Map[]{map1, map2});
    }

    @Test
    void testSize() {
        Assertions.assertEquals((int)5, (int)this.compositeMapView.size());
    }

    @Test
    void testIsEmpty() {
        Assertions.assertFalse((boolean)this.compositeMapView.isEmpty());
        CompositeMapView compositeMapView = new CompositeMapView(new Map[]{Maps.newHashMap(), Maps.newHashMap()});
        Assertions.assertTrue((boolean)compositeMapView.isEmpty());
    }

    @Test
    void testIsEmpty_Null() {
        Map emptyMap = Collections.emptyMap();
        Assertions.assertThrows(NullPointerException.class, () -> new CompositeMapView(new Map[]{null, null}));
        Assertions.assertThrows(NullPointerException.class, () -> new CompositeMapView(new Map[]{emptyMap, null}));
        Assertions.assertThrows(NullPointerException.class, () -> new CompositeMapView(new Map[]{null, emptyMap}));
    }

    @Test
    void testContainsKey() {
        Assertions.assertTrue((boolean)this.compositeMapView.containsKey((Object)"k1"));
        Assertions.assertTrue((boolean)this.compositeMapView.containsKey((Object)"kk3"));
        Assertions.assertTrue((boolean)this.compositeMapView.containsKey((Object)"k2"));
        Assertions.assertFalse((boolean)this.compositeMapView.containsKey((Object)"noKey"));
    }

    @Test
    void testContainsValue() {
        Assertions.assertTrue((boolean)this.compositeMapView.containsValue((Object)"v1"));
        Assertions.assertTrue((boolean)this.compositeMapView.containsValue((Object)"vv2"));
        Assertions.assertTrue((boolean)this.compositeMapView.containsValue((Object)"v2"));
        Assertions.assertFalse((boolean)this.compositeMapView.containsValue((Object)"noValue"));
    }

    @Test
    void testGetKey() {
        Assertions.assertEquals((Object)"vv1", (Object)this.compositeMapView.get((Object)"k1"));
        Assertions.assertEquals((Object)"v2", (Object)this.compositeMapView.get((Object)"k2"));
        Assertions.assertEquals((Object)"v3", (Object)this.compositeMapView.get((Object)"kk3"));
        Assertions.assertNull((Object)this.compositeMapView.get((Object)"notKey"));
    }

    @Test
    void testKeySet() {
        HashSet expectedKeySet = Sets.newHashSet(Arrays.asList("k1", "k2", "k3", "kk2", "kk3"));
        Assertions.assertEquals((Object)expectedKeySet, (Object)this.compositeMapView.keySet());
    }

    @Test
    void testValues() {
        HashSet expectedValueSet = Sets.newHashSet(Arrays.asList("v1", "v2", "v3", "vv1", "vv2", "v3"));
        Assertions.assertTrue((boolean)expectedValueSet.containsAll(this.compositeMapView.values()));
        Assertions.assertEquals((int)expectedValueSet.size(), (int)this.compositeMapView.values().size());
    }

    @Test
    void testEntrySet() {
        List entryList = this.compositeMapView.entrySet().stream().sorted(Map.Entry.comparingByKey(String::compareTo)).map(e -> (String)e.getKey() + "," + (String)e.getValue()).collect(Collectors.toList());
        List<String> expectedEntryList = Arrays.asList("k1,vv1", "k2,v2", "k3,v3", "kk2,vv2", "kk3,v3");
        Assertions.assertEquals(expectedEntryList, entryList);
    }

    @Test
    void testNotSupport() {
        Map emptyMap = Collections.emptyMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.put((Object)"a", (Object)"b");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.putIfAbsent((Object)"a", (Object)"b");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.remove((Object)"a");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.remove((Object)"a", (Object)"b"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.putAll(emptyMap));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.forEach((k, v) -> {}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.replaceAll((k, v) -> ""));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.replace((Object)"a", (Object)"b");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeMapView.replace((Object)"a", (Object)"b", (Object)"b2"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.computeIfAbsent((Object)"a", k -> "");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.computeIfPresent((Object)"a", (k, v) -> "");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.compute((Object)"a", (k, v) -> "");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)this.compositeMapView.merge((Object)"a", (Object)"b", (k, v) -> "");
        });
    }
}

